package com.digiwin.athena.adt.agileReport.controller.report;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.dap.middleware.lmc.appender.DwLogbackAppender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * 演示mock数据
 */
@RestController
@RequestMapping(value = "/api/ai/mock")
public class AgileReportMockController {

    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @GetMapping("/gpt")
    public ResponseEntity<?> mockGpt(@RequestParam(value = "mock", required = false) String mock,
                                             @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        stringRedisTemplate.opsForValue().set("mockGPT",mock);
        return ResponseEntityWrapper.wrapperOk(mock);
    }

}
