package com.digiwin.athena.adt.agileReport.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.adt.domain.po.SnapData;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Component;

import java.util.Collection;

@Component
public interface SnapShotDataMapper extends BaseMapper<SnapData> {

    /**
     * 获得dmcId
     * @param snapshotId
     * @param tenantId
     * @param userId
     * @return
     */
    String getDmcId(@Param("snapshotId") String snapshotId, @Param("tenantId") String tenantId, @Param("userId") String userId);

    /**
     * 更新读取次数
     * @param snapshotId
     * @param tenantId
     * @param userId
     * @return
     */
    int updateReadCount(@Param("snapshotId") String snapshotId,@Param("tenantId") String tenantId,@Param("userId") String userId);

    /**
     * 获取当前snapdata状态
     * @param snapshotId
     * @param tenantId
     * @param userId
     * @return
     */
    int updateSnapsStatue(@Param("snapshotId") String snapshotId,@Param("tenantId") String tenantId,@Param("userId") String userId);

    /**
     * 批量插入数据库
     * @param entityList
     * @return
     */
    int insertBatchSomeColumn(Collection<SnapData> entityList);

    /**
     * 删除失败次数+1
     */
    void incrementDeleteFailedCount(@Param("dmcId") String dmcId);

}
