package com.digiwin.athena.adt.agileReport.event.report;

import com.digiwin.athena.adt.agileReport.constant.event.EventMqConstants;
import com.digiwin.athena.adt.agileReport.event.domain.EventListenerDTO;
import com.digiwin.athena.adt.agileReport.event.service.ReportEventListenerService;
import com.digiwin.athena.adt.agileReport.service.EventBaseService;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.ExchangeTypes;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.support.AmqpHeaders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Map;

/**
 * 报表敏捷消息
 */
@Slf4j
@Component
public class ReportEventListener extends EventBaseService {

    @Autowired
    private ReportEventListenerService eventListenerService;

    /**
     * 消费SD下发的敏捷数据
     *
     * @param data
     * @param channel
     * @param tag
     * @throws IOException
     */
    @RabbitListener(bindings = @QueueBinding(
            value = @Queue(value = EventMqConstants.EVENT_MQ_QUEUE_NAME, durable = "true", autoDelete = "false"),
            exchange = @Exchange(value = EventMqConstants.EVENT_MQ_EXCHANGE_NAME, type = ExchangeTypes.TOPIC),
            key = EventMqConstants.EVENT_MQ_ROUTING_NAME
    ), concurrency = "2-4")
    public void receiveOrder(String data, Channel channel, @Header(AmqpHeaders.DELIVERY_TAG) long tag,
                             @Headers Map<String, Object> headers) throws IOException {
        super.receiveOrder(data, EventMqConstants.EVENT_MQ_QUEUE_NAME, channel, tag,headers);
    }


    /**
     * 订阅
     *
     * @param data
     * @param channel
     * @param tag
     * @throws IOException
     */
    @RabbitListener(bindings = @QueueBinding(
            value = @Queue(value = EventMqConstants.EVENT_MQ_QUEUE_SUBSCRIBE, durable = "true", autoDelete = "false"),
            exchange = @Exchange(value = EventMqConstants.EVENT_MQ_EXCHANGE_NAME, type = ExchangeTypes.TOPIC),
            key = EventMqConstants.EVENT_MQ_ROUTING_SUBSCRIBE
    ), concurrency = "2-4")
    public void subscribe(String data, Channel channel, @Header(AmqpHeaders.DELIVERY_TAG) long tag,
                          @Headers Map<String, Object> headers) throws IOException {
        super.receiveOrder(data, EventMqConstants.EVENT_MQ_QUEUE_SUBSCRIBE, channel, tag, headers);
    }

    @Override
    public void processMessage(String data, String queueName,Map<String, Object> headers) {
        //防止这块逻辑出现异常，统一加个事务回滚
        eventListenerService.processMsg(data, queueName,headers);
        LogDto logDto = new LogDto("消费消息成功", data);
        log.info(logDto.toString());
    }
}
