package com.digiwin.athena.adt.agileReport.event.service;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Service
public class EventModelService implements ApplicationContextAware {

    // 模板集合
    private Map<String, EventInterface> modelMap = new ConcurrentHashMap<>();


    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map<String, EventInterface> tempMap = applicationContext.getBeansOfType(EventInterface.class);
        tempMap.values().forEach(source -> modelMap.put(source.modelType(), source));
    }

    /**
     * 获取目标模板
     * @param modelType
     * @return
     */
    public EventInterface getTargetModel(String modelType){
        return Optional.ofNullable(modelMap.get(modelType))
                .orElseThrow(() -> new IllegalArgumentException("Event model acquisition failed"));
    }
}
