package com.digiwin.athena.adt.agileReport.event.service;

import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

@Slf4j
@Service
public class ReportEventListenerService {

    @Autowired
    private EventModelService eventModelService;

    /**
     * 处理消息
     *
     * @param data
     * @param queueName
     */
    public void processMsg(String data, String queueName, Map<String,Object> headers) {
        // 分发消息
        log.info("[athena.event.message.adt-data]: processMessage queueName = {}", JsonUtils.objectToString(queueName));
        eventModelService.getTargetModel(queueName).distributeMessages(data,headers);
    }

}
