package com.digiwin.athena.adt.agileReport.eventbus.subscriber;

import com.digiwin.athena.adt.agileReport.eventbus.AgileDataLogEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataMessageLogEventService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.google.common.eventbus.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class AgileDataLogEventSubscriber {

    @Autowired
    private AgileDataMessageLogEventService agileDataMessageLogEventService;

    /**
     * @param event
     */
    @Subscribe
    public void subscriber(AgileDataLogEvent event){
        try {
            AppAuthContextHolder.clearContext();
            processEvent(event);
        }catch (Exception ex){
            log.error("敏捷数据日志执行异常 error:{}, stack:{}，event:{}" ,ex, ex.getStackTrace(), event);
        }finally {
            AppAuthContextHolder.clearContext();
        }
    }



    /**
     * 异步队列处理，记录敏捷数据日志
     * @param event
     */
    private void processEvent(AgileDataLogEvent event){
        agileDataMessageLogEventService.processLog(event);
    }

}
