//package com.digiwin.athena.adt.agileReport.schedul;
//
//import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
//import com.digiwin.athena.adt.agileReport.dao.SnapShotDataMapper;
//import com.digiwin.athena.adt.domain.aam.AAMService;
//import com.digiwin.athena.adt.domain.po.SnapData;
//import com.digiwin.athena.atmc.http.restful.iam.TenantService;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.data.redis.core.StringRedisTemplate;
//import org.springframework.data.redis.core.ValueOperations;
//import org.springframework.scheduling.annotation.Scheduled;
//import org.springframework.stereotype.Component;
//
//import javax.annotation.Resource;
//import java.time.LocalDateTime;
//import java.time.format.DateTimeFormatter;
//import java.util.*;
//import java.util.concurrent.TimeUnit;
//import java.util.stream.Collectors;
//
///**
// * 间隔一段时间删除实时数据
// */
//@Component
//@Slf4j
//public class SchedulTask {
//    private static final int LIMIT_AMOUNT = 1000;
//
//    @Autowired
//    private SnapShotDataMapper snapShotDataMapper;
//    @Resource
//    private AAMService aamService;
//    @Autowired
//    TenantService tenantService;
//
//    @Autowired
//    private StringRedisTemplate stringRedisTemplate;
//    private static final String LOCK_KEY = "deleteRealtimeDataLock";
//    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
//    private static final long DELETE_FIXED_RATE = 5 * 60 * 1000L; // 定时任务运行周期：5分钟
//    private static final long LOCK_EXPIRE = 3; // redis锁时间 单位：秒
//    private static final String DMC_ID = "dmcId";
//    private static final String TENANT_ID = "tenantId";
//    private static final String REQUEST_TIME = "requestTime";
//    private static final String ENTRY = "entry";
//    private static final String DELETE_FAILED = "deleteFailed";
//
//
//    @Scheduled(fixedRate = DELETE_FIXED_RATE)
//    //@Scheduled(initialDelay = 6000, fixedRate = 2000)  //测试使用，每20秒执行一次
//    public void deleteRealtimeData() {
//        String lockValue = String.valueOf(System.currentTimeMillis() + LOCK_EXPIRE * 1000);
//        if (!tryAcquireLock(LOCK_KEY, lockValue, LOCK_EXPIRE)) {
//            log.info("任务获取锁失败");
//            return;
//        }
//
//        try {
//            LocalDateTime sevenDaysAgo = LocalDateTime.now().minusWeeks(1);
//            log.info("删除{}之前的实时数据", sevenDaysAgo.format(formatter));
//
//
//            //TODO 此处应该优先查询日志表，通过日志表拉取所有快照信息
//            //TODO 快照信息不存在，需要进行日志删除
//            //Integer limitNum = limitNumStr != null ? Integer.valueOf(limitNumStr) : 10;
//
//            QueryWrapper<SnapData> queryWrapper = new QueryWrapper<>();
//            queryWrapper.select(DMC_ID,TENANT_ID).lt(REQUEST_TIME, sevenDaysAgo)
//                    .eq(ENTRY, "1").le(DELETE_FAILED, 3)
//                    .orderByDesc(REQUEST_TIME).last(String.format("limit %d", LIMIT_AMOUNT));
//            List<SnapData> results = snapShotDataMapper.selectList(queryWrapper);
//            if (results.isEmpty()) {
//                log.info("没有找到符合条件的数据, 本次任务结束");
//                return;
//            }
//
//            //TODO 删除用户自定义拖拽信息
//            //TODO 删除多场景快照选择信息
//            //TODO 删除B娜历史消息
//
//            Map<String, List<String>> groupedByTenantId = results.stream()
//                    .collect(Collectors.groupingBy(SnapData::getTenantId,
//                            Collectors.mapping(SnapData::getDmcId, Collectors.toList())));
//
//            groupedByTenantId.forEach((tenantId, dmcIdList) -> {
//                try {
//                    //先删除数据库
//                    QueryWrapper<SnapData> deleteWrapper = new QueryWrapper<>();
//                    deleteWrapper.in(DMC_ID, dmcIdList);
//                    snapShotDataMapper.delete(deleteWrapper);
//                    //再删除aam
//                    String resultToken = tenantService.queryApiVirtualToken(tenantId).getString("token");
//                    aamService.deleteBatchAgileData(Collections.emptyList(), dmcIdList, resultToken);
//                } catch (Exception e) {
//                    log.error("删除TenantId为{}的数据失败，错误信息：{}", tenantId, e.getMessage());
//                    updateDeleteFailedCount(dmcIdList); // 记录删除失败数据
//                }
//            });
//        } catch (Exception ex) {
//            log.error("定时任务删除实时数据失败：{}, 此次任务结束等待下次继续删除", ex.getMessage(), ex);
//        } finally {
//            releaseLock(LOCK_KEY, lockValue);
//        }
//    }
//
//
//    /**
//     * 批量删除失败的数据，失败次数+1
//     */
//    private void updateDeleteFailedCount(Collection<String> dmcIds) {
//        if (dmcIds == null || dmcIds.isEmpty()) {
//            log.info("No dmcIds provided for updating delete failed count.");
//            return; // 直接返回，不执行任何后续操作
//        }
//        for (String dmcId : dmcIds) {
//            try {
//                snapShotDataMapper.incrementDeleteFailedCount(dmcId);
//            } catch (Exception e) {
//                log.error("Failed to increment deleteFailed for dmcId {}: {}", dmcId, e.getMessage());
//            }
//        }
//    }
//
//    /**
//     * 删除第一次删除失败数据
//     */
//    @Scheduled(cron = "0 0 0/1 * * ?" )  //测试使用，每小时执行一次
//    public void deleteFailData() {
//
//        try {
//            QueryWrapper<SnapData> queryWrapper = new QueryWrapper<>();
//            queryWrapper.select(DMC_ID,TENANT_ID).eq(ENTRY, "1").ge(DELETE_FAILED, 3)
//                    .orderByDesc(REQUEST_TIME).last("limit 10");
//            List<SnapData> results = snapShotDataMapper.selectList(queryWrapper);
//            if (results.isEmpty()) {
//                log.info("没有找到符合二次删除条件的数据, 本次二次删除任务结束");
//                return;
//            }
//
//            Map<String, List<String>> groupedByTenantId = results.stream()
//                    .collect(Collectors.groupingBy(SnapData::getTenantId,
//                            Collectors.mapping(SnapData::getDmcId, Collectors.toList())));
//
//            groupedByTenantId.forEach((tenantId, dmcIdList) -> {
//                try {
//                    //先删除数据库
//                    QueryWrapper<SnapData> deleteWrapper = new QueryWrapper<>();
//                    deleteWrapper.in(DMC_ID, dmcIdList);
//                    snapShotDataMapper.delete(deleteWrapper);
//                    //再删除aam
//                    String resultToken = tenantService.queryApiVirtualToken(tenantId).getString("token");
//                    aamService.deleteBatchAgileData(Collections.emptyList(), dmcIdList, resultToken);
//                    log.info("成功删除TenantId为{}的数据，DmcId列表：{}", tenantId, dmcIdList);
//                } catch (Exception e) {
//                    log.error("删除TenantId为{}的数据失败，错误信息：{}", tenantId, e.getMessage());
//                    updateDeleteFailedCount(dmcIdList); // 记录删除失败数据
//                }
//            });
//        } catch (Exception ex) {
//            log.error("定时二次删除任务实时数据失败：{}, 此次任务结束等待下次继续删除", ex.getMessage(), ex);
//        }
//    }
//
//    /**
//     * 获取redis锁
//     */
//    private boolean tryAcquireLock(String lockKey, String lockValue, long lockExpire) {
//        ValueOperations<String, String> ops = stringRedisTemplate.opsForValue();
//        Boolean acquired = ops.setIfAbsent(lockKey, lockValue, lockExpire, TimeUnit.SECONDS);
//        return Boolean.TRUE.equals(acquired);
//    }
//
//    /**
//     * 释放redis锁
//     */
//    private void releaseLock(String lockKey, String lockValue) {
//        ValueOperations<String, String> ops = stringRedisTemplate.opsForValue();
//        String currentValue = ops.get(lockKey);
//        if (lockValue.equals(currentValue)) {
//            stringRedisTemplate.delete(lockKey);
//            log.info("Lock released successfully.");
//        } else {
//            log.warn("Lock was already released or expired.");
//        }
//    }
//
//    /**
//     * 此方法用于更新从amtc获取到的缓存数据
//     */
//
///*    @Autowired
//    private ConfigService configService;
//    private static final long UPDATE_FIXED_RATE = 60 * 60 * 1000L;
//    private final long CACHE_DURATION_MINUTES = 120; // 缓存持续时间 单位：分钟
//
//    private final String CONFIG_KEY_PREFIX = "adtConfig:";
//    @Scheduled(initialDelay = 1000, fixedRate = UPDATE_FIXED_RATE)
//    public void updateConfigValue() {
//        String cacheKey = CONFIG_KEY_PREFIX;
//        String value = stringRedisTemplate.opsForValue().get(cacheKey);
//        if (value == null) {
//            Map<String, Object> result = configService.getValueConfig("5", 0, "deleteNum");
//            value = (String) result.get("response");
//            if (value != null) {
//                stringRedisTemplate.opsForValue().set(cacheKey, value, CACHE_DURATION_MINUTES, TimeUnit.MINUTES);
//            } else {
//                value = "10";
//            }
//        }
//        this.limitNumStr = value;
//    }*/
//
//
//}
//
//
