package com.digiwin.athena.adt.agileReport.service.impl.apc;

import com.digiwin.athena.adt.agileReport.controller.dto.AthenaApcMessageReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AthenaApcMessageResDTO;
import com.digiwin.athena.adt.agileReport.service.AgileApcDataService;
import com.digiwin.athena.adt.agileReport.service.AgileDataCostDetailService;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.apc.AgileAdeApcReqDTO;
import com.digiwin.athena.adt.domain.dto.km.KMApplicationApcResDTO;
import com.digiwin.athena.adt.domain.knowledge.KmService;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.concurrent.CompletableFuture;

/**
 * @Author: SunHong
 * @Date: 2024/8/13 19:14
 * @Description: apc 实现
 */
@Slf4j
@Service
public class AgileApcDataServiceImpl implements AgileApcDataService {

    @Resource
    private ADEService adeService;

    @Autowired
    private AgileDataCostDetailService agileDataCostDetailService;

    @Autowired
    private KmService kmService;

    /**
     * apc 取数实现
     * @param request 设计器请求
     * @param req 返回
     * @param user 用户信息
     * @return res
     */
    @Override
    public AthenaApcMessageResDTO processMessage(HttpServletRequest request, AthenaApcMessageReqDTO req, AuthoredUser user,String local) {

        AthenaApcMessageResDTO resDTO = new AthenaApcMessageResDTO();
        //记录全链路日志
        long getQuerySchemaTook = System.currentTimeMillis();
        log.error("apc 大屏 查询入参 ：{},{},{},{},{}",user.getUserId(),user.getUserName()
                ,user.getTenantId(),user.getTenantName(), JsonUtils.objectToString(req));
        LogDto logDto = new LogDto("apc 大屏 查询入参：" + JsonUtils.objectToString(req));
        SnapShotDTO result = new SnapShotDTO();
        log.info(logDto.toString());
        try{
            AgileAdeApcReqDTO agileAdeApcReqDTO = AgileAdeApcReqDTO.builderReq(req);
            if("sync-instant".equals(req.getRequestType())) {
                instantRequest(agileAdeApcReqDTO, user, resDTO,local);
            } else {
                syncRequest(agileAdeApcReqDTO, user, resDTO,local);
            }
        }catch (Exception e){
            log.error("AgileApcDataService processMessage Exception : {}",e.getMessage());
            resDTO.setSuccess(false);
        }
        log.error("apc 大屏 查询 出参：{},{},{},{},{},耗时:{}ms",user.getUserId(),user.getUserName()
                ,user.getTenantId(),user.getTenantName(),JsonUtils.objectToString(result),System.currentTimeMillis() - getQuerySchemaTook);
        return resDTO;
    }

    /**
     * 同步返回
     * @param agileAdeApcReqDTO 请求入参
     * @param user 用户信息
     * @param resDTO 返回
     */
    public void instantRequest(AgileAdeApcReqDTO agileAdeApcReqDTO, AuthoredUser user, AthenaApcMessageResDTO resDTO,String local) {
        SnapShotDTO result = adeService.reqApcSnapShotDataBySync(agileAdeApcReqDTO, user,local);
        if (Objects.nonNull(result)) {
            this.saveCostDetailByApcData(result,agileAdeApcReqDTO.getScreen().getSceneCode(),user);
            resDTO.setSuccess(true);
            resDTO.setSnapShotDTO(result);
        }
    }

    /**
     * 异步方法
     * @param agileAdeApcReqDTO 请求入参
     * @param user 用户信息
     * @param resDTO 返回
     */
    public void syncRequest(AgileAdeApcReqDTO agileAdeApcReqDTO, AuthoredUser user, AthenaApcMessageResDTO resDTO,String local) {
        resDTO.setSuccess(true);
        CompletableFuture.runAsync(() -> {
            SnapShotDTO result = adeService.reqApcSnapShotDataBySync(agileAdeApcReqDTO,user,local);
            this.saveCostDetailByApcData(result,agileAdeApcReqDTO.getScreen().getSceneCode(),user);
        });
    }

    /**
     * apc大屏计费
     * @param result ade返回数据
     */
    public void saveCostDetailByApcData(SnapShotDTO result,String sceneCode,AuthoredUser user) {
        if(StringUtils.isEmpty(result.getSnapshotId())){
            return;
        }
        String ptxId = JaMDC.getNotNullTraceId();
        MDC.put("traceId", ptxId);
        MDC.put("PtxId", ptxId);
        List<KMApplicationApcResDTO> apcRes = kmService.queryApplicationByCode(user,sceneCode);
        if(CollectionUtils.isNotEmpty(apcRes)){
            for(KMApplicationApcResDTO res : apcRes){
                String appCode = res.getCode();
                String appName = res.getName();
                // 保存计费平台数据
                agileDataCostDetailService.saveAgileDataCostDetail(CommonUtil.convertObjectToMap(result),user,ptxId
                        ,appCode,appName,"apc大屏");
            }
        }
    }
}
