package com.digiwin.athena.adt.agileReport.service.impl.calculate;

import com.digiwin.athena.adt.agileReport.dao.AgileDataCalculateConfigMapper;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateConfigService;
import com.digiwin.athena.adt.domain.cac.AthenaCacService;
import com.digiwin.athena.adt.domain.dto.cac.CacGoods;
import com.digiwin.athena.adt.domain.dto.km.KMIsBillingGoodsResDTO;
import com.digiwin.athena.adt.domain.dto.km.KMPurchaseModelResDTO;
import com.digiwin.athena.adt.domain.dto.km.KMUserAppCodesResDTO;
import com.digiwin.athena.adt.domain.knowledge.KmService;
import com.digiwin.athena.adt.domain.po.AgileDataCalculateConfig;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @Author: SunHong
 * @Date: 2024/7/25 10:39
 * @Description:
 */
@Slf4j
@Service
public class AgileDataCalculateConfigServiceImpl implements AgileDataCalculateConfigService {

    @Resource
    private AgileDataCalculateConfigMapper agileDataCalculateConfigMapper;

    @Autowired
    private AthenaCacService athenaCacService;

    @Autowired
    private KmService kmService;

    @Autowired
    private AgileDataCalculateConfigService agileDataCalculateConfigService;

    @Override
    public Object insert(AgileDataCalculateConfig agileDataCalculateConfig, AuthoredUser user) {
        agileDataCalculateConfig.setCreateDate(new Date());
        return agileDataCalculateConfigMapper.insert(agileDataCalculateConfig);
    }

    @Override
    public Object update(AgileDataCalculateConfig agileDataCalculateConfig, AuthoredUser user) {
        agileDataCalculateConfig.setModifyDate(new Date());
        return agileDataCalculateConfigMapper.updateById(agileDataCalculateConfig);
    }

    @Override
    public Object delete(AgileDataCalculateConfig agileDataCalculateConfig, AuthoredUser user) {
        long id = agileDataCalculateConfig.getId();
        return agileDataCalculateConfigMapper.deleteById(id);
    }

    /**
     * 如果 不存在数据则为第一次 需要提示是否超过阈值
     * 如果 查询到为1 则需要告警 其他为不需要告警
     * @param user 用户
     * @return 是否告警
     */
    @Override
    public boolean queryCalculateConfigByUser(AuthoredUser user) {
        String userId = user.getUserId();
        AgileDataCalculateConfig config = agileDataCalculateConfigMapper.queryCalculateConfigByUser(userId);
        if(Objects.isNull(config)){
            return true;
        }
        return "1".equals(config.getCalculateType());
    }

    @Override
    public void updateCalculateTypeByParam(String userId, String type) {
        agileDataCalculateConfigMapper.updateCalculateTypeByParam(userId, type);
    }

    @Override
    public CacGoods queryCalculateCacByConfig(AuthoredUser user) {
        AgileDataCalculateConfig config = agileDataCalculateConfigMapper.queryCalculateConfig();
        if(config == null){
            return new CacGoods();
        }
        return athenaCacService.getCacCurrentTenantGoods(user,config.getGoodsCode());
    }

    @Override
    public void deleteCalculateTypeByParam(String userId) {
        agileDataCalculateConfigMapper.deleteCalculateTypeByParam(userId);
    }


    /**
     * 根据用户信息查询是否开启计费应用
     * @param user 用户信息
     * @return KMIsBillingGoodsResDTO
     */
    @Override
    public KMIsBillingGoodsResDTO getIsBilling(AuthoredUser user) {
        KMIsBillingGoodsResDTO res = new KMIsBillingGoodsResDTO();
        AgileDataCalculateConfig config = agileDataCalculateConfigService.queryCalculateConfig();
        log.info("计费业务 查询配置流量包id:{}", JsonUtils.objectToString(config));
        if(Objects.isNull(config) || StringUtils.isEmpty(config.getGoodsCode())){
            return res;
        }
        String billingId = config.getGoodsCode();
        KMUserAppCodesResDTO userAppCodes =
                kmService.queryKmUserAppCodes(user.getToken(), user.getTenantId(),user.getUserId());
        if(Objects.isNull(userAppCodes) || CollectionUtils.isEmpty(userAppCodes.getAppCodes())){
            return res;
        }
        //是否存在流量应用id
        boolean isBillingId =  userAppCodes.getAppCodes().stream()
                .anyMatch(billingId::equals);
//        if(isBillingId){
//                List<KMPurchaseModelResDTO> kmPurchaseModelResDTOS =
//                        kmService.queryKmPurchaseList(user.getToken(), user.getTenantId(),user.getUserId());
//                // 存在流量应用并且存在计费应用
//                boolean isBilling = kmPurchaseModelResDTOS.stream()
//                        .anyMatch(b -> billingId.equals(b.getBillingGoodsId()));
                res.setBilling(isBillingId);
                res.setApplyCount(userAppCodes.getAppCodes().size());
//                }`
        log.info("计费业务 getIsBilling res :{}",JsonUtils.objectToString(res));
        return res;
    }

    @Override
    public AgileDataCalculateConfig queryCalculateConfig() {
        return agileDataCalculateConfigMapper.queryCalculateConfig();
    }

}
