package com.digiwin.athena.adt.agileReport.service.impl.calculate;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.adt.agileReport.dao.AgileDataConfigMapper;
import com.digiwin.athena.adt.agileReport.service.AgileDataConfigService;
import com.digiwin.athena.adt.domain.po.AgileDataConfig;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.concurrent.TimeUnit;

/**
 * @Author: SunHong
 * @Date: 2024/6/3 15:41
 * @Description:
 */
@Service
@Slf4j
public class AgileDataConfigServiceImpl implements AgileDataConfigService {

    private static final String TENANT_ID = "tenant_id";

    private static final String CONFIG_TYPE = "type";

    private static final String ECHO_CHARGING_KEY = "ECHO_CHARGING_KEY";

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Resource
    private AgileDataConfigMapper agileDataConfigMapper;

    @Override
    public Object insert(AgileDataConfig agileDataConfig, AuthoredUser user) {
        agileDataConfig.setCreateDate(new Date());
        return agileDataConfigMapper.insert(agileDataConfig);
    }

    @Override
    public Object update(AgileDataConfig agileDataConfig, AuthoredUser user) {
        agileDataConfig.setModifyDate(new Date());
        return agileDataConfigMapper.updateById(agileDataConfig);
    }

    @Override
    public Object delete(AgileDataConfig agileDataConfig, AuthoredUser user) {
        long id = agileDataConfig.getId();
        return agileDataConfigMapper.deleteById(id);
    }

    @Override
    public Object getUserValue(AuthoredUser user) {
        QueryWrapper<AgileDataConfig> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(TENANT_ID, user.getTenantId());
        AgileDataConfig agileDataConfig = agileDataConfigMapper.selectOne(queryWrapper);
        log.info("user agile data value : {}", agileDataConfig);
        int value = 0;
        if(agileDataConfig != null){
            value = agileDataConfig.getValue();
        }
        return value;
    }

    @Override
    public Object getUserValueByType(AuthoredUser user, String type) {
        QueryWrapper<AgileDataConfig> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(CONFIG_TYPE, type);
        AgileDataConfig agileDataConfig = agileDataConfigMapper.selectOne(queryWrapper);
        log.info("user agile data value : {}", agileDataConfig);
        Integer value = null;
        if(agileDataConfig != null){
            value = agileDataConfig.getValue();
        }
        return value;
    }
}
