package com.digiwin.athena.adt.agileReport.service.impl.classifications;

import com.digiwin.athena.adt.agileReport.dao.AgileDataClassificationsMapper;
import com.digiwin.athena.adt.agileReport.service.AgileDataClassificationsService;
import com.digiwin.athena.adt.domain.po.AgileDataClassifications;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @Author: SunHong
 * @Date: 2024/12/2 10:25
 * @Description: 分类服务实现类
 */
@Slf4j
@Service
public class AgileClassificationsServiceImpl implements AgileDataClassificationsService {

    @Resource
    private AgileDataClassificationsMapper agileDataClassificationsMapper;

    @Override
    public void insert(AgileDataClassifications agileDataClassifications, AuthoredUser user) {
        agileDataClassificationsMapper.insert(agileDataClassifications);
    }

    @Override
    public void update(AgileDataClassifications agileDataClassifications, AuthoredUser user) {
        agileDataClassificationsMapper.updateById(agileDataClassifications);
    }

    @Override
    public void delete(AgileDataClassifications agileDataClassifications, AuthoredUser user) {
        agileDataClassificationsMapper.deleteById(agileDataClassifications);
    }
}
