package com.digiwin.athena.adt.agileReport.service.impl.cost;

import com.digiwin.athena.adt.agileReport.dao.AgileDataCostDetailMapper;
import com.digiwin.athena.adt.agileReport.service.AgileDataCostDetailService;
import com.digiwin.athena.adt.domain.po.AgileDataCostDetail;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/12/2 10:25
 * @Description: 计费服务实现类
 */
@Slf4j
@Service
public class AgileDataCostDetailServiceImpl implements AgileDataCostDetailService {

    @Resource
    private AgileDataCostDetailMapper agileDataCostDetailMapper;

    @Override
    public void insert(AgileDataCostDetail agileDataCostDetail) {
        agileDataCostDetailMapper.insert(agileDataCostDetail);
    }

    @Override
    public void update(AgileDataCostDetail agileDataCostDetail) {
        agileDataCostDetailMapper.updateById(agileDataCostDetail);
    }

    @Override
    public void delete(AgileDataCostDetail agileDataCostDetail) {
        agileDataCostDetailMapper.deleteById(agileDataCostDetail);
    }

    /**
     * 保存计费中心指标记录数据
     * @param data ada result
     * @param user 用户信息
     */
    @Override
    public void saveAgileDataCostDetail(Map<String,Object> data,
                                        AuthoredUser user,
                                        String ptxId,
                                        String appId,
                                        String appName,
                                        String sourceName) {
        this.insert(AgileDataCostDetail.builderPerCost(user,ptxId,appId,appName,sourceName));
        this.insert(AgileDataCostDetail.builderTrafficCost(data,user,ptxId,appId,appName,sourceName));
    }
}
