//package com.digiwin.athena.adt.agileReport.service.impl.dmc;
//
//import java.awt.*;
//import java.io.ByteArrayInputStream;
//import java.io.IOException;
//import java.io.InputStream;
//import java.io.StringWriter;
//import java.net.HttpURLConnection;
//import java.net.URL;
//import java.net.URLDecoder;
//import java.nio.charset.StandardCharsets;
//import java.time.LocalDateTime;
//import java.time.format.DateTimeFormatter;
//import java.util.*;
//import java.util.List;
//import java.util.stream.Collectors;
//import javax.annotation.Resource;
//
//
//
//import com.digiwin.athena.appcore.util.Base64Converter;
//import com.digiwin.athena.appcore.util.JsonUtils;
//
//import org.apache.commons.collections.CollectionUtils;
//import org.apache.commons.io.IOUtils;
//import org.apache.commons.lang.BooleanUtils;
//import org.apache.commons.lang3.StringUtils;
//import org.apache.commons.lang3.exception.ExceptionUtils;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.core.ParameterizedTypeReference;
//import org.springframework.http.*;
//import org.springframework.stereotype.Service;
//import org.springframework.transaction.annotation.Propagation;
//import org.springframework.transaction.annotation.Transactional;
//import org.springframework.util.Assert;
//
//import org.springframework.web.client.RestTemplate;
//import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
//import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
//import com.baomidou.mybatisplus.core.toolkit.Wrappers;
//
//import com.digiwin.athena.aam.dao.entity.AttachmentEntity;
//import com.digiwin.athena.aam.dao.mapper.AttachmentMapper;
//import com.digiwin.athena.aam.infrastructure.dmc.DmcService;
//import com.digiwin.athena.aam.service.AttachmentService;
//import com.digiwin.athena.aam.util.CommonUtils;
//import com.digiwin.athena.aam.util.ConvertUtils;
//import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
//import com.digiwin.athena.appcore.exception.BusinessException;
//import lombok.extern.slf4j.Slf4j;
//
//import org.apache.commons.collections.MapUtils;
//
//import org.springframework.http.HttpMethod;
//
//import java.util.stream.Stream;
//
//@Slf4j
//@Service("attachmentService")
//public class AttachmentServiceImpl implements AttachmentService {
//    @Autowired
//    private AttachmentMapper attachmentMapper;
//
//    @Resource
//    private DmcService dmcService;
//
//    @Resource
//    private AttachmentServiceImpl attachmentService;
//
//    @Autowired
//    private RestTemplate restTemplate;
//
//
//    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
//
//    /**
//     * {@inheritDoc}
//     */
//    @Override
//    public List<AttachmentRespDTO> queryByTaskIdAndRowDataKeyList(String tenantId, String taskId, String projectId, List<String> categories, List<String> rowDataKeyList) {
//        String tmpTenantId = tenantId;
//        if (StringUtils.isBlank(tmpTenantId)) {
//            AuthoredUser authoredUser = CommonUtils.getAuthoredUserWithException();
//            tmpTenantId = authoredUser.getTenantId();
//        }
//
//        String tmpTaskId = StringUtils.isNotBlank(taskId) ? taskId : null;
//        String tmpProjectId = StringUtils.isNotBlank(projectId) ? projectId : null;
//
//        log.info("queryByTaskIdAndRowDataKeyList params: tenantId: {}, taskId: {}, projectId: {}, categories: {}, rowDataKeyList: {}", tmpTenantId, tmpTaskId, tmpProjectId, categories, rowDataKeyList);
//        List<AttachmentEntity> attachmentEntities = attachmentMapper.queryByTaskIdAndRowDataKeyList(tmpTenantId, tmpTaskId, tmpProjectId, categories, rowDataKeyList);
//        if (CollectionUtils.isEmpty(attachmentEntities)) {
//            return Collections.emptyList();
//        }
//
//        return attachmentEntities.stream().map(ConvertUtils::toAttachmentRespDTO).collect(Collectors.toList());
//    }
//
//    /**
//     * {@inheritDoc}
//     */
//    @Override
//    public List<AttachmentRespDTO> queryByTaskIdAndRowDataKeyList(QueryAttachmentReqDTO reqDTO) {
//        return this.queryByTaskIdAndRowDataKeyList(reqDTO.getTenantId(), reqDTO.getTaskId(), reqDTO.getProjectId(), reqDTO.getCategoryList(), reqDTO.getRowDataKeyList());
//    }
//
//    /**
//     * {@inheritDoc}
//     */
//    @Override
//    public void saveAttachment(AttachmentReqDTO attachmentFile) {
//        log.info("saveAttachment, body:{}", attachmentFile);
//        // 获取当前登录用户信息
//        AuthoredUser authoredUser = CommonUtils.getAuthoredUserWithException();
//
//        attachmentFile.setUploadUserId(authoredUser.getUserId());
//        attachmentFile.setUploadUserName(authoredUser.getUserName());
//
//        log.info("saveAttachment params: {}", attachmentFile);
//        attachmentMapper.insert(ConvertUtils.toAttachmentEntity(attachmentFile));
//    }
//
//    private void saveAttachment(List<AttachmentReqDTO> uploadedList) {
//        // 获取当前登录用户信息
//        AuthoredUser authoredUser = CommonUtils.getAuthoredUserWithException();
//        for (AttachmentReqDTO attachmentFile : uploadedList) {
//            attachmentFile.setUploadUserId(authoredUser.getUserId());
//            attachmentFile.setUploadUserName(authoredUser.getUserName());
//        }
//
//        attachmentMapper.insertBatchSomeColumn(ConvertUtils.toAttachmentEntity(uploadedList));
//    }
//
//    /**
//     * {@inheritDoc}
//     */
//    @Override
//    public void deleteAttachment(AttachmentReqDTO attachmentFile) {
//        log.info("deleteAttachment, body:{}", attachmentFile);
//        this.deleteAttachment(attachmentFile.getCategory(), attachmentFile.getCategoryId(), attachmentFile.getId());
//    }
//
//    private int deleteAttachment(String category, String categoryId, String id) {
//        LambdaQueryWrapper<AttachmentEntity> wrapper = Wrappers.lambdaQuery();
//        wrapper.eq(StringUtils.isNotBlank(category), AttachmentEntity::getCategory, category)
//                .eq(StringUtils.isNotBlank(categoryId), AttachmentEntity::getCategoryId, categoryId)
//                .eq(AttachmentEntity::getId, id);
//
//        return attachmentMapper.delete(wrapper);
//    }
//
//    private int deleteAttachment(String category, String categoryId, Collection<String> idList) {
//        LambdaQueryWrapper<AttachmentEntity> wrapper = Wrappers.lambdaQuery();
//        wrapper.eq(StringUtils.isNotBlank(category), AttachmentEntity::getCategory, category)
//                .eq(StringUtils.isNotBlank(categoryId), AttachmentEntity::getCategoryId, categoryId)
//                .in(AttachmentEntity::getId, idList);
//
//        return attachmentMapper.delete(wrapper);
//    }
//
//    /**
//     * {@inheritDoc}
//     */
//    @Override
//    public void uploadOrDeleteAttachment(UploadOrDeleteAttachmentReqDTO uploadOrDeleteAttachmentReqDTO) {
//        log.info("uploadOrDeleteAttachment, body:{}", uploadOrDeleteAttachmentReqDTO);
//        if (CollectionUtils.isNotEmpty(uploadOrDeleteAttachmentReqDTO.getUploadedFileList())) {
//            // 获取当前登录用户信息
//            AuthoredUser authoredUser = CommonUtils.getAuthoredUserWithException();
//
//            // 保存新增的附件, 通过【子事务】隔离保存操作
//            for (AttachmentReqDTO attachmentReqDTO : uploadOrDeleteAttachmentReqDTO.getUploadedFileList()) {
//                attachmentReqDTO.setUploadUserId(authoredUser.getUserId());
//                attachmentReqDTO.setUploadUserName(authoredUser.getUserName());
//            }
//            attachmentService.saveAttachmentInNewTransaction(uploadOrDeleteAttachmentReqDTO.getUploadedFileList());
//        }
//
//        if (CollectionUtils.isNotEmpty(uploadOrDeleteAttachmentReqDTO.getDeletedFileList())) {
//            Set<String> fileIdList = uploadOrDeleteAttachmentReqDTO.getDeletedFileList().stream()
//                    .map(AttachmentReqDTO::getId)
//                    .filter(id -> StringUtils.isNotBlank(id))
//                    .collect(Collectors.toSet());
//
//            // 通过【子事物】隔离删除操作
//            attachmentService.deleteAttachmentInNewTransaction(null, null, fileIdList);
//
//            // 调用dmc删除附件信息
//            if (BooleanUtils.isTrue(uploadOrDeleteAttachmentReqDTO.getNeedDeleteDmcFile())) {
//                dmcService.loginAndDeleteAttachment(Collections.emptyList(), fileIdList, null);
//            }
//        }
//    }
//
//    /**
//     * {@inheritDoc}
//     */
//    @Override
//    public void deleteAttachmentBatch(DeleteAttachmentReqDTO deleteAttachmentReqDTO) {
//        log.info("deleteAttachmentBatch, body:{}", deleteAttachmentReqDTO);
//
//        if (CollectionUtils.isNotEmpty(deleteAttachmentReqDTO.getDeleteFileList())) {
//            List<AttachmentReqDTO> deleteFileList = deleteAttachmentReqDTO.getDeleteFileList();
//            Map<String, DmcAccount> schemaDmcAccountMap = deleteAttachmentReqDTO.getSchemaDmcAccountMap();
//
//            if(MapUtils.isEmpty(schemaDmcAccountMap)){
//                Set<String> fileIdList = deleteAttachmentReqDTO.getDeleteFileList().stream()
//                        .map(AttachmentReqDTO::getId)
//                        .filter(id -> StringUtils.isNotBlank(id))
//                        .collect(Collectors.toSet());
//                // 调用dmc删除附件信息
//                dmcService.loginAndDeleteAttachment(Collections.emptyList(), fileIdList,null);
//                return;
//            }
//
//            for(AttachmentReqDTO attachmentReqDTO : deleteFileList){
//                Set<String> fileIdList = new HashSet<>();
//                fileIdList.add(attachmentReqDTO.getId());
//               DmcAccount dmcAccount = schemaDmcAccountMap.get(attachmentReqDTO.getTargetSchema());
//               if(null == dmcAccount){
//                   // 调用dmc删除附件信息
//                   dmcService.loginAndDeleteAttachment(Collections.emptyList(), fileIdList, null);
//               }else {
//                   // 将dmc密码进行 base64解密
//                   encodeDmcAccountPwd(dmcAccount);
//                   // hash加密
//                   encodeDmcAccountPwdByHash(dmcAccount);
//                   // 调用dmc删除附件信息
//                   dmcService.loginAndDeleteAttachment(Collections.emptyList(), fileIdList, dmcAccount);
//               }
//            }
//        }
//    }
//
//    /**
//     * 将dmc密码进行 base64解密
//     * @param dmcAccount
//     */
//    private static void encodeDmcAccountPwd(DmcAccount dmcAccount) {
//        if (null == dmcAccount || !BooleanUtils.isTrue(dmcAccount.isPasswordAlreadyEncoded()) || StringUtils.isBlank(dmcAccount.getPassword())) {
//            return;
//        }
//
//        dmcAccount.setPassword(Base64Converter.decode(dmcAccount.getPassword()));
//        dmcAccount.setPasswordAlreadyEncoded(false);
//    }
//
//    /**
//     * hash加密
//     * @param dmcAccount
//     */
//    private static void encodeDmcAccountPwdByHash(DmcAccount dmcAccount) {
//        if (null == dmcAccount || dmcAccount.isPasswordAlreadyEncoded() || StringUtils.isBlank(dmcAccount.getPassword())) {
//            return;
//        }
//
//        dmcAccount.setPassword(CommonUtils.sha256(dmcAccount.getPassword(),2));
//        dmcAccount.setPasswordAlreadyEncoded(true);
//    }
//
//    @Override
//    public String uploadAttachmentByUrl(UploadParamDTO uploadParamDTO) {
//        HttpURLConnection conn;
//        try {
//            URL url = new URL(uploadParamDTO.getDownloadUrl());
//            conn = (HttpURLConnection) url.openConnection();
//            conn.setRequestMethod(HttpMethod.GET.name());
//            conn.setConnectTimeout(20 * 1000);
//            conn.connect();
//            uploadParamDTO.setInputStream(conn.getInputStream());
//            if (uploadParamDTO.getInputStream().available() <= 0) {
//                throw new RuntimeException();
//            }
//            if (StringUtils.isBlank(uploadParamDTO.getDownloadName())) {
//                //应用未传downloadName 需要从url获取,都获取不到 适配成zip
//                String headerField = conn.getHeaderField("Content-Disposition");
//                if (headerField == null || !headerField.contains("filename=")) {
//                    String fileName = url.getFile();
//                    fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
//                    uploadParamDTO.setDownloadName(fileName);
//                    //自定义文件名称
////                    String filename = UUID.randomUUID().toString();
////                    String fileType = FileTypeUtil.getType(uploadParamDTO.getInputStream());
////                    uploadParamDTO.setDownloadName(filename + "." + (StringUtils.isNotBlank(fileType) ? fileType : "zip"));
//                } else {
//                    uploadParamDTO.setDownloadName(URLDecoder.decode((headerField.substring(headerField.lastIndexOf("filename=") + 9)), "UTF-8").replaceAll("\"", ""));
//                }
//            }
//        } catch (Exception e) {
//            throw BusinessException.create(500, "文件内容为空,文件链接失效", ExceptionUtils.getRootCause(e));
//        }
//        if (StringUtils.isBlank(uploadParamDTO.getExpireDate())) {
//            LocalDateTime localDateTime = LocalDateTime.now().plusYears(1);
//            uploadParamDTO.setExpireDate(dateFormat.format(localDateTime));
//        }
//        //上传和分享文档获取url
//        Optional<ShareAttachmentRespDTO> shareAttachmentRespDTO = dmcService.uploadAndShareAttachment(uploadParamDTO);
//        return shareAttachmentRespDTO.map(ShareAttachmentRespDTO::getUrl).orElse(null);
//    }
//
//    /**
//     * 上传文档
//     * @param uploadParamDTO
//     * @return
//     */
//    @Override
//    public UploadAttachmentRespDTO uploadAgileReport(UploadParamDTO uploadParamDTO) {
//        if(StringUtils.isEmpty(uploadParamDTO.getFileJson())){
//            return null;
//        }
//        try {
//            InputStream inputStream = new ByteArrayInputStream(uploadParamDTO.getFileJson().getBytes());
//            uploadParamDTO.setInputStream(inputStream);
//            if (uploadParamDTO.getInputStream().available() <= 0) {
//                throw new RuntimeException();
//            }
//            uploadParamDTO.setDownloadName(uploadParamDTO.getDownloadName() + ".json");
//        } catch (Exception e) {
//            throw BusinessException.create(500, "文件内容为空,文件链接失效", ExceptionUtils.getRootCause(e));
//        }
//        //上传和分享文档获取url
//        return dmcService.uploadAttachment(uploadParamDTO);
//    }
//
//
//    @Override
//    public Integer attachUploadedCount(AttachUploadedCountDTO attachUploadedCountDTO) {
//
//        QueryWrapper<AttachmentEntity> queryWrapper = new QueryWrapper<>();
//        queryWrapper.lambda().eq(AttachmentEntity::getRowDataKey,attachUploadedCountDTO.getRowDataKey())
//                .in(AttachmentEntity::getCategory,attachUploadedCountDTO.getCategoryList())
//                .eq(AttachmentEntity::getTenantId,attachUploadedCountDTO.getTenantId())
//                .eq(StringUtils.isNotBlank(attachUploadedCountDTO.getTaskId()),AttachmentEntity::getTaskId,attachUploadedCountDTO.getTaskId())
//                .eq(StringUtils.isNotBlank(attachUploadedCountDTO.getProjectId()),AttachmentEntity::getProjectId,attachUploadedCountDTO.getProjectId());
//        return attachmentMapper.selectCount(queryWrapper);
//    }
//
//    @Override
//    public boolean checkUploadCount(AttachmentReqDTO attachmentFile) {
//
//        if (null != attachmentFile.getAllowCount() && attachmentFile.getCheckCount()){
//            AttachUploadedCountDTO attachUploadedCountDTO = AttachUploadedCountDTO.builder()
//                    .rowDataKey(attachmentFile.getRowDataKey())
//                    .tenantId(attachmentFile.getTenantId())
//                    .taskId(attachmentFile.getTaskId())
//                    .projectId(attachmentFile.getProjectId())
//                    .categoryList(Collections.singletonList(attachmentFile.getCategory())).build();
//            Integer uploadedCount = attachUploadedCount(attachUploadedCountDTO);
//            return uploadedCount >= attachmentFile.getAllowCount();
//        }
//        return false;
//    }
//
//    /**
//     * 获取报表文档
//     * @param fileId
//     * @return
//     */
//    @Override
//    public Map<String,Object> getFile(String fileId) {
//        InputStream inputStream = dmcService.previewFile(fileId);
//        try {
//            String result = IOUtils.toString(inputStream,StandardCharsets.UTF_8);
//            if(StringUtils.isNotEmpty(result)){
//                return JsonUtils.jsonToObject(result,Map.class);
//            }
//        } catch (IOException e) {
//            log.error("获取敏捷报表数据异常："+e.getMessage());
//        }
//        return null;
//    }
//
//    @Override
//    public Map<String,Object> deleteFile(String fileId) {
//        return dmcService.deleteFile(fileId);
//    }
//
//    @Transactional(propagation = Propagation.REQUIRES_NEW)
//    public void saveAttachmentInNewTransaction(List<AttachmentReqDTO> uploadedList) {
//        saveAttachment(uploadedList);
//    }
//
//    @Transactional(propagation = Propagation.REQUIRES_NEW)
//    public int deleteAttachmentInNewTransaction(String category, String categoryId, Collection<String> idList) {
//        return deleteAttachment(category, categoryId, idList);
//    }
//
//    @Override
//    public Object download(AttachmentDownloadReqDTO attachmentDownloadReqDTO) {
//        //入参内容校验
//        checkDownloadContent(attachmentDownloadReqDTO);
//        // 设置响应头
//        HttpHeaders responseHeaders = new HttpHeaders();
//        responseHeaders.setContentType(MediaType.APPLICATION_OCTET_STREAM);
//        responseHeaders.setContentDispositionFormData("attachment", attachmentDownloadReqDTO.getFileName() + "." + attachmentDownloadReqDTO.getSuffixName());
//        //fileUrl不为空 设置水印 （图纸控件场景）
//        if (StringUtils.isNotBlank(attachmentDownloadReqDTO.getFileUrl())) {
//            return ResponseEntity.ok()
//                    .headers(responseHeaders)
//                    .body(drawingControl(attachmentDownloadReqDTO));
//        }
//
//        //fileId 不为空 先添加水印 在打成zip包 并设置解压密码
//        AttachmentDownloadReqDTO.DmcAccount dmcAccount = attachmentDownloadReqDTO.getDmcAccount();
//        //获取dmc token
//        String token = getDmcToken(dmcAccount);
//        //调用dmc获取附件
//        ResponseEntity<byte[]> responseEntity = this.dmcService.getAttachment(attachmentDownloadReqDTO.getFileId(), token);
//        //如果没有获取到文件内容，返回空文件 不进行压缩
//        if (Objects.isNull(responseEntity.getBody())) {
//            return ResponseEntity.ok()
//                    .headers(responseHeaders)
//                    .body(responseEntity);
//        }
//
//        //文件存在添加水印
//        byte[] bytes = convertToWatermark(attachmentDownloadReqDTO, responseEntity.getBody());
//        //根据密码判断是否需要压缩成zip包设置压缩密码 没有设置密码直接返回文件
//        if (Objects.isNull(attachmentDownloadReqDTO.getSecurity()) || StringUtils.isBlank(attachmentDownloadReqDTO.getSecurity().getDefence())) {
//            return ResponseEntity.ok()
//                    .headers(responseHeaders)
//                    .body(bytes);
//        }
//
//        //打成zip包设置密码
//        byte[] zipFile = convertToZip(attachmentDownloadReqDTO, bytes);
//        responseHeaders.setContentDispositionFormData("attachment", attachmentDownloadReqDTO.getFileName() + ".zip");
//        return ResponseEntity.ok()
//                .headers(responseHeaders)
//                .body(zipFile);
//    }
//
//    /**
//     * 将文件打成zip包
//     *
//     * @param attachmentDownloadReqDTO
//     * @return
//     */
//    private byte[] convertToZip(AttachmentDownloadReqDTO attachmentDownloadReqDTO, byte[] fileBytes) {
//        //根据密码判断是否需要压缩成zip包设置压缩密码 没有设置密码直接返回文件
//        if (Objects.isNull(attachmentDownloadReqDTO.getSecurity()) || StringUtils.isBlank(attachmentDownloadReqDTO.getSecurity().getDefence())) {
//            return fileBytes;
//        }
//        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileBytes);
//        try {
//            fileBytes = ZipUtils.extracted(byteArrayInputStream, Base64Converter.decode(attachmentDownloadReqDTO.getSecurity().getDefence()), attachmentDownloadReqDTO.getFileName() + "." + attachmentDownloadReqDTO.getSuffixName());
//        } catch (IOException e) {
//            log.error("ZipUtils.extracted fileId:" + e.getMessage());
//        }
//        // 返回文件内容和响应头
//        return fileBytes;
//    }
//
//    /**
//     * 加密、水印下载附件内容校验
//     *
//     * @param attachmentDownloadReqDTO
//     */
//    private void checkDownloadContent(AttachmentDownloadReqDTO attachmentDownloadReqDTO) {
//        String fileId = attachmentDownloadReqDTO.getFileId();
//        String fileUrl = attachmentDownloadReqDTO.getFileUrl();
//        Assert.hasText(attachmentDownloadReqDTO.getFileName(), "Parameter fileName must not be null");
//        Assert.hasText(attachmentDownloadReqDTO.getSuffixName(), "Parameter suffixName must not be null");
//        Assert.isTrue(StringUtils.isNotBlank(fileId)
//                || StringUtils.isNotBlank(fileUrl), "Parameter fileId fileUrl at least one is not empty");
//    }
//
//    /**
//     * 设置水印
//     *
//     * @param attachmentDownloadReqDTO
//     * @param file
//     * @return
//     */
//    private byte[] convertToWatermark(AttachmentDownloadReqDTO attachmentDownloadReqDTO, byte[] file) {
//        AttachmentDownloadReqDTO.Watermark watermark = attachmentDownloadReqDTO.getWatermark();
//        boolean flag = Stream.of("jpg", "jpeg", "gif", "bmp", "png", "pic", "pdf").anyMatch(attachmentDownloadReqDTO.getSuffixName()::equalsIgnoreCase);
//        //为空不需要设置水印 不是pdf或者图片 不需要设置水印
//        if (Objects.isNull(watermark) || StringUtils.isBlank(watermark.getTopWatermarkText())  || !flag) {
//            return file;
//        }
//        //设置pdf水印
//        if ("pdf".equalsIgnoreCase(attachmentDownloadReqDTO.getSuffixName())) {
//            try {
//                return WatermarkUtil.addWatermarkPdf(file, watermark);
//            } catch (Exception e) {
//                log.error("WatermarkUtil.addWatermarkPdf failed:", e);
//            }
//        }
//        //设置图片水印
//        try {
//            return WatermarkUtil.addWatermarkImage(file, watermark, attachmentDownloadReqDTO.getSuffixName());
//        } catch (Exception e) {
//            log.error("WatermarkUtil.addWatermarkImage failed:", e);
//        }
//        return file;
//    }
//
//    /**
//     * 调用ksc获取文件
//     *
//     * @param url ksc url
//     * @return
//     */
//    private byte[] getKsc(String url) {
//        HttpHeaders headers = new HttpHeaders();
//        headers.setContentType(MediaType.APPLICATION_JSON);
//        HttpEntity<Map<String, Object>> httpEntity = new HttpEntity<>(headers);
//        try {
//            ResponseEntity<byte[]> responseEntity =
//                    restTemplate.exchange(url, HttpMethod.GET, httpEntity,
//                            new ParameterizedTypeReference<byte[]>() {
//                            });
//            return responseEntity.getBody();
//        } catch (Exception ex) {
//            log.error("ksc failed, url: {}", url, ex);
//            throw BusinessException.create("ksc failed, error: " + ex.getMessage());
//        }
//    }
//
//    /**
//     * 图纸控件处理
//     *
//     * @param attachmentDownloadReqDTO
//     * @return
//     */
//    private byte[] drawingControl(AttachmentDownloadReqDTO attachmentDownloadReqDTO) {
//        String fileUrl = attachmentDownloadReqDTO.getFileUrl();
//        //调用ksc获取文件
//        byte[] ksc = getKsc(fileUrl);
//        return convertToWatermark(attachmentDownloadReqDTO, ksc);
//    }
//
//    /**
//     * 从dmc获取token
//     *
//     * @param dmcAccount
//     * @return
//     */
//    private String getDmcToken(AttachmentDownloadReqDTO.DmcAccount dmcAccount) {
//        //使用dmc系统账号
//        if (Objects.isNull(dmcAccount) || Objects.isNull(dmcAccount.getAccount()) || Objects.isNull(dmcAccount.getPassword())) {
//            return this.dmcService.login(null, null);
//        } else {
//            String account = dmcAccount.getAccount();
//            String password = dmcAccount.getPassword();
//            Boolean isPasswordAlreadyEncoded = dmcAccount.getIsPasswordAlreadyEncoded();
//            if (Objects.isNull(isPasswordAlreadyEncoded) || !isPasswordAlreadyEncoded) {
//                //base64解密
//                String decodePassword = Base64Converter.decode(dmcAccount.getPassword());
//                //hash加密
//                password = CommonUtils.sha256(decodePassword, 2);
//            }
//            return this.dmcService.login(account, password);
//        }
//    }
//}
