package com.digiwin.athena.adt.agileReport.service.impl.log;

import com.digiwin.athena.adt.agileReport.eventbus.AgileDataLogEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataMessageLogEventService;
import com.digiwin.athena.adt.agileReport.service.AgileReportLogMongoService;
import com.digiwin.athena.adt.agileReport.service.AgileReportLogMysqlService;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.google.common.collect.Maps;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Objects;

@Service
public class AgileDataMessageLogEventServiceImpl implements AgileDataMessageLogEventService {

    @Autowired
    private AgileReportLogMongoService agileReportLogMongoService;

    @Autowired
    private AgileReportLogMysqlService agileReportLogMysqlService;

    @Qualifier("ADEServiceImpl")
    @Autowired
    private ADEService adeService;

    @Async("asyncLogServiceExecutor")
    @Override
    public void processLog(AgileDataLogEvent event) {
        AppAuthContextHolder.clearContext();
        Map<String, Object> schemaMap = Maps.newHashMap();
        //只有记录业务数据时，才需要查询sql
        if(event.isMessageGet() && Objects.nonNull(event.getAdeScencDTO())){
            Map<String,Object> queryMap = adeService.getSchemaSQLNoGPT(event);
            schemaMap = MapUtils.getMap(queryMap,"data",Maps.newHashMap());
        }
        //记录mongo日志，点赞/点踩信息
        agileReportLogMongoService.saveLog(event,schemaMap);
        //记录mysql日志，供tbb查询
        agileReportLogMysqlService.saveLog(event,schemaMap);
    }
}
