package com.digiwin.athena.adt.agileReport.service.impl.process.agileData;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.event.domain.SendMessageReqDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.AgileDataType;
import com.digiwin.athena.adt.agileReport.service.AgileDataProcessService;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/8/15 14:34
 * @Description:
 */
@Slf4j
@Service
@AgileDataType(value = AgileDataEnum.MOCK)
public class AgileDataProcessMockServiceImpl extends AbsAgileDataProcess implements AgileDataProcessService {

    @Autowired
    private SemcService semcService;

    public void process(AthenaMessageEvent event, QuerySchemaResDTO responseData) {
        String snapshotId = "";

        String question = event.getQuestion();
        if("今年接单金额".equals(question)){
            snapshotId = "ADE_Snapshot--AthenaHZTest----20240815141651-39fb57e2-dcb2-464d-87fb-973006188b1e";
        }else if ("今年接单趋势".equals(question)) {
            snapshotId = "ADE_Snapshot--AthenaHZTest----20240815141924-26601e3a-b9a1-4a16-bee4-01d23c8d1f10";
        }else if ("今年接单排名前五的部门".equals(question)){
            snapshotId = "ADE_Snapshot--AthenaHZTest----20240815142143-e1a4a667-fd72-44d5-ac55-002e42675597";
        }else if ("今年客户回款金额".equals(question)){
            snapshotId = "ADE_Snapshot--AthenaHZTest----20240815144136-55a9e8cb-1ec5-44a6-bacc-a8d3c0793c34";
        }else if ("今年各业务员的回款情况".equals(question)){
            snapshotId = "ADE_Snapshot--AthenaHZTest----20240815142340-56cb9ed9-a77d-4018-a14b-a9156209e222";
        }else if ("今年订单金额准交率".equals(question)){
            snapshotId = "ADE_Snapshot--AthenaHZTest----20240724172512-036feb7f-025f-4da0-aa7a-9edad133d55d";
        }
//        SnapShotDTO snapShotDTO = snapShotDataService.getSnapShotData(snapshotId,"AthenaHZTest",event.getUser().getUserId());
//        if(snapShotDTO == null){
//            if("今年接单金额".equals(question)){
//                snapShotDTO = questionS202405090008();
//            }else if ("今年接单趋势".equals(question)) {
//                snapShotDTO = questionS202405090009();
//            }else if ("今年接单排名前五的部门".equals(question)){
//                snapShotDTO = questionS202405090016();
//            }else if ("今年客户回款金额".equals(question)){
//                snapShotDTO = questionS20240814103533U55AVsNj();
//            }else if ("今年各业务员的回款情况".equals(question)){
//                snapShotDTO = questionS202405090032();
//            }
//        }
        Map<String,Object> sendMap = Maps.newHashMap();
        sendMap.put("snapshotId",snapshotId);
        semcService.sendMessageToGpt(event,sendMap);
    }

    public SnapShotDTO questionS202405090008 (){
        SnapShotDTO snapShotDTO = new SnapShotDTO();
        String msg = "{\"snapshotId\":\"ADE_Snapshot--AthenaHZTest----20240815141651-39fb57e2-dcb2-464d-87fb-973006188b1e\",\"context\":{\"bizParams\":{\"eocMaps\":[{\"eocCompanyId\":\"zc001\",\"eocCompanyName\":\"zc001\"},{\"eocCompanyId\":\"Z03\",\"eocCompanyName\":\"Z03\"},{\"eocCompanyId\":\"Z02\",\"eocCompanyName\":\"Z02\"},{\"eocCompanyId\":\"Z01\",\"eocCompanyName\":\"Z01\"},{\"eocCompanyId\":\"J02\",\"eocCompanyName\":\"德华\"},{\"eocCompanyId\":\"J01\",\"eocCompanyName\":\"J01\"},{\"eocCompanyId\":\"gbq01\",\"eocCompanyName\":\"gbq01\"},{\"eocCompanyId\":\"default\",\"eocCompanyName\":\"预设公司别\"},{\"eocCompanyId\":\"B01\",\"eocCompanyName\":\"B01\"},{\"eocCompanyId\":\"987\",\"eocCompanyName\":\"987\"},{\"eocCompanyId\":\"2\",\"eocCompanyName\":\"郴州东佳电子\"},{\"eocCompanyId\":\"1229\",\"eocCompanyName\":\"1229\"},{\"eocCompanyId\":\"1\",\"eocCompanyName\":\"深圳东佳电子\"},{\"eocCompanyId\":\"00D01\",\"eocCompanyName\":\"00D01\"},{\"eocCompanyId\":\"zc03\",\"eocCompanyName\":\"zc03\"},{\"eocCompanyId\":\"007\",\"eocCompanyName\":\"007\"},{\"eocCompanyId\":\"ZC01\",\"eocCompanyName\":\"ZC01\"},{\"eocCompanyId\":\"Cm01\",\"eocCompanyName\":\"Cm01\"},{\"eocCompanyId\":\"5\",\"eocCompanyName\":\"深圳冠华电子\"},{\"eocCompanyId\":\"15\",\"eocCompanyName\":\"yrr周边有限公司\"},{\"eocCompanyId\":\"0324\",\"eocCompanyName\":\"陈扬公司\"},{\"eocCompanyId\":\"16\",\"eocCompanyName\":\"顶峰昆山公司19458\"},{\"eocCompanyId\":\"3\",\"eocCompanyName\":\"香港东佳电子\"}],\"requestPerson\":\"sunhonga@digiwin.com\",\"requestTime\":\"2024-08-1514:16:51\",\"tenantId\":\"AthenaHZTest\",\"requestType\":\"instant\",\"monitor\":{},\"querySchema\":{},\"sceneDefine\":{\"status\":\"1\"},\"recast\":{\"S202405090008\":[{\"condition\":{\"logitype\":\"and\",\"items\":[]},\"name\":\"filter\",\"technique\":\"filter\"},{\"name\":\"choose\",\"technique\":\"chooseColumn\",\"fields\":[\"DOCAMT_sum\"],\"type\":\"retain\"},{\"name\":\"dataDisplay\",\"fields\":[{\"field\":\"DOCAMT_sum\"}],\"type\":\"show\"},{\"condition\":{\"fields\":[],\"statistics\":[{\"statisticalMethod\":\"sum\",\"newField\":\"DOCAMT_sum\",\"language\":{\"title\":{\"zh_TW\":\"訂單金額\",\"zh_CN\":\"订单金额\"}},\"title\":\"订单金额\",\"lang\":{\"title\":{\"zh_TW\":\"訂單金額\",\"zh_CN\":\"订单金额\"}},\"type\":\"number\",\"percent\":\"thousand\",\"statisticalFields\":[\"DOCAMT\"]}]},\"name\":\"measure\",\"technique\":\"group\"}]},\"backRecast\":{\"S202405090008\":[{\"condition\":{\"logitype\":\"and\",\"items\":[{\"op\":\"gte\",\"left\":\"DOCDATE\",\"left_date_format\":\"yyyy-MM-dd\",\"right_value_type\":\"datetime\",\"right\":\"2024-01-01\",\"type\":\"constant\",\"logitype\":\"single\",\"right_date_format\":\"yyyy-MM-dd\",\"left_value_type\":\"string\"},{\"op\":\"lte\",\"left\":\"DOCDATE\",\"left_date_format\":\"yyyy-MM-dd\",\"right_value_type\":\"datetime\",\"right\":\"2024-12-31\",\"type\":\"constant\",\"logitype\":\"single\",\"right_date_format\":\"yyyy-MM-dd\",\"left_value_type\":\"string\"}]},\"name\":\"filter\",\"technique\":\"filter\"}]},\"dimensionCnt\":0,\"param\":{\"DOCDATE\":\"2024-01-01#2024-12-31\"},\"question\":\"今年接单金额\"},\"scene\":{\"who\":[{\"type\":\"user\",\"value\":[{\"roles\":[],\"name\":\"孙宏\",\"id\":\"sunhonga@digiwin.com\",\"sid\":7.82266903382016E14}]}],\"when\":[{}],\"what\":[{\"type\":\"realTimeQuery\",\"value\":\"DATA_PULLING_gYe6YKZE\"}],\"where\":[],\"terminal\":[]},\"pullData\":[{\"actionId\":\"DATA_PULLING_gYe6YKZE\",\"sceneCode\":\"S202405090008\",\"startTime\":\"2024-08-1514:16:51\",\"endTime\":\"2024-08-1514:16:54\",\"data\":{\"data\":[{\"DOCAMT_sum\":1.515729685E8}]},\"metadata\":{\"request\":{\"parameters\":[{\"data_name\":\"data\",\"is_array\":true,\"field\":[{\"data_name\":\"customer_no\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"客户编号\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"CUSTOMERNAME\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"客户名称\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"item_no\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"品号\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"ITEMNAME\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"品名\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"sales_department_no\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"销售部门编号\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"ADMINUNITNAME\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"部门名称\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"salesman_no\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"业务员编号\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"EMPLOYEENAME\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"业务员\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"DOCAMT\",\"is_array\":false,\"field\":[],\"data_type\":\"numeric\",\"description\":\"订单金额\",\"can_filter\":false,\"can_sort\":false,\"decimal\":0,\"is_businesskey\":false,\"percent\":\"thousand\",\"required\":\"false\"}],\"data_type\":\"object\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"}]},\"response\":{\"data\":{\"data_name\":\"data\",\"data_type\":\"object\",\"required\":\"false\",\"is_array\":false,\"is_businesskey\":false,\"can_sort\":false,\"can_filter\":false,\"field\":[{\"data_name\":\"DOCAMT_sum\",\"data_type\":\"numeric\",\"required\":\"false\",\"is_array\":false,\"is_businesskey\":false,\"description\":\"订单金额\",\"can_sort\":false,\"can_filter\":false,\"percent\":\"thousand\",\"decimal\":\"0\",\"field\":[]}]}},\"actionId\":\"DATA_PULLING_gYe6YKZE\"},\"dataTag\":{\"name\":\"dataDisplay\",\"fields\":[{\"field\":\"DOCAMT_sum\"}],\"type\":\"show\"}}]}}";
        Gson gson = new Gson();
        return gson.fromJson(msg,snapShotDTO.getClass());
    }

    public SnapShotDTO questionS202405090009 (){
        SnapShotDTO snapShotDTO = new SnapShotDTO();
        String msg = "{\"snapshotId\":\"ADE_Snapshot--AthenaHZTest----20240815141924-26601e3a-b9a1-4a16-bee4-01d23c8d1f10\",\"context\":{\"bizParams\":{\"eocMaps\":[{\"eocCompanyId\":\"zc001\",\"eocCompanyName\":\"zc001\"},{\"eocCompanyId\":\"Z03\",\"eocCompanyName\":\"Z03\"},{\"eocCompanyId\":\"Z02\",\"eocCompanyName\":\"Z02\"},{\"eocCompanyId\":\"Z01\",\"eocCompanyName\":\"Z01\"},{\"eocCompanyId\":\"J02\",\"eocCompanyName\":\"德华\"},{\"eocCompanyId\":\"J01\",\"eocCompanyName\":\"J01\"},{\"eocCompanyId\":\"gbq01\",\"eocCompanyName\":\"gbq01\"},{\"eocCompanyId\":\"default\",\"eocCompanyName\":\"预设公司别\"},{\"eocCompanyId\":\"B01\",\"eocCompanyName\":\"B01\"},{\"eocCompanyId\":\"987\",\"eocCompanyName\":\"987\"},{\"eocCompanyId\":\"2\",\"eocCompanyName\":\"郴州东佳电子\"},{\"eocCompanyId\":\"1229\",\"eocCompanyName\":\"1229\"},{\"eocCompanyId\":\"1\",\"eocCompanyName\":\"深圳东佳电子\"},{\"eocCompanyId\":\"00D01\",\"eocCompanyName\":\"00D01\"},{\"eocCompanyId\":\"zc03\",\"eocCompanyName\":\"zc03\"},{\"eocCompanyId\":\"007\",\"eocCompanyName\":\"007\"},{\"eocCompanyId\":\"ZC01\",\"eocCompanyName\":\"ZC01\"},{\"eocCompanyId\":\"Cm01\",\"eocCompanyName\":\"Cm01\"},{\"eocCompanyId\":\"5\",\"eocCompanyName\":\"深圳冠华电子\"},{\"eocCompanyId\":\"15\",\"eocCompanyName\":\"yrr周边有限公司\"},{\"eocCompanyId\":\"0324\",\"eocCompanyName\":\"陈扬公司\"},{\"eocCompanyId\":\"16\",\"eocCompanyName\":\"顶峰昆山公司19458\"},{\"eocCompanyId\":\"3\",\"eocCompanyName\":\"香港东佳电子\"}],\"requestPerson\":\"sunhonga@digiwin.com\",\"requestTime\":\"2024-08-1514:19:24\",\"tenantId\":\"AthenaHZTest\",\"requestType\":\"instant\",\"monitor\":{},\"querySchema\":{},\"sceneDefine\":{\"status\":\"1\"},\"recast\":{\"S202405090009\":[{\"condition\":{\"logitype\":\"and\",\"items\":[]},\"name\":\"filter\",\"technique\":\"filter\"},{\"condition\":{\"fields\":[],\"statistics\":[{\"mode\":\"normal\",\"statisticalMethod\":\"sort\",\"type\":\"asc\",\"statisticalFields\":[\"MONTH\"]}]},\"name\":\"sort\",\"technique\":\"group\"},{\"name\":\"choose\",\"technique\":\"chooseColumn\",\"fields\":[\"DOCAMTlastyear_sum\",\"DOCAMT_sum\",\"MONTH\"],\"type\":\"retain\"},{\"name\":\"dataDisplay\",\"fields\":[{\"field\":\"DOCAMTlastyear_sum\"},{\"field\":\"DOCAMT_sum\"},{\"field\":\"MONTH\"}],\"type\":\"show\"},{\"condition\":{\"fields\":[\"MONTH\"],\"statistics\":[{\"statisticalMethod\":\"sum\",\"newField\":\"DOCAMT_sum\",\"language\":{\"title\":{\"zh_TW\":\"訂單金額\",\"zh_CN\":\"订单金额\"}},\"title\":\"订单金额\",\"lang\":{\"title\":{\"zh_TW\":\"訂單金額\",\"zh_CN\":\"订单金额\"}},\"type\":\"number\",\"percent\":\"thousand\",\"statisticalFields\":[\"DOCAMT\"]},{\"statisticalMethod\":\"sum\",\"newField\":\"DOCAMTlastyear_sum\",\"language\":{\"title\":{\"zh_TW\":\"同期訂單金額\",\"zh_CN\":\"同期订单金额\"}},\"title\":\"同期订单金额\",\"lang\":{\"title\":{\"zh_TW\":\"同期訂單金額\",\"zh_CN\":\"同期订单金额\"}},\"type\":\"number\",\"percent\":\"thousand\",\"statisticalFields\":[\"DOCAMTlastyear\"]}]},\"name\":\"measure\",\"technique\":\"group\"}]},\"backRecast\":{\"S202405090009\":[{\"condition\":{\"logitype\":\"and\",\"items\":[{\"op\":\"gte\",\"left\":\"DOCDATE\",\"left_date_format\":\"yyyy-MM-dd\",\"right_value_type\":\"datetime\",\"right\":\"2024-01-01\",\"type\":\"constant\",\"logitype\":\"single\",\"right_date_format\":\"yyyy-MM-dd\",\"left_value_type\":\"string\"},{\"op\":\"lte\",\"left\":\"DOCDATE\",\"left_date_format\":\"yyyy-MM-dd\",\"right_value_type\":\"datetime\",\"right\":\"2024-12-31\",\"type\":\"constant\",\"logitype\":\"single\",\"right_date_format\":\"yyyy-MM-dd\",\"left_value_type\":\"string\"}]},\"name\":\"filter\",\"technique\":\"filter\"}]},\"dimensionCnt\":0,\"param\":{\"DOCDATE\":\"2024-01-01#2024-12-31\"},\"question\":\"今年接单趋势\"},\"scene\":{\"who\":[{\"type\":\"user\",\"value\":[{\"roles\":[],\"name\":\"孙宏\",\"id\":\"sunhonga@digiwin.com\",\"sid\":7.82266903382016E14}]}],\"when\":[{}],\"what\":[{\"type\":\"realTimeQuery\",\"value\":\"DATA_PULLING_n81Td2T4\"}],\"where\":[],\"terminal\":[]},\"pullData\":[{\"actionId\":\"DATA_PULLING_n81Td2T4\",\"sceneCode\":\"S202405090009\",\"startTime\":\"2024-08-1514:19:25\",\"endTime\":\"2024-08-1514:19:28\",\"data\":{\"data\":[{\"MONTH\":\"01月\",\"DOCAMTlastyear_sum\":41209600,\"DOCAMT_sum\":52585378},{\"MONTH\":\"02月\",\"DOCAMTlastyear_sum\":58575760,\"DOCAMT_sum\":62963645},{\"MONTH\":\"03月\",\"DOCAMTlastyear_sum\":29985900,\"DOCAMT_sum\":3.60239455E7},{\"MONTH\":\"04月\",\"DOCAMTlastyear_sum\":50242500,\"DOCAMT_sum\":0},{\"MONTH\":\"05月\",\"DOCAMTlastyear_sum\":71420900,\"DOCAMT_sum\":0},{\"MONTH\":\"06月\",\"DOCAMTlastyear_sum\":57375540,\"DOCAMT_sum\":0},{\"MONTH\":\"07月\",\"DOCAMTlastyear_sum\":55275895,\"DOCAMT_sum\":0},{\"MONTH\":\"08月\",\"DOCAMTlastyear_sum\":49555205,\"DOCAMT_sum\":0},{\"MONTH\":\"09月\",\"DOCAMTlastyear_sum\":5.40657224E7,\"DOCAMT_sum\":0},{\"MONTH\":\"10月\",\"DOCAMTlastyear_sum\":76760338,\"DOCAMT_sum\":0},{\"MONTH\":\"11月\",\"DOCAMTlastyear_sum\":96977582,\"DOCAMT_sum\":0},{\"MONTH\":\"12月\",\"DOCAMTlastyear_sum\":91116530,\"DOCAMT_sum\":0}]},\"metadata\":{\"request\":{\"parameters\":[{\"data_name\":\"data\",\"is_array\":true,\"field\":[{\"data_name\":\"CUSTOMERCODE\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"客户编号\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"customer_shortname\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"客户简称\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"CUSTOMERNAME\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"客户名称\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"ADMIN_UNIT_CODE\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"行政单元编码\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"ADMIN_UNIT_NAME\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"行政单元名称\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"item_no\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"品号\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"ITEMNAME\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"品名\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"DOCAMT\",\"is_array\":false,\"field\":[],\"data_type\":\"numeric\",\"description\":\"订单金额\",\"can_filter\":false,\"can_sort\":false,\"decimal\":2,\"is_businesskey\":false,\"percent\":\"thousand\",\"required\":\"false\"},{\"data_name\":\"this_month\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"今年月份\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"thisYearMonth\",\"is_array\":false,\"field\":[],\"data_type\":\"date\",\"description\":\"本期年月\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"so_date\",\"is_array\":false,\"field\":[],\"data_type\":\"date\",\"description\":\"订单日期\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"DOCAMTlastyear\",\"is_array\":false,\"field\":[],\"data_type\":\"numeric\",\"description\":\"同期订单金额\",\"can_filter\":false,\"can_sort\":false,\"decimal\":2,\"is_businesskey\":false,\"percent\":\"thousand\",\"required\":\"false\"},{\"data_name\":\"last_month\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"去年月份\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"MONTH\",\"is_array\":false,\"field\":[],\"data_type\":\"date\",\"description\":\"月份\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"}],\"data_type\":\"object\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"}]},\"response\":{\"data\":{\"data_name\":\"data\",\"data_type\":\"object\",\"required\":\"false\",\"is_array\":false,\"is_businesskey\":false,\"can_sort\":false,\"can_filter\":false,\"field\":[{\"data_name\":\"DOCAMTlastyear_sum\",\"data_type\":\"numeric\",\"required\":\"false\",\"is_array\":false,\"is_businesskey\":false,\"description\":\"同期订单金额\",\"can_sort\":false,\"can_filter\":false,\"percent\":\"thousand\",\"decimal\":\"2\",\"field\":[]},{\"data_name\":\"DOCAMT_sum\",\"data_type\":\"numeric\",\"required\":\"false\",\"is_array\":false,\"is_businesskey\":false,\"description\":\"订单金额\",\"can_sort\":false,\"can_filter\":false,\"percent\":\"thousand\",\"decimal\":\"2\",\"field\":[]},{\"data_name\":\"MONTH\",\"data_type\":\"date\",\"required\":\"false\",\"is_array\":false,\"is_businesskey\":false,\"description\":\"月份\",\"can_sort\":false,\"can_filter\":false,\"field\":[]}]}},\"actionId\":\"DATA_PULLING_n81Td2T4\"},\"dataTag\":{\"name\":\"dataDisplay\",\"fields\":[{\"field\":\"DOCAMTlastyear_sum\"},{\"field\":\"DOCAMT_sum\"},{\"field\":\"MONTH\"}],\"type\":\"show\"}}]}}";
        Gson gson = new Gson();
        return gson.fromJson(msg,snapShotDTO.getClass());
    }

    public SnapShotDTO questionS202405090016 (){
        SnapShotDTO snapShotDTO = new SnapShotDTO();
        String msg = "{\"snapshotId\":\"ADE_Snapshot--AthenaHZTest----20240815142143-e1a4a667-fd72-44d5-ac55-002e42675597\",\"context\":{\"bizParams\":{\"eocMaps\":[{\"eocCompanyId\":\"zc001\",\"eocCompanyName\":\"zc001\"},{\"eocCompanyId\":\"Z03\",\"eocCompanyName\":\"Z03\"},{\"eocCompanyId\":\"Z02\",\"eocCompanyName\":\"Z02\"},{\"eocCompanyId\":\"Z01\",\"eocCompanyName\":\"Z01\"},{\"eocCompanyId\":\"J02\",\"eocCompanyName\":\"德华\"},{\"eocCompanyId\":\"J01\",\"eocCompanyName\":\"J01\"},{\"eocCompanyId\":\"gbq01\",\"eocCompanyName\":\"gbq01\"},{\"eocCompanyId\":\"default\",\"eocCompanyName\":\"预设公司别\"},{\"eocCompanyId\":\"B01\",\"eocCompanyName\":\"B01\"},{\"eocCompanyId\":\"987\",\"eocCompanyName\":\"987\"},{\"eocCompanyId\":\"2\",\"eocCompanyName\":\"郴州东佳电子\"},{\"eocCompanyId\":\"1229\",\"eocCompanyName\":\"1229\"},{\"eocCompanyId\":\"1\",\"eocCompanyName\":\"深圳东佳电子\"},{\"eocCompanyId\":\"00D01\",\"eocCompanyName\":\"00D01\"},{\"eocCompanyId\":\"zc03\",\"eocCompanyName\":\"zc03\"},{\"eocCompanyId\":\"007\",\"eocCompanyName\":\"007\"},{\"eocCompanyId\":\"ZC01\",\"eocCompanyName\":\"ZC01\"},{\"eocCompanyId\":\"Cm01\",\"eocCompanyName\":\"Cm01\"},{\"eocCompanyId\":\"5\",\"eocCompanyName\":\"深圳冠华电子\"},{\"eocCompanyId\":\"15\",\"eocCompanyName\":\"yrr周边有限公司\"},{\"eocCompanyId\":\"0324\",\"eocCompanyName\":\"陈扬公司\"},{\"eocCompanyId\":\"16\",\"eocCompanyName\":\"顶峰昆山公司19458\"},{\"eocCompanyId\":\"3\",\"eocCompanyName\":\"香港东佳电子\"}],\"requestPerson\":\"sunhonga@digiwin.com\",\"requestTime\":\"2024-08-1514:21:43\",\"tenantId\":\"AthenaHZTest\",\"requestType\":\"instant\",\"monitor\":{},\"querySchema\":{},\"sceneDefine\":{\"status\":\"1\"},\"recast\":{\"S202405090016\":[{\"condition\":{\"logitype\":\"and\",\"items\":[]},\"name\":\"filter\",\"technique\":\"filter\"},{\"condition\":{\"fields\":[],\"statistics\":[{\"mode\":\"normal\",\"statisticalMethod\":\"sort\",\"type\":\"desc\",\"statisticalFields\":[\"DOCAMT\"]}]},\"name\":\"sort\",\"technique\":\"group\"},{\"condition\":{\"fields\":[],\"statistics\":[{\"statisticalMethod\":\"limit\",\"startPos\":\"0\",\"endPos\":\"4\"}]},\"name\":\"limit\",\"technique\":\"group\"},{\"name\":\"calculate\",\"rule\":[{\"fieldA\":\"DOCAMT\",\"precision\":\"2\",\"retain\":false,\"newField\":\"difference\",\"language\":{\"title\":{\"zh_TW\":\"差異量\",\"en_US\":\"差异量\",\"zh_CN\":\"差异量\"}},\"title\":\"差异量\",\"fieldB\":\"DOCAMTlastmonth\",\"percent\":\"thousand\",\"showStyle\":\"thousand\",\"valueType\":\"number\",\"calcType\":\"Minus\",\"name\":\"差异量\",\"lang\":{\"name\":{\"zh_TW\":\"差異量\",\"en_US\":\"差异量\",\"zh_CN\":\"差异量\"},\"title\":{\"zh_TW\":\"差異量\",\"zh_CN\":\"差异量\"}}},{\"showStyle\":\"thousand\",\"fieldA\":\"DOCAMTlastmonth\",\"precision\":\"2\",\"valueType\":\"number\",\"calcType\":\"Abs\",\"retain\":false,\"name\":\"同期绝对值\",\"newField\":\"DOCAMTlastmonth_abs\",\"language\":{\"title\":{\"zh_TW\":\"同期絕對值\",\"en_US\":\"同期绝对值\",\"zh_CN\":\"同期绝对值\"}},\"lang\":{\"name\":{\"zh_TW\":\"同期絕對值\",\"en_US\":\"同期绝对值\",\"zh_CN\":\"同期绝对值\"},\"title\":{\"zh_TW\":\"同期絕對值\",\"zh_CN\":\"同期绝对值\"}},\"title\":\"同期绝对值\",\"percent\":\"thousand\"},{\"fieldA\":\"difference\",\"precision\":\"4\",\"retain\":true,\"newField\":\"GROWTHRATE\",\"language\":{\"title\":{\"zh_TW\":\"增長率\",\"en_US\":\"增长率\",\"zh_CN\":\"增长率\"}},\"title\":\"增长率\",\"fieldB\":\"DOCAMTlastmonth_abs\",\"percent\":\"percent\",\"showStyle\":\"percent\",\"valueType\":\"number\",\"calcType\":\"Divide\",\"name\":\"增长率\",\"lang\":{\"name\":{\"zh_TW\":\"增長率\",\"en_US\":\"增长率\",\"zh_CN\":\"增长率\"},\"title\":{\"zh_TW\":\"增長率\",\"zh_CN\":\"增长率\"}}}],\"technique\":\"calculate\"},{\"name\":\"choose\",\"technique\":\"chooseColumn\",\"fields\":[\"ADMINUNITNAME\",\"GROWTHRATE\",\"DOCAMTlastmonth\",\"DOCAMT\"],\"type\":\"retain\"},{\"name\":\"dataDisplay\",\"fields\":[{\"field\":\"ADMINUNITNAME\"},{\"field\":\"GROWTHRATE\"},{\"field\":\"DOCAMTlastmonth\"},{\"field\":\"DOCAMT\"}],\"type\":\"show\"}]},\"backRecast\":{\"S202405090016\":[{\"condition\":{\"logitype\":\"and\",\"items\":[{\"op\":\"gte\",\"left\":\"DOCDATE\",\"left_date_format\":\"yyyy-MM-dd\",\"right_value_type\":\"datetime\",\"right\":\"2024-01-01\",\"type\":\"constant\",\"logitype\":\"single\",\"right_date_format\":\"yyyy-MM-dd\",\"left_value_type\":\"datetime\"},{\"op\":\"lte\",\"left\":\"DOCDATE\",\"left_date_format\":\"yyyy-MM-dd\",\"right_value_type\":\"datetime\",\"right\":\"2024-12-31\",\"type\":\"constant\",\"logitype\":\"single\",\"right_date_format\":\"yyyy-MM-dd\",\"left_value_type\":\"datetime\"}]},\"name\":\"filter\",\"technique\":\"filter\"},{\"condition\":{\"fields\":[],\"statistics\":[{\"statisticalMethod\":\"limit\",\"startPos\":\"0\",\"endPos\":\"4\",\"direction\":\"head\"}]},\"name\":\"limit\",\"technique\":\"group\"},{\"condition\":{\"fields\":[],\"statistics\":[{\"mode\":\"normal\",\"statisticalMethod\":\"sort\",\"type\":\"desc\",\"statisticalFields\":[]}]},\"name\":\"sort\",\"technique\":\"group\"}]},\"dimensionInterval\":{\"data\":[{\"filed\":\"DOCDATE\",\"interval\":\"2024-01-01#2024-12-31\"}]},\"dimensionCnt\":1,\"param\":{\"DOCDATE\":\"2024-01-01#2024-12-31\"},\"question\":\"今年接单排名前五的部门\"},\"scene\":{\"who\":[{\"type\":\"user\",\"value\":[{\"roles\":[],\"name\":\"孙宏\",\"id\":\"sunhonga@digiwin.com\",\"sid\":7.82266903382016E14}]}],\"when\":[{}],\"what\":[{\"type\":\"realTimeQuery\",\"value\":\"DATA_PULLING_oT15zke5\"}],\"where\":[],\"terminal\":[]},\"pullData\":[{\"actionId\":\"DATA_PULLING_oT15zke5\",\"sceneCode\":\"S202405090016\",\"startTime\":\"2024-08-1514:21:43\",\"endTime\":\"2024-08-1514:21:47\",\"data\":{\"data\":[{\"DOCAMT\":75407035,\"ADMINUNITNAME\":\"外贸二部\",\"sales_department_no\":\"10\",\"DOCAMTlastmonth\":3.226753014E8,\"GROWTHRATE\":-0.7663},{\"DOCAMT\":7.13526635E7,\"ADMINUNITNAME\":\"外贸一部\",\"sales_department_no\":\"03\",\"DOCAMTlastmonth\":303837311,\"GROWTHRATE\":-0.7652},{\"DOCAMT\":4813270,\"ADMINUNITNAME\":\"国内业务部\",\"sales_department_no\":\"11\",\"DOCAMTlastmonth\":106048860,\"GROWTHRATE\":-0.9546}]},\"metadata\":{\"request\":{\"parameters\":[{\"data_name\":\"data\",\"is_array\":true,\"field\":[{\"data_name\":\"sales_department_no\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"销售部门编号\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"ADMINUNITNAME\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"部门名称\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"DOCAMT\",\"is_array\":false,\"field\":[],\"data_type\":\"numeric\",\"description\":\"订单金额\",\"can_filter\":false,\"can_sort\":false,\"decimal\":2,\"is_businesskey\":false,\"percent\":\"thousand\",\"required\":\"false\"},{\"data_name\":\"DOCAMTlastmonth\",\"is_array\":false,\"field\":[],\"data_type\":\"numeric\",\"description\":\"同期订单金额\",\"can_filter\":false,\"can_sort\":false,\"decimal\":2,\"is_businesskey\":false,\"percent\":\"thousand\",\"required\":\"false\"}],\"data_type\":\"object\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"}]},\"response\":{\"data\":{\"data_name\":\"data\",\"data_type\":\"object\",\"required\":\"false\",\"is_array\":false,\"is_businesskey\":false,\"can_sort\":false,\"can_filter\":false,\"field\":[{\"data_name\":\"ADMINUNITNAME\",\"data_type\":\"string\",\"required\":\"false\",\"is_array\":false,\"is_businesskey\":false,\"description\":\"部门名称\",\"can_sort\":false,\"can_filter\":false,\"field\":[]},{\"data_name\":\"GROWTHRATE\",\"data_type\":\"numeric\",\"is_array\":false,\"description\":\"增长率\",\"percent\":\"percent\",\"decimal\":\"2\",\"field\":[]},{\"data_name\":\"DOCAMTlastmonth\",\"data_type\":\"numeric\",\"required\":\"false\",\"is_array\":false,\"is_businesskey\":false,\"description\":\"同期订单金额\",\"can_sort\":false,\"can_filter\":false,\"percent\":\"thousand\",\"decimal\":\"2\",\"field\":[]},{\"data_name\":\"DOCAMT\",\"data_type\":\"numeric\",\"required\":\"false\",\"is_array\":false,\"is_businesskey\":false,\"description\":\"订单金额\",\"can_sort\":false,\"can_filter\":false,\"percent\":\"thousand\",\"decimal\":\"2\",\"field\":[]}]}},\"actionId\":\"DATA_PULLING_oT15zke5\"},\"dataTag\":{\"name\":\"dataDisplay\",\"fields\":[{\"field\":\"ADMINUNITNAME\"},{\"field\":\"GROWTHRATE\"},{\"field\":\"DOCAMTlastmonth\"},{\"field\":\"DOCAMT\"}],\"type\":\"show\"}}]}}";
        Gson gson = new Gson();
        return gson.fromJson(msg,snapShotDTO.getClass());
    }

    public SnapShotDTO questionS20240814103533U55AVsNj (){
        SnapShotDTO snapShotDTO = new SnapShotDTO();
        String msg = "{\"snapshotId\":\"ADE_Snapshot--AthenaHZTest----20240815144136-55a9e8cb-1ec5-44a6-bacc-a8d3c0793c34\",\"context\":{\"bizParams\":{\"eocMaps\":[{\"eocCompanyId\":\"zc001\",\"eocCompanyName\":\"zc001\"},{\"eocCompanyId\":\"Z03\",\"eocCompanyName\":\"Z03\"},{\"eocCompanyId\":\"Z02\",\"eocCompanyName\":\"Z02\"},{\"eocCompanyId\":\"Z01\",\"eocCompanyName\":\"Z01\"},{\"eocCompanyId\":\"J02\",\"eocCompanyName\":\"德华\"},{\"eocCompanyId\":\"J01\",\"eocCompanyName\":\"J01\"},{\"eocCompanyId\":\"gbq01\",\"eocCompanyName\":\"gbq01\"},{\"eocCompanyId\":\"default\",\"eocCompanyName\":\"预设公司别\"},{\"eocCompanyId\":\"B01\",\"eocCompanyName\":\"B01\"},{\"eocCompanyId\":\"987\",\"eocCompanyName\":\"987\"},{\"eocCompanyId\":\"2\",\"eocCompanyName\":\"郴州东佳电子\"},{\"eocCompanyId\":\"1229\",\"eocCompanyName\":\"1229\"},{\"eocCompanyId\":\"1\",\"eocCompanyName\":\"深圳东佳电子\"},{\"eocCompanyId\":\"00D01\",\"eocCompanyName\":\"00D01\"},{\"eocCompanyId\":\"zc03\",\"eocCompanyName\":\"zc03\"},{\"eocCompanyId\":\"007\",\"eocCompanyName\":\"007\"},{\"eocCompanyId\":\"ZC01\",\"eocCompanyName\":\"ZC01\"},{\"eocCompanyId\":\"Cm01\",\"eocCompanyName\":\"Cm01\"},{\"eocCompanyId\":\"5\",\"eocCompanyName\":\"深圳冠华电子\"},{\"eocCompanyId\":\"15\",\"eocCompanyName\":\"yrr周边有限公司\"},{\"eocCompanyId\":\"0324\",\"eocCompanyName\":\"陈扬公司\"},{\"eocCompanyId\":\"16\",\"eocCompanyName\":\"顶峰昆山公司19458\"},{\"eocCompanyId\":\"3\",\"eocCompanyName\":\"香港东佳电子\"}],\"requestPerson\":\"sunhonga@digiwin.com\",\"requestTime\":\"2024-08-1514:41:36\",\"tenantId\":\"AthenaHZTest\",\"requestType\":\"instant\",\"monitor\":{},\"querySchema\":{},\"sceneDefine\":{\"status\":\"1\"},\"recast\":{\"S20240814103533U55AVsNj\":[{\"condition\":{\"logitype\":\"and\",\"items\":[]},\"name\":\"filter\",\"technique\":\"filter\"},{\"condition\":{\"fields\":[],\"statistics\":[{\"mode\":\"normal\",\"statisticalMethod\":\"sort\",\"type\":\"desc\",\"statisticalFields\":[\"PAYBACKAMT\"]}]},\"name\":\"sort\",\"technique\":\"group\"},{\"name\":\"choose\",\"technique\":\"chooseColumn\",\"fields\":[\"CUSTOMERNAME\",\"PAYBACKAMT\"],\"type\":\"retain\"},{\"name\":\"dataDisplay\",\"fields\":[{\"field\":\"CUSTOMERNAME\"},{\"field\":\"PAYBACKAMT\",\"businessType\":\"amount\",\"explanation\":\"PAYBACKAMT\"}],\"type\":\"show\"}]},\"backRecast\":{\"S20240814103533U55AVsNj\":[{\"condition\":{\"logitype\":\"and\",\"items\":[{\"op\":\"gte\",\"left\":\"BOOKKEEPINGDATE\",\"left_date_format\":\"yyyy-MM-dd\",\"right_value_type\":\"datetime\",\"right\":\"2024-01-01\",\"type\":\"constant\",\"logitype\":\"single\",\"right_date_format\":\"yyyy-MM-dd\",\"left_value_type\":\"string\"},{\"op\":\"lte\",\"left\":\"BOOKKEEPINGDATE\",\"left_date_format\":\"yyyy-MM-dd\",\"right_value_type\":\"datetime\",\"right\":\"2024-12-31\",\"type\":\"constant\",\"logitype\":\"single\",\"right_date_format\":\"yyyy-MM-dd\",\"left_value_type\":\"string\"}]},\"name\":\"filter\",\"technique\":\"filter\"}]},\"dimensionCnt\":1,\"param\":{\"BOOKKEEPINGDATE\":\"2024-01-01#2024-12-31\"},\"question\":\"今年客户回款金额\"},\"scene\":{\"who\":[{\"type\":\"user\",\"value\":[{\"roles\":[],\"name\":\"孙宏\",\"id\":\"sunhonga@digiwin.com\",\"sid\":7.82266903382016E14}]}],\"when\":[{}],\"what\":[{\"type\":\"realTimeQuery\",\"value\":\"DATA_PULLING_TW9W4n13\"}],\"where\":[],\"terminal\":[]},\"pullData\":[{\"actionId\":\"DATA_PULLING_TW9W4n13\",\"sceneCode\":\"S20240814103533U55AVsNj\",\"startTime\":\"2024-08-1514:41:36\",\"endTime\":\"2024-08-1514:41:40\",\"data\":{\"data\":[{\"TA004\":\"10004\",\"TC004\":\"10004\",\"PAYBACKAMT\":36985760,\"CUSTOMERNAME\":\"上海大宏控股集团股份有限公司\",\"REMAINRECDOCAMT\":-36985760},{\"TA004\":\"10003\",\"TC004\":\"10003\",\"PAYBACKAMT\":33330880,\"CUSTOMERNAME\":\"江苏恒泰科技有限公司\",\"REMAINRECDOCAMT\":-33330880},{\"TA004\":\"10001\",\"TC004\":\"10001\",\"PAYBACKAMT\":32812190,\"CUSTOMERNAME\":\"浙江德元贸易有限公司\",\"REMAINRECDOCAMT\":-32812190},{\"TA004\":\"10002\",\"TC004\":\"10002\",\"PAYBACKAMT\":32761600,\"CUSTOMERNAME\":\"广东鲲鹏实业有限公司\",\"REMAINRECDOCAMT\":-32761600},{\"TA004\":\"10008\",\"TC004\":\"10008\",\"PAYBACKAMT\":14131238,\"CUSTOMERNAME\":\"星程科技有限公司\",\"REMAINRECDOCAMT\":-14131238},{\"TA004\":\"10006\",\"TC004\":\"10006\",\"PAYBACKAMT\":10055000,\"CUSTOMERNAME\":\"台信工贸有限公司\",\"REMAINRECDOCAMT\":-10055000},{\"TA004\":\"10005\",\"TC004\":\"10005\",\"PAYBACKAMT\":8825425,\"CUSTOMERNAME\":\"福建福磊股份有限公司\",\"REMAINRECDOCAMT\":-8825425},{\"TA004\":\"10007\",\"TC004\":\"10007\",\"PAYBACKAMT\":8151983,\"CUSTOMERNAME\":\"鼎鸿控股集团股份有限公司\",\"REMAINRECDOCAMT\":-8151983},{\"TA004\":\"10010\",\"TC004\":\"10010\",\"PAYBACKAMT\":7303597,\"CUSTOMERNAME\":\"宏伟科技有限公司\",\"REMAINRECDOCAMT\":-7303597},{\"TA004\":\"10009\",\"TC004\":\"10009\",\"PAYBACKAMT\":4582910,\"CUSTOMERNAME\":\"银河实业有限公司\",\"REMAINRECDOCAMT\":-4582910}]},\"metadata\":{\"request\":{\"parameters\":[{\"data_name\":\"data\",\"is_array\":true,\"field\":[{\"data_name\":\"TC004\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"客户代号\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"CUSTOMERNAME\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"客户名称\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"PAYBACKAMT\",\"is_array\":false,\"field\":[],\"data_type\":\"numeric\",\"description\":\"回款金额\",\"can_filter\":false,\"can_sort\":false,\"decimal\":2,\"is_businesskey\":false,\"percent\":\"thousand\",\"required\":\"false\"},{\"data_name\":\"TA004\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"客户代号\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"RECEIVABLEDOCAMT\",\"is_array\":false,\"field\":[],\"data_type\":\"numeric\",\"description\":\"应收金额\",\"can_filter\":false,\"can_sort\":false,\"decimal\":2,\"is_businesskey\":false,\"percent\":\"thousand\",\"required\":\"false\"},{\"data_name\":\"REMAINRECDOCAMT\",\"is_array\":false,\"field\":[],\"data_type\":\"numeric\",\"description\":\"未收金额\",\"can_filter\":false,\"can_sort\":false,\"decimal\":2,\"is_businesskey\":false,\"percent\":\"thousand\",\"required\":\"false\"}],\"data_type\":\"object\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"}]},\"response\":{\"data\":{\"data_name\":\"data\",\"data_type\":\"object\",\"required\":\"false\",\"is_array\":false,\"is_businesskey\":false,\"can_sort\":false,\"can_filter\":false,\"field\":[{\"data_name\":\"CUSTOMERNAME\",\"data_type\":\"string\",\"required\":\"false\",\"is_array\":false,\"is_businesskey\":false,\"description\":\"客户名称\",\"can_sort\":false,\"can_filter\":false,\"field\":[]},{\"data_name\":\"PAYBACKAMT\",\"data_type\":\"numeric\",\"required\":\"false\",\"is_array\":false,\"is_businesskey\":false,\"description\":\"回款金额\",\"can_sort\":false,\"can_filter\":false,\"percent\":\"thousand\",\"decimal\":\"2\",\"field\":[]}]}},\"actionId\":\"DATA_PULLING_TW9W4n13\"},\"dataTag\":{\"name\":\"dataDisplay\",\"fields\":[{\"field\":\"CUSTOMERNAME\"},{\"field\":\"PAYBACKAMT\",\"businessType\":\"amount\",\"explanation\":\"PAYBACKAMT\"}],\"type\":\"show\"}}]}}";
        Gson gson = new Gson();
        return gson.fromJson(msg,snapShotDTO.getClass());
    }

    public SnapShotDTO questionS202405090032 (){
        SnapShotDTO snapShotDTO = new SnapShotDTO();
        String msg = "{\"snapshotId\":\"ADE_Snapshot--AthenaHZTest----20240815142340-56cb9ed9-a77d-4018-a14b-a9156209e222\",\"context\":{\"bizParams\":{\"eocMaps\":[{\"eocCompanyId\":\"zc001\",\"eocCompanyName\":\"zc001\"},{\"eocCompanyId\":\"Z03\",\"eocCompanyName\":\"Z03\"},{\"eocCompanyId\":\"Z02\",\"eocCompanyName\":\"Z02\"},{\"eocCompanyId\":\"Z01\",\"eocCompanyName\":\"Z01\"},{\"eocCompanyId\":\"J02\",\"eocCompanyName\":\"德华\"},{\"eocCompanyId\":\"J01\",\"eocCompanyName\":\"J01\"},{\"eocCompanyId\":\"gbq01\",\"eocCompanyName\":\"gbq01\"},{\"eocCompanyId\":\"default\",\"eocCompanyName\":\"预设公司别\"},{\"eocCompanyId\":\"B01\",\"eocCompanyName\":\"B01\"},{\"eocCompanyId\":\"987\",\"eocCompanyName\":\"987\"},{\"eocCompanyId\":\"2\",\"eocCompanyName\":\"郴州东佳电子\"},{\"eocCompanyId\":\"1229\",\"eocCompanyName\":\"1229\"},{\"eocCompanyId\":\"1\",\"eocCompanyName\":\"深圳东佳电子\"},{\"eocCompanyId\":\"00D01\",\"eocCompanyName\":\"00D01\"},{\"eocCompanyId\":\"zc03\",\"eocCompanyName\":\"zc03\"},{\"eocCompanyId\":\"007\",\"eocCompanyName\":\"007\"},{\"eocCompanyId\":\"ZC01\",\"eocCompanyName\":\"ZC01\"},{\"eocCompanyId\":\"Cm01\",\"eocCompanyName\":\"Cm01\"},{\"eocCompanyId\":\"5\",\"eocCompanyName\":\"深圳冠华电子\"},{\"eocCompanyId\":\"15\",\"eocCompanyName\":\"yrr周边有限公司\"},{\"eocCompanyId\":\"0324\",\"eocCompanyName\":\"陈扬公司\"},{\"eocCompanyId\":\"16\",\"eocCompanyName\":\"顶峰昆山公司19458\"},{\"eocCompanyId\":\"3\",\"eocCompanyName\":\"香港东佳电子\"}],\"requestPerson\":\"sunhonga@digiwin.com\",\"requestTime\":\"2024-08-1514:23:40\",\"tenantId\":\"AthenaHZTest\",\"requestType\":\"instant\",\"monitor\":{},\"querySchema\":{},\"sceneDefine\":{\"status\":\"1\"},\"recast\":{\"S202405090032\":[{\"condition\":{\"logitype\":\"and\",\"items\":[]},\"name\":\"filter\",\"technique\":\"filter\"},{\"condition\":{\"fields\":[],\"statistics\":[{\"mode\":\"normal\",\"statisticalMethod\":\"sort\",\"type\":\"desc\",\"statisticalFields\":[\"PAYBACKAMT\"]}]},\"name\":\"sort\",\"technique\":\"group\"},{\"name\":\"choose\",\"technique\":\"chooseColumn\",\"fields\":[\"EMPLOYEENAME\",\"PAYBACKAMT\"],\"type\":\"retain\"},{\"name\":\"dataDisplay\",\"fields\":[{\"field\":\"EMPLOYEENAME\"},{\"field\":\"PAYBACKAMT\"}],\"type\":\"show\"}]},\"backRecast\":{\"S202405090032\":[{\"condition\":{\"logitype\":\"and\",\"items\":[{\"op\":\"gte\",\"left\":\"BOOKKEEPINGDATE\",\"left_date_format\":\"yyyy-MM-dd\",\"right_value_type\":\"datetime\",\"right\":\"2024-01-01\",\"type\":\"constant\",\"logitype\":\"single\",\"right_date_format\":\"yyyy-MM-dd\",\"left_value_type\":\"string\"},{\"op\":\"lte\",\"left\":\"BOOKKEEPINGDATE\",\"left_date_format\":\"yyyy-MM-dd\",\"right_value_type\":\"datetime\",\"right\":\"2024-12-31\",\"type\":\"constant\",\"logitype\":\"single\",\"right_date_format\":\"yyyy-MM-dd\",\"left_value_type\":\"string\"}]},\"name\":\"filter\",\"technique\":\"filter\"}]},\"dimensionCnt\":1,\"param\":{\"BOOKKEEPINGDATE\":\"2024-01-01#2024-12-31\"},\"question\":\"今年各业务员的回款情况\"},\"scene\":{\"who\":[{\"type\":\"user\",\"value\":[{\"roles\":[],\"name\":\"孙宏\",\"id\":\"sunhonga@digiwin.com\",\"sid\":7.82266903382016E14}]}],\"when\":[{}],\"what\":[{\"type\":\"realTimeQuery\",\"value\":\"DATA_PULLING_9I9zs0OT\"}],\"where\":[],\"terminal\":[]},\"pullData\":[{\"actionId\":\"DATA_PULLING_9I9zs0OT\",\"sceneCode\":\"S202405090032\",\"startTime\":\"2024-08-1514:23:41\",\"endTime\":\"2024-08-1514:23:46\",\"data\":{\"data\":[{\"EMPLOYEENAME\":\"\",\"PAYBACKAMT\":189090773},{\"EMPLOYEENAME\":\"林文怡\",\"PAYBACKAMT\":-28000},{\"EMPLOYEENAME\":\"赖亿晋\",\"PAYBACKAMT\":-46827},{\"EMPLOYEENAME\":\"林垣沅\",\"PAYBACKAMT\":-75363}]},\"metadata\":{\"request\":{\"parameters\":[{\"data_name\":\"data\",\"is_array\":true,\"field\":[{\"data_name\":\"TA005\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"收款业务员\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"EMPLOYEENAME\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"业务员\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"RECEIVABLEDOCAMT\",\"is_array\":false,\"field\":[],\"data_type\":\"numeric\",\"description\":\"应收金额\",\"can_filter\":false,\"can_sort\":false,\"decimal\":2,\"is_businesskey\":false,\"percent\":\"thousand\",\"required\":\"false\"},{\"data_name\":\"TC015\",\"is_array\":false,\"field\":[],\"data_type\":\"string\",\"description\":\"收款业务员\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"},{\"data_name\":\"PAYBACKAMT\",\"is_array\":false,\"field\":[],\"data_type\":\"numeric\",\"description\":\"回款金额\",\"can_filter\":false,\"can_sort\":false,\"decimal\":2,\"is_businesskey\":false,\"percent\":\"thousand\",\"required\":\"false\"},{\"data_name\":\"REMAINRECDOCAMT\",\"is_array\":false,\"field\":[],\"data_type\":\"numeric\",\"description\":\"未收金额\",\"can_filter\":false,\"can_sort\":false,\"decimal\":2,\"is_businesskey\":false,\"percent\":\"thousand\",\"required\":\"false\"}],\"data_type\":\"object\",\"can_filter\":false,\"can_sort\":false,\"is_businesskey\":false,\"required\":\"false\"}]},\"response\":{\"data\":{\"data_name\":\"data\",\"data_type\":\"object\",\"required\":\"false\",\"is_array\":false,\"is_businesskey\":false,\"can_sort\":false,\"can_filter\":false,\"field\":[{\"data_name\":\"EMPLOYEENAME\",\"data_type\":\"string\",\"required\":\"false\",\"is_array\":false,\"is_businesskey\":false,\"description\":\"业务员\",\"can_sort\":false,\"can_filter\":false,\"field\":[]},{\"data_name\":\"PAYBACKAMT\",\"data_type\":\"numeric\",\"required\":\"false\",\"is_array\":false,\"is_businesskey\":false,\"description\":\"回款金额\",\"can_sort\":false,\"can_filter\":false,\"percent\":\"thousand\",\"decimal\":\"2\",\"field\":[]}]}},\"actionId\":\"DATA_PULLING_9I9zs0OT\"},\"dataTag\":{\"name\":\"dataDisplay\",\"fields\":[{\"field\":\"EMPLOYEENAME\"},{\"field\":\"PAYBACKAMT\"}],\"type\":\"show\"}}]}}";
        Gson gson = new Gson();
        return gson.fromJson(msg,snapShotDTO.getClass());
    }
}