package com.digiwin.athena.adt.agileReport.service.impl.process.agileData;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.AgileDataType;
import com.digiwin.athena.adt.agileReport.service.AgileDataProcessService;
import com.digiwin.athena.adt.agileReport.service.AgileReportService;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.dto.ade.AdeSpecialReqDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.adt.util.agileData.AgileDataAnalysisUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * @Author: SunHong
 * @Date: 2024/8/8 16:03
 * @Description:
 */
@Slf4j
@Service
@AgileDataType(value = AgileDataEnum.SPECIAL)
public class AgileDataProcessSpecialServiceImpl extends AbsAgileDataProcess implements AgileDataProcessService {

    @Autowired
    private SemcService semcService;
    @Resource
    private ADEService adeService;

    @Autowired
    private MessageUtil messageUtil;

    @Autowired
    private EchoService echoService;

    @Autowired
    private AgileReportService agileReportService;

    @Override
    public void process(AthenaMessageEvent event, QuerySchemaResDTO responseData) {
        //记录全链路日志
        long getQuerySchemaTook = System.currentTimeMillis();
        // 唯一序列顶替actionId
        Long generateSerialNo = event.getGenerateSerialNo();
        String question = MapUtils.getString(event.getMsgBody(), "text");
        try {
            //体验次数扣减
            Boolean chargingNum = echoService.echoChangeCharging(event.getUser().getToken(), event.getUser().getTenantId());
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "liteDeduction", LogUtils.SUCCESS,event.getUser().getUserId()
                    ,JsonUtils.objectToString(chargingNum), "");
            if (chargingNum != null && !chargingNum) {
                String chargingTitle1 = messageUtil.getMessageByLangName("message.echo.charging.fail1", event.getLang());
                String chargingTitle2;
                if("zh_CN".equals(event.getLang())){
                    chargingTitle2 = "体验机会已满，欢迎联系我们了解更多信息，鼎捷数智感谢您的关注和支持！」";
                }else{
                    chargingTitle2 = "體驗機會已滿，歡迎聯繫我們了解更多信息，鼎捷數智感謝您的關注與支持！」";
                }
                Object assistantName = event.getMsgExt().get("assistantName");
                String prompt;
                if(Objects.isNull(assistantName)){
                    prompt = chargingTitle1.concat(chargingTitle2);
                }else{
                    prompt = chargingTitle1.concat(String.valueOf(assistantName)).concat(chargingTitle2);
                }
                Map<String, Object> msgBody = new HashMap<>();
                msgBody.put("prompt", prompt);
                log.info("AgileDataProcessSpecialServiceImpl lang :{}," +
                        "chargingNum is chargingTitle1 :{},chargingTitle2:{}" ,event.getLang(),chargingTitle1,chargingTitle2);
                semcService.sendMessageToGpt(event,msgBody);
                return;
            }
            //模拟快照,压测用
            String snapId = MapUtils.getString(event.getMsgBody(), "snapshotId", null);
            if (!StringUtils.isEmpty(snapId)) {
                log.info("快照ID：{},处理开始时间：{}", snapId, TimeUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss:SSS"));
            }
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，问句入参：{}", event.getUser().getUserId(), event.getUser().getUserName()
                    , event.getUser().getTenantId(), event.getUser().getTenantName(), question, JsonUtils.objectToString(event.getMsgBody()));
            // ade request
            String combinationQuestion = StringUtils.EMPTY;
            for (Map<String, Object> data : responseData.getData().getDataflow()) {
                if (!Objects.isNull(data.get("data")) && "0".equals(String.valueOf(data.get("code")))) {
                    event.setCombinationQuestion(MapUtils.getString(data, "combinationQuestion"));
                    event.setAppCode(String.valueOf(data.get("applicationCode")));
                    event.setVersion(String.valueOf(data.get("version")));
                    AdeSpecialReqDTO adeSpecialReqDTO = AdeSpecialReqDTO.buildAdeReq(MapUtils.getMap(data,"data"), event);
                    this.sendMessageToAde(adeSpecialReqDTO, event, combinationQuestion, generateSerialNo);
                } else {
                    Map<String, Object> msgBody = new HashMap<>();
                    msgBody.put("prompt", MapUtils.getString(data, "data"));
                    Object obj = MapUtils.getObject(data,"sentences",null);
                    List<String> sentences = Lists.newArrayList();
                    if(obj instanceof Collection){
                        sentences = CommonUtil.objConvertListString(obj);
                    }
                    semcService.sendMessageToGpt(event,msgBody);
                    this.saveAbnormalLog(event,MapUtils.getString(data, "data"),1,0);
                }
            }
        } catch (Exception e) {
            log.error("AgileDataProcessSpecialServiceImpl Exception：{}",JsonUtils.objectToString(e));
            Map<String, Object> msgBody = new HashMap<>();
            String tipMessage = messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error",event.getLang());
            msgBody.put("prompt",tipMessage);
            this.saveAbnormal(event,tipMessage,0);
            semcService.sendMessageToGpt(event,msgBody);
        }
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，问句出参：{},耗时:{}s",
                event.getUser().getUserId(), event.getUser().getUserName(),
                event.getUser().getTenantId(), event.getUser().getTenantName(), question,
                JsonUtils.objectToString(event.getMsgBody()), System.currentTimeMillis() - getQuerySchemaTook);
    }

    public void sendMessageToAde(AdeSpecialReqDTO adeSpecialReqDTO, AthenaMessageEvent event, String combinationQuestion, Long generateSerialNo) {
        String question = MapUtils.getString(event.getMsgBody(),"text");
        try{
            Map<String,Object> sendMap = Maps.newHashMap();
            Map<String,Object> response = adeService.reqSpecialSnapShotData(adeSpecialReqDTO,event);
            if(response == null || MapUtils.getMap(response, "data") == null){
                String errorMsg = MapUtils.getString(response, "msg");

                sendMap.put("prompt",errorMsg);
                //记录异常日志
                String tipMessage = messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error",event.getLang());
                this.saveAbnormal(event,tipMessage,0);
            }else{
                //图表转换呈现信息
                AgileDataAnalysisUtils.getTransShowInfo(MapUtils.getMap(response, "data"),sendMap);
                String snapshotId = MapUtils.getString(MapUtils.getMap(response, "data"), "snapshotId");
                sendMap.put("snapshotId",snapshotId);
            }
            //转换业务数据
            agileReportService.executeAgileDataByTokenSize(event.getUser(),event, MapUtils.getMap(response, "data"));
            semcService.sendMessageToGpt(event,sendMap);

            this.saveQuestionData(MapUtils.getMap(response, "data"),event,question,combinationQuestion,generateSerialNo);
        }catch (Exception e){
            Map<String,Object> sendMap = Maps.newHashMap();
            sendMap.put("prompt",e.getMessage());
            //记录异常日志
            String tipMessage = messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error",event.getLang());
            this.saveAbnormal(event,tipMessage,0);

            semcService.sendMessageToGpt(event,sendMap);
        }
    }

}
