package com.digiwin.athena.adt.agileReport.service.impl.process.entrance;

import cn.hutool.json.JSONObject;
import com.digiwin.athena.adt.agileReport.config.AgileDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.config.SchemaDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.constant.SchemaConstants;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.event.domain.EventSubscribeDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.SnapShotDataService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.agileReport.service.impl.process.pannel.AgileDataDataFlowPanelServiceImpl;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateCostService;
import com.digiwin.athena.adt.agileReport.service.AgileDataMessageService;
import com.digiwin.athena.adt.agileReport.service.impl.process.pannel.AgileDataMetricPanelServiceImpl;
import com.digiwin.athena.adt.agileReport.service.impl.process.pannel.AgileDatasetPanelServiceImpl;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.ade.AdeDatasetReqDTO;
import com.digiwin.athena.adt.domain.dto.ade.AdeMetricReqDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.BizParamsDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.PullDataDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.km.KMCollectStepResDTO;
import com.digiwin.athena.adt.domain.dto.km.ThemeMapBoardDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.dto.agileDataProcess.AgileDataProcessResDTO;
import com.digiwin.athena.adt.domain.dto.schema.SchemaMetricShowDefine;
import com.digiwin.athena.adt.domain.knowledge.KmService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.sse.domain.EventStreamClient;
import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;
import com.digiwin.athena.adt.sse.listener.SSEScrumListener;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.util.TimeUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.*;

import static com.digiwin.athena.adt.agileReport.constant.SchemaConstants.METHOD_DATA_FLOW;

@Slf4j
@Service
public class AgileDataMessageServiceImpl extends AbsAgileDataProcess implements AgileDataMessageService {

    @Autowired
    private AgileDataHandlerProcessor agileDataHandlerProcessor;

    @Autowired
    private SchemaDataHandlerProcessor schemaDataHandlerProcessor;

    @Autowired
    private MessageUtil messageUtil;

    @Autowired
    private AgileDataDataFlowPanelServiceImpl agileDataDataFlowPanelService;

    @Autowired
    private AgileDataMetricPanelServiceImpl agileDataMetricPanelService;

    @Autowired
    private AgileDataCalculateCostService agileDataCalculateCostService;

    @Autowired
    private SemcService semcService;

    @Autowired
    private SnapShotDataService snapShotDataService;

    @Resource
    private ADEService adeService;

    @Autowired
    private AgileDatasetPanelServiceImpl agileDatasetPanelService;

    @Autowired
    private KmService kmService;

    /**
     * 正常问句
     * 调用语义策略分层
     * @param event event 事件入参
     */
//    @Async("asyncServiceExecutor")
    @Override
    public void process(AthenaMessageEvent event) {
        AppAuthContextHolder.clearContext();
        // 语义策略类型
        String schemaEnum = this.getServiceNameByMessageType(event);
        // 校验用户是否有敏数应用
        boolean isAppNull = this.checkUserAppPermission(event,schemaEnum);
        if(isAppNull){
            String errorMsg = messageUtil.getMessageByLangNameWithFormat("message.app.warn",
                    event.getLang());
            this.saveWarnQuestionData(event,errorMsg);
            Map<String, Object> msgBody = new HashMap<>();
            msgBody.put("prompt", errorMsg);
            semcService.sendMessageToGpt(event,msgBody);
            return;
        }
        // 数据订阅时校验是否存在对应指标或场景
        boolean isSceneEmpty = this.checkUserScene(event);
        if(event.isSubscribe() && !isSceneEmpty){
            log.info("processMessage receiveQuestion: 该指标或场景编码不存在当前租户");
            return;
        }
        String securityToken = Objects.isNull(AppAuthContextHolder.getContext()) ? null : AppAuthContextHolder.getContext().getSecurityToken();
        log.info("asyncServiceExecutor process messageId:{}, app core securityToken : {}",event.getGenerateSerialNo(),securityToken);
        // 语义分层
        Pair<Boolean, QuerySchemaResDTO> result = schemaDataHandlerProcessor.getEnumServiceByType(
                        SchemaDataEnum.queryTypeEnumByCode(schemaEnum))
                .process(event);
        if (result.getRight() == null || StringUtils.isEmpty(result.getRight().getData().getMethod())){
            this.saveQuerySchemaErrorByCode(event,null);
            return;
        }else if (!result.getLeft()){
            return;
        }
        QuerySchemaResDTO querySchemaResDTO = result.getRight();
        // 计算计费  true 正常取数 false 返回记录日志
        boolean isGo = agileDataCalculateCostService.calculateCostByCode(event, querySchemaResDTO);
        if(!isGo){
            return;
        }
        String router = String.valueOf(querySchemaResDTO.getRoute());
        // ADE策略类型
        String serviceName = this.getServiceNameByQuerySchema(router);
        agileDataHandlerProcessor.getEnumServiceByType(
                AgileDataEnum.queryTypeEnumByCode(serviceName))
                .process(event, querySchemaResDTO);

    }

    /**
     * 数据看板
     * 返回ade消息体方法
     * @param event 消息体
     * @return 返回实体
     */
    @Override
    public AgileDataProcessResDTO processRes(AthenaMessageEvent event) {
        String schemaEnum = this.getServiceNameByMessageType(event);
        AgileDataProcessResDTO agileDataProcessResDTO = AgileDataProcessResDTO.init();
        // 校验用户是否有敏数应用
        boolean isAppNull = this.checkUserAppPermission(event,schemaEnum);
        if(isAppNull){
            String errorMsg = messageUtil.getMessageByLangNameWithFormat("message.app.warn",
                    event.getLang());
            this.saveWarnQuestionData(event,errorMsg);
            agileDataProcessResDTO.setMsg(errorMsg);
            agileDataProcessResDTO.setAlarm(true);
            return agileDataProcessResDTO;
        }
        // 校验是否存在对应指标或场景
        boolean isSceneEmpty = this.checkUserScene(event);
        if(!isSceneEmpty){
            return agileDataProcessResDTO;
        }
        // 语义分层
        Pair<Boolean, QuerySchemaResDTO> result = schemaDataHandlerProcessor.getEnumServiceByType(
                        SchemaDataEnum.queryTypeEnumByCode(schemaEnum))
                .process(event);
        QuerySchemaResDTO schemaData = result.getRight();
        if (schemaData == null || StringUtils.isEmpty(schemaData.getData().getMethod())){
            String sysError = messageUtil.getMessageByLangNameWithFormat("message.system.schema.error",event.getLang());
            this.saveAbnormalLog(event, sysError,1,0);
            return agileDataProcessResDTO;
        }else if (!result.getLeft()){
            return agileDataProcessResDTO;
        }
        // 计算计费  true 正常取数 false 返回记录日志
        AgileDataProcessResDTO resDTO = agileDataCalculateCostService.calculateCostResult(event, schemaData,agileDataProcessResDTO);
        if(resDTO.isAlarm()){
            return resDTO;
        }
        // 暂指定实现 - 策略模式未改造
        String router = String.valueOf(schemaData.getRoute());
        if(SchemaConstants.METHOD_METRIC.equals(router)){
            return agileDataMetricPanelService.process(event,schemaData);
        }else if (SchemaConstants.DESIGNER.equals(router)){
            return agileDataDataFlowPanelService.process(event,schemaData);
        }else if (SchemaConstants.METHOD_DATASET.equals(router)){
            return agileDatasetPanelService.process(event,schemaData);
        }else{
            return agileDataProcessResDTO;
        }
    }

    /**
     * sse 问句
     * @param event 上下文
     */
    @Override
    public void sseProcess(AthenaMessageEvent event,SSEBaseEvent sseBaseEvent) {
        AppAuthContextHolder.clearContext();

        MDC.put("traceId", event.getPtxId());
        MDC.put("PtxId", event.getPtxId());
        // 2.1 语义策略类型
        String schemaEnum = this.getServiceNameByMessageType(event);
        // 校验用户是否有敏数应用
        boolean isAppNull = this.checkUserAppPermission(event,schemaEnum);
        if(isAppNull){
            String errorMsg = messageUtil.getMessageByLangNameWithFormat("message.app.warn",
                    event.getLang());
            this.saveWarnQuestionData(event,errorMsg);
            Map<String, Object> msgBody = new HashMap<>();
            msgBody.put("prompt", errorMsg);
            semcService.sendMessageToGpt(event,msgBody);
            return;
        }
        // 数据订阅时校验是否存在对应指标或场景
        boolean isSceneEmpty = this.checkUserScene(event);
        if(event.isSubscribe() && !isSceneEmpty){
            log.info("processMessage receiveQuestion: 该指标或场景编码不存在当前租户");
            sseBaseEvent.getAniaEmitter().complete();
            return;
        }
        // 2.2 获取调用url
        String url = this.getSseSchemaUrl(schemaEnum);
        // 2.3 根据策略类型获取各业务语义入参
        Map<String, Object> req = schemaDataHandlerProcessor.getEnumServiceByType(
                        SchemaDataEnum.queryTypeEnumByCode(schemaEnum))
                .getQuerySchemaReq(event);
        SSEBaseEvent.builderSchemaEvent(event, sseBaseEvent);
        sseBaseEvent.setSchemaEnum(schemaEnum);
        // 2.4 初始化sse , ania sse , 创建语义sse 连接
        SSEScrumListener sseListener = new SSEScrumListener(sseBaseEvent,schemaDataHandlerProcessor
                ,agileDataCalculateCostService,agileDataHandlerProcessor,this);
        EventStreamClient.executeSSE(event,url,sseListener,
                new com.alibaba.fastjson.JSONObject(req), sseBaseEvent);
    }

    /**
     * 2.0 数据看板
     * @param event 上下文
     * @param boardQuestion req
     * @return res
     */
    @Override
    public Map<String,Object> processResV2(AthenaMessageEvent event,
                                            ThemeMapBoardDTO boardQuestion) {
        AuthoredUser user = event.getUser();
        String snapshotId = boardQuestion.getSnapshotId();
        SnapShotDTO snapshotInfo = snapShotDataService
                .getSnapShotData(snapshotId,user.getTenantId(),user.getUserId());

        AdeDatasetReqDTO req = this.BuildDatasetAdeReq(event,snapshotInfo,boardQuestion);

        // 返回数据
        Map<String,Object> response = adeService.reqMetricSnapShotData(CommonUtil.convertObjectToMap(req),event);
        if(Objects.isNull(response) || "-1".equals(response.get("code"))) {
            return new HashMap<>();
        }
        return (Map<String, Object>) response.get("data");
    }

    @Override
    public SnapShotDTO processResV1(AthenaMessageEvent event, KMCollectStepResDTO stepResDTO) {
        AuthoredUser user = event.getUser();
        String snapshotId = stepResDTO.getSnapshotId();
        SnapShotDTO snapshotInfo = snapShotDataService
                .getSnapShotData(snapshotId,user.getTenantId(),user.getUserId());
        String method = snapshotInfo.getContext().getBizParams().getMethod();
        ThemeMapBoardDTO boardQuestion = new ThemeMapBoardDTO();
        boardQuestion.setShowType(stepResDTO.getShowType());
        boardQuestion.setSolutionStep(stepResDTO.getSolutionStep());
        boardQuestion.setAppCode(stepResDTO.getAppCode());
        Map<String,Object> req = new HashMap<>();
        if(AgileDataEnum.DATASET.getCode().equals(method)){
             req = CommonUtil.convertObjectToMap(this.BuildDatasetAdeReq(event,snapshotInfo,boardQuestion));
        }else if (AgileDataEnum.METRIC.getCode().equals(method)){
            req = CommonUtil.convertObjectToMap(this.BuildMetricAdeReq(event,snapshotInfo,stepResDTO));
        }
        // 返回数据
        Map<String,Object> response = adeService.reqMetricSnapShotData(req,event);
        if(Objects.isNull(response) || "-1".equals(response.get("code"))) {
            return new SnapShotDTO();
        }
        return JsonUtils.jsonToObject(JsonUtils.objectToString(response.get("data")),SnapShotDTO.class);
    }

    /**
     * 订阅直接取数
     * @param event e
     * @param subscribeDTO s
     */
    @Override
    public void processSubscribeV2(AthenaMessageEvent event, EventSubscribeDTO subscribeDTO) {
        AuthoredUser user = event.getUser();
        String snapshotId = String.valueOf(subscribeDTO.getMsgExt().get("snapshotId"));
        SnapShotDTO snapshotInfo = snapShotDataService
                .getSnapShotData(snapshotId,user.getTenantId(),user.getUserId());
        String method = snapshotInfo.getContext().getBizParams().getMethod();
        if(METHOD_DATA_FLOW.equals(method)){
            this.processRes(event);
            return;
        }
        String showType = String.valueOf(subscribeDTO.getMsgExt().get("showType"));
        Map<String,Object> solutionStep = (Map<String, Object>) subscribeDTO.getMsgExt().get("solutionStep");
        Map<String,Object> req;
        if(AgileDataEnum.DATASET.getCode().equals(method)){
            ThemeMapBoardDTO boardQuestion = new ThemeMapBoardDTO();
            boardQuestion.setShowType(Integer.parseInt(showType));
            boardQuestion.setSolutionStep(solutionStep);
            boardQuestion.setAppCode(event.getAppCode());
            req = CommonUtil.convertObjectToMap(this.BuildDatasetAdeReq(event,snapshotInfo,boardQuestion));
        }else if (AgileDataEnum.METRIC.getCode().equals(method)){
            KMCollectStepResDTO stepResDTO = new KMCollectStepResDTO();
            stepResDTO.setAppCode(event.getAppCode());
            stepResDTO.setShowType(Integer.parseInt(showType));
            stepResDTO.setSolutionStep(solutionStep);
            req = CommonUtil.convertObjectToMap(this.BuildMetricAdeReq(event,snapshotInfo,stepResDTO));
        }else {
            return;
        }
        adeService.reqMetricSnapShotData(req,event);
    }

    private Object BuildMetricAdeReq(AthenaMessageEvent event,
                                     SnapShotDTO snapshotInfo,
                                     KMCollectStepResDTO stepResDTO) {

        AdeMetricReqDTO adeMetricReqDTO = new AdeMetricReqDTO();
        BizParamsDTO bizParamsDTO = snapshotInfo.getContext().getBizParams();
        PullDataDTO pullDataDTO = snapshotInfo.getContext().getPullData().get(0);
        Integer showType = stepResDTO.getShowType();
        Map<String,Object> showDefineDTO = bizParamsDTO.getShowDefine();
        SchemaMetricShowDefine showDefine = new JSONObject(showDefineDTO).toBean(SchemaMetricShowDefine.class);
        if(Objects.nonNull(showType)){
            showDefine.getShowType().get(0).getType().get(0).setValue(String.valueOf(showType));
        }
        if(Objects.isNull(showDefineDTO) || CollectionUtils.isEmpty(showDefine.getShowType())){
            throw new IllegalArgumentException("语义呈现数据未返回,未找到对应actionId");
        }
        Map<String,Object> param = new HashMap<>();
        // 2.0 订阅消息 写入 特定的type
        if(event.isSubscribe()){
            param.put("type","2");
            param.put("undeletable",event.isUndeletable());
            param.put("asaCode",event.getAsaCode());
            param.put("ruleId",event.getMsgExt().get("ruleId"));
            adeMetricReqDTO.setParam(param);
        }
        adeMetricReqDTO.setEocMaps(bizParamsDTO.getEocMaps());
        adeMetricReqDTO.setMetricList(pullDataDTO.getMetricList());
        adeMetricReqDTO.setAppCode(stepResDTO.getAppCode());
        adeMetricReqDTO.setLocale(event.getLang());
        adeMetricReqDTO.setMessageId(String.valueOf(event.getGenerateSerialNo()));
        adeMetricReqDTO.setParam(param);
        adeMetricReqDTO.setMock(false);
        adeMetricReqDTO.setQuestion(event.getQuestion());
        adeMetricReqDTO.setMethod(SchemaDataEnum.METRIC.getCode());
        adeMetricReqDTO.setScene(event.getSceneDTO());
        adeMetricReqDTO.setMetric(stepResDTO.getSolutionStep());
        adeMetricReqDTO.setDataTag(bizParamsDTO.getDataTagParam());
        adeMetricReqDTO.setShowDefine(showDefine);
        adeMetricReqDTO.setRequestTime(TimeUtils.format(LocalDateTime.now(), "yyyy-MM-dd HH:mm:ss") );
        adeMetricReqDTO.setRequestor(event.getUser().getUserId());
        adeMetricReqDTO.setTenantId(event.getUser().getTenantId());
        adeMetricReqDTO.setProductLineInfo(event.getProductLineInfo());
        adeMetricReqDTO.setExplain4Gpt(bizParamsDTO.getExplain4Gpt());
        adeMetricReqDTO.setProductVersion(event.getProductVersion());

        return adeMetricReqDTO;
    }

    /**
     * 根据快照返回,保存的solutionStep 重新调用
     */
    private AdeDatasetReqDTO BuildDatasetAdeReq(AthenaMessageEvent event,
                                                SnapShotDTO snapShotDTO,
                                                ThemeMapBoardDTO boardQuestion) {


        AdeDatasetReqDTO adeDatasetReqDTO = new AdeDatasetReqDTO();
        BizParamsDTO bizParamsDTO = snapShotDTO.getContext().getBizParams();
        Integer showType = boardQuestion.getShowType();
        Map<String,Object> showDefineDTO = bizParamsDTO.getShowDefine();
        SchemaMetricShowDefine showDefine = new JSONObject(showDefineDTO).toBean(SchemaMetricShowDefine.class);
        if(Objects.nonNull(showType)){
            showDefine.getShowType().get(0).getType().get(0).setValue(String.valueOf(showType));
        }
        if(Objects.isNull(showDefine) || CollectionUtils.isEmpty(showDefine.getShowType())){
            throw new IllegalArgumentException("语义呈现数据未返回,未找到对应actionId");
        }
        Map<String,Object> param = new HashMap<>();
        // 2.0 订阅消息 写入 特定的type
        if(event.isSubscribe()){
            param.put("type","2");
            param.put("undeletable",event.isUndeletable());
            param.put("asaCode",event.getAsaCode());
            param.put("ruleId",event.getMsgExt().get("ruleId"));
            adeDatasetReqDTO.setParam(param);
        }
        adeDatasetReqDTO.setEocMaps(bizParamsDTO.getEocMaps());
        adeDatasetReqDTO.setDatasetList(bizParamsDTO.getDatasetList());
        adeDatasetReqDTO.setAppCode(boardQuestion.getAppCode());
        adeDatasetReqDTO.setLocale(event.getLang());
        adeDatasetReqDTO.setMessageId(String.valueOf(event.getGenerateSerialNo()));
        adeDatasetReqDTO.setParam(param);
        adeDatasetReqDTO.setMock(false);
        adeDatasetReqDTO.setQuestion(bizParamsDTO.getQuestion());
        adeDatasetReqDTO.setMethod(SchemaDataEnum.DATASET.getCode());
        adeDatasetReqDTO.setScene(event.getSceneDTO());
        adeDatasetReqDTO.setDataset(boardQuestion.getSolutionStep());
        adeDatasetReqDTO.setDataTag(bizParamsDTO.getDataTagParam());
        adeDatasetReqDTO.setShowDefine(showDefine);
        adeDatasetReqDTO.setRequestTime(TimeUtils.format(LocalDateTime.now(), "yyyy-MM-dd HH:mm:ss") );
        adeDatasetReqDTO.setRequestor(event.getUser().getUserId());
        adeDatasetReqDTO.setTenantId(event.getUser().getTenantId());
        adeDatasetReqDTO.setProductLineInfo(event.getProductLineInfo());
        adeDatasetReqDTO.setExplain4Gpt(bizParamsDTO.getExplain4Gpt());
        adeDatasetReqDTO.setProductVersion(event.getProductVersion());
        adeDatasetReqDTO.setTablePreviewIf(false);

        return adeDatasetReqDTO;
    }

}
