package com.digiwin.athena.adt.agileReport.service.impl.process.pannel;

import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateCostService;
import com.digiwin.athena.adt.agileReport.service.AgileDataCostDetailService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.ade.ADEScencDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.dto.agileDataProcess.AgileDataProcessResDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * @Author: SunHong
 * @Date: 2024/7/2 14:49
 * @Description:
 */
@Slf4j
@Service
public class AgileDataDataFlowPanelServiceImpl extends AbsAgileDataProcess {

    @Resource
    private ADEService adeService;

    @Autowired
    private MessageUtil messageUtil;

    @Autowired
    private AgileDataCalculateCostService agileDataCalculateCostService;

    @Autowired
    private AgileDataCostDetailService agileDataCostDetailService;

    public AgileDataProcessResDTO process(AthenaMessageEvent event, QuerySchemaResDTO responseData) {
        AgileDataProcessResDTO result = AgileDataProcessResDTO.init();
        String question = event.getQuestion();
        //记录全链路日志
        long getQuerySchemaTook = System.currentTimeMillis();
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，问句入参：{}",event.getUser().getUserId(),event.getUser().getUserName()
                ,event.getUser().getTenantId(),event.getUser().getTenantName(),question, JsonUtils.objectToString(event.getMsgBody()));
        LogDto logDto = new LogDto("获取意图识别数据：" + JsonUtils.objectToString(responseData));
        log.info(logDto.toString());
        //场景编码
        List<Map<String,Object>> scenes = Lists.newArrayList();
        try{
            for (Map<String, Object> data : responseData.getData().getDataflow()) {
                if (Objects.nonNull(data.get("code")) && (int) data.get("code") == 1) {
                    String kmCode = getKmCodeByEventOrSchemaData(event,data);
                    ADEScencDTO adeScencDTO = buildCommonAdeScene(event,data);
                    //从KM获取场景code
                    Map<String, Object> sceneMap = Maps.newHashMap();
                    sceneMap.put("templateCode", adeScencDTO.getTemplateCode());
                    sceneMap.put("targetId", adeScencDTO.getTarget());
                    sceneMap.put("dimension", adeScencDTO.getDimension());
                    //记录全链路日志
                    log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，获取KM场景，入参：{}", event.getUser().getUserId(), event.getUser().getUserName()
                            , event.getUser().getTenantId(), event.getUser().getTenantName(), question, JsonUtils.objectToString(sceneMap));
                    //记录全链路日志
                    log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，获取KM场景，出参：{}", event.getUser().getUserId(), event.getUser().getUserName()
                            , event.getUser().getTenantId(), event.getUser().getTenantName(), question, JsonUtils.objectToString(scenes));
                    //场景不存在，反馈异常信息
                    if (StringUtils.isEmpty(kmCode)) {
                        String sysError = messageUtil.getMessageByLangNameWithFormat("message.system.schema.error",event.getLang());
                        this.saveAbnormalLog(event, sysError,1,0);
                        continue;
                    }
                    adeScencDTO.setSceneCode(kmCode);
                    Map<String, Object> recastData = new HashMap<>();
                    recastData.put(kmCode, data.get("data"));
                    adeScencDTO.setRecast(recastData);
                    // 请求ade
                    Map<String,Object> map = sendMessageToAde(event.getUser(), adeScencDTO, event);
                    if(map == null){
                        return result;
                    }
                    SnapShotDTO snapShotDTO = JsonUtils.jsonToObject(JsonUtils.objectToString(map),SnapShotDTO.class);
                    // 计费数据看板第二次校验以及返回
                    if(snapShotDTO != null){
                        result = agileDataCalculateCostService.combinedBillingCalculationPanel(event,snapShotDTO);
                        // 保存计费平台数据
                        agileDataCostDetailService.saveAgileDataCostDetail(data,event.getUser(),event.getPtxId()
                                ,event.getAppCode(),event.getAppName(),event.getSourceName());
                    }
                } else {
                    String sysError = messageUtil.getMessageByLangNameWithFormat("message.system.schema.error",event.getLang());
                    this.saveAbnormalLog(event, sysError,1,0);
                }
            }
        }catch (Exception e){
            String sysError = messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error",event.getLang());
            this.saveAbnormalLog(event, sysError,1,0);
        }
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，问句出参：{},耗时:{}ms",event.getUser().getUserId(),event.getUser().getUserName()
                ,event.getUser().getTenantId(),event.getUser().getTenantName(),question,JsonUtils.objectToString(event.getMsgBody()),System.currentTimeMillis() - getQuerySchemaTook);
        return result;
    }

    /**
     * 调用ade 不发送b娜请求接口
     * @param user 用户信息
     * @param adeScencDTO ade入参
     * @param event 消息体
     * @return Map<String, Object>
     */
    public Map<String, Object> sendMessageToAde(AuthoredUser user, ADEScencDTO adeScencDTO,
                                             AthenaMessageEvent event) {
        String question = event.getQuestion();
        String combinationQuestion = event.getCombinationQuestion();
        Long generateSerialNo = event.getGenerateSerialNo();
        Map<String, Object> response = new HashMap<>();
        try {
            //模拟快照,压测用
            String snapId = MapUtils.getString(event.getMsgBody(),"snapshotId",null);
            if(StringUtils.isNotEmpty(snapId)){
                adeScencDTO.setSnapshotId(snapId);
            }
            // 存快照问句
            adeScencDTO.setQuestion(question);
            response = adeService.getRealtimeSnapShotData(user, adeScencDTO,event);
            Map<String, Object> data = MapUtils.getMap(response, "data");
            //模拟快照,压测用
            if(StringUtils.isNotEmpty(snapId)){
                log.info("快照ID：{},处理结束时间：{}",snapId, TimeUtils.format(new Date(),"yyyy-MM-dd HH:mm:ss:SSS"));
            }
            if (data != null || MapUtils.getMap(response, "data") == null) {
                event.setAdeScencDTO(adeScencDTO);
            }else{
                return null;
            }
            //记录问答数据
            this.saveQuestionData(data,event,question,combinationQuestion,generateSerialNo);
            // 分类关系
            this.saveBuiltClassifications(event,response);
        } catch (Exception e) {
            log.error("get getPanelByAde error:{}", e.getMessage());
            String tipMessage = messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error",event.getLang());
            this.saveAbnormal(event,tipMessage,0);
        }
        return MapUtils.getMap(response, "data");
    }
}
