package com.digiwin.athena.adt.agileReport.service.impl.process.pannel;

import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateCostService;
import com.digiwin.athena.adt.agileReport.service.AgileDataCostDetailService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.ade.AdeDatasetReqDTO;
import com.digiwin.athena.adt.domain.dto.agileDataProcess.AgileDataProcessResDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaDatasetDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.adt.util.agileData.AgileDataAnalysisUtils;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * @Author: SunHong
 * @Date: 2025/6/10 14:49
 * @Description:
 */
@Slf4j
@Service
public class AgileDatasetPanelServiceImpl extends AbsAgileDataProcess {

    @Resource
    private ADEService adeService;

    @Autowired
    private MessageUtil messageUtil;

    @Autowired
    private AgileDataCalculateCostService agileDataCalculateCostService;

    @Autowired
    private AgileDataCostDetailService agileDataCostDetailService;

    public AgileDataProcessResDTO process(AthenaMessageEvent event, QuerySchemaResDTO responseData) {

        AgileDataProcessResDTO result = AgileDataProcessResDTO.init();
        String question = event.getQuestion();
        Long generateSerialNo = event.getGenerateSerialNo();
        //记录全链路日志
        long getQuerySchemaTook = System.currentTimeMillis();
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，问句入参：{}",event.getUser().getUserId(),event.getUser().getUserName()
                ,event.getUser().getTenantId(),event.getUser().getTenantName(), question, JsonUtils.objectToString(event.getMsgBody()));
        LogDto logDto = new LogDto("获取意图识别数据：" + JsonUtils.objectToString(responseData));
        log.info(logDto.toString());
        QuerySchemaDatasetDTO metric = responseData.getData().getDataset();
        try {
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，问句入参：{}", event.getUser().getUserId(), event.getUser().getUserName()
                    , event.getUser().getTenantId(), event.getUser().getTenantName(), question, JsonUtils.objectToString(event.getMsgBody()));
            // 组装ade入参
            AdeDatasetReqDTO adeDatasetReqDTO = AdeDatasetReqDTO.BuildDatasetAdeReq(event,metric);
            // 请求ade
            Map<String,Object> map = sendMessageToAde(event,adeDatasetReqDTO,responseData);
            if(Objects.isNull(map)){
                return result;
            }
            SnapShotDTO snapShotDTO = JsonUtils.jsonToObject(JsonUtils.objectToString(map),SnapShotDTO.class);
            // 计费数据看板第二次校验以及返回
            if(snapShotDTO != null){
                result = agileDataCalculateCostService.combinedBillingCalculationPanel(event,snapShotDTO);
                if(StringUtils.isNotEmpty(snapShotDTO.getSnapshotId())){
                    // 保存计费平台数据
                    agileDataCostDetailService.saveAgileDataCostDetail(map,event.getUser(),event.getPtxId()
                            ,event.getAppCode(),event.getAppName(),event.getSourceName());
                }
            }
        } catch (Exception e) {
            String sysError = messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error",event.getLang());
            this.saveAbnormalLog(event, sysError,1,0);
        }
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，问句出参：{},耗时:{}ms",
                event.getUser().getUserId(), event.getUser().getUserName(),
                event.getUser().getTenantId(), event.getUser().getTenantName(), question,
                JsonUtils.objectToString(event.getMsgBody()), System.currentTimeMillis() - getQuerySchemaTook);

        return result;
    }

    /**
     * 调用ade 和发送b 娜消息
     * @param adeDatasetReqDTO ade req
     * @param event 问句 事件信息
     */
    public Map<String,Object> sendMessageToAde( AthenaMessageEvent event,
                                                AdeDatasetReqDTO adeDatasetReqDTO,
                                                QuerySchemaResDTO responseData) {

        String question = event.getQuestion();
        String combinationQuestion = event.getCombinationQuestion();
        Long generateSerialNo = event.getGenerateSerialNo();
        Map<String, Object> response = new HashMap<>();
        // 根据版本号V1 or V2 返回ADE请求入参
        Map<String,Object> req = this.parameterBasedOnVersion(responseData,event);
        try{
            response = adeService.reqMetricSnapShotData(req,event);
            //组装问题排查工具入参
            AgileDataAnalysisUtils.transAnalysisParams(responseData, adeDatasetReqDTO, event);
            if(response == null || MapUtils.getMap(response, "data") == null){
                //记录异常日志
                String tipMessage = messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error",event.getLang());
                this.saveAbnormal(event,tipMessage,0);
            }
            this.saveQuestionData(MapUtils.getMap(response, "data"),event,question,combinationQuestion,generateSerialNo);
            // 分类关系
            this.saveBuiltClassifications(event,response);
        }catch (Exception e){
            Map<String,Object> sendMap = Maps.newHashMap();
            sendMap.put("prompt",e.getMessage());
            //记录异常日志
            String tipMessage = messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error",event.getLang());
            this.saveAbnormal(event,tipMessage,0);

        }
        return MapUtils.getMap(response, "data");
    }
}
