package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaConstants;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.ParamBuildWebDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaDebugDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaReqDTO;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author: SunHong
 * @Date: 2024/7/1 13:58
 * @Description: param 模式
 */
@Service
@Slf4j
@SchemaDataType(value = SchemaDataEnum.PARAM)
public class SchemaDataProcessParamServiceImpl extends AbsSchemaDataProcess implements SchemaDataProcessService {

    @Autowired
    private ChatbiService chatbiService;

    @Autowired
    private SemcService semcService;

    @Autowired
    private MessageUtil messageUtil;

    @Override
    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {
        String question = event.getQuestion();
        QuerySchemaDebugDTO querySchemaParamDTO = paramQuestionByMsg(question.trim());
        QuerySchemaReqDTO req = QuerySchemaReqDTO.builderSchemaParamReq(event,querySchemaParamDTO);

        LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "param", LogUtils.SUCCESS,
                JsonUtils.objectToString(req), "", "");
        // 公共校验
        Pair<Boolean, QuerySchemaResDTO> result = absCheckSchemaResponseData(event,chatbiService.getQuerySchema(req, event));
        return this.schemaDataProcessParam(event,result);
    }

    /**
     * param 返回抽象方法
     * @param event 上下文
     * @param result 公共校验返回
     * @return 业务返回
     */
    public Pair<Boolean, QuerySchemaResDTO> schemaDataProcessParam(AthenaMessageEvent event,
                                                                   Pair<Boolean, QuerySchemaResDTO> result) {
        String question = event.getQuestion();
        boolean check = result.getLeft();
        if(!check){
            return Pair.of(false, result.getRight());
        }
        QuerySchemaResDTO querySchemaResDTO = result.getRight();
        Map<String, Object> messageBody = new HashMap<>();
        // param模式
        List<Map<String,Object>> paramDataList = getSchemaParamDataList(querySchemaResDTO.getData().getDataflow());
        if(CollectionUtils.isEmpty(paramDataList)){
            messageBody.put("prompt", messageUtil.getMessageByLangNameWithFormat("message.param.noData", event.getLang()));
            semcService.sendMessageToGpt(event,messageBody);
            return Pair.of(false, querySchemaResDTO);
        }
        // 组合问句
        String combinationQuestion = getStringBySchemaData(querySchemaResDTO, SchemaConstants.COMBINATION_QUESTION);
        // queryAnalysis语义分析结果
        String webData = ParamBuildWebDTO.buildParamModel(paramDataList, question);
        messageBody.put("prompt", StringUtils.isNotEmpty(webData) ? webData : "params解析失败，请联系管理员");
        if(MapUtils.isEmpty(event.getMsgExt())){
            event.setMsgExt(Maps.newHashMap());
        }
        semcService.sendMessageToGpt(event,messageBody);
        this.saveAbnormalLog(event, messageUtil.getMessageByLangNameWithFormat("message.param.error", event.getLang()),1,0);
        return Pair.of(false, querySchemaResDTO);
    }

    /**
     * sse 验证语义返回消息
     * @param event 上下文
     * @param jsonObject 语义返回消息实体
     * @return result
     */
    @Override
    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event,
                                                       JSONObject jsonObject) {
        QuerySchemaResDTO querySchemaResDTO = JSONObject.parseObject(jsonObject.get("message")
                .toString()).toJavaObject(QuerySchemaResDTO.class);
        return this.schemaDataProcessParam(event,absCheckSchemaResponseData(event,querySchemaResDTO));
    }

    /**
     * 业务数据入参组装
     * @param event 上下文
     * @return 请求语义入参
     */
    @Override
    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {
        String question = event.getQuestion();
        QuerySchemaDebugDTO querySchemaParamDTO = paramQuestionByMsg(question.trim());
        QuerySchemaReqDTO req = QuerySchemaReqDTO.builderSchemaParamReq(event,querySchemaParamDTO);
        LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "param", LogUtils.SUCCESS,
                JsonUtils.objectToString(req), "", "");
        return CommonUtil.convertObjectToMap(req);
    }

    /**
     * 语义返回参数解析
     * @param list 返回dataflow
     * @return dataflow
     */
    public List<Map<String, Object>> getSchemaParamDataList(List<Map<String, Object>> list) {
        if(list.stream().filter(data -> data.get("data") instanceof Collection).findFirst().isPresent()){
            return null;
        }
        return list.stream()
                .map(data -> (Map<String, Object>) data.get("data"))
                .collect(Collectors.toList());
    }
}
