package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSendNanaReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSpecialUploadReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSpecialUploadResDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.SchemaPushReportResDTO;
import com.digiwin.athena.adt.agileReport.event.domain.SendMessageDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaDataDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaLiteResDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @Author: SunHong
 * @Date: 2024/8/8 15:59
 * @Description: 专线
 */
@Service
@Slf4j
@SchemaDataType(value = SchemaDataEnum.SPECIAL_LITE)
public class SchemaDataProcessSpecialLiteServiceImpl extends AbsSchemaDataProcess implements SchemaDataProcessService {

    @Autowired
    private ChatbiService chatbiService;

    @Autowired
    private SemcService semcService;

    @Autowired
    private UserService userService;

    @Autowired
    private MessageUtil messageUtil;

    @Autowired
    private EchoService echoService;

    public static final String SPECIAL_CODE = "2";

    public static final String SPECIAL_FALSE_CODE = "1";

    public static final String SUCCESS_FALSE_CN = "解析失败";

    public static final String SUCCESS_FALSE_TW = "解析失敗";

    public static final String SUCCESS_OTHER_FALSE_CN = "部分sheet解析失败";

    public static final String SUCCESS_OTHER_FALSE_TW = "部分sheet解析失敗";

    @Override
    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {
        Map<String, Object> requestParam = this.builderSpecialLiteReq(event);
        QuerySchemaLiteResDTO querySchemaResDTO = chatbiService.getQuerySchemaSpecialLite(requestParam, event);
        return this.schemaDataProcessLite(event,querySchemaResDTO);
    }

    /**
     * lite 调用语义后校验和实现
     * @param event 上下文
     * @param querySchemaResDTO 语义返
     * @return res
     */
    public Pair<Boolean, QuerySchemaResDTO> schemaDataProcessLite(AthenaMessageEvent event,
                                                                  QuerySchemaLiteResDTO querySchemaResDTO){
        QuerySchemaResDTO result = new QuerySchemaResDTO();
        if (querySchemaResDTO == null || CollectionUtils.isEmpty(querySchemaResDTO.getData())) {
            return Pair.of(false, null);
        }
        List<Map<String, Object>> dataList = querySchemaResDTO.getData();
        Optional<Map<String, Object>> firstDataOptional = dataList.stream().findFirst();
        AgileDataSendNanaReqDTO reqDTO = new AgileDataSendNanaReqDTO();
        if (firstDataOptional.isPresent()) {
            Map<String, Object> firstData = firstDataOptional.get();
            String codeValue = Optional.ofNullable(String.valueOf(firstData.get("code"))).orElse("");
            if (SPECIAL_CODE.equals(codeValue)) {
                String reply = Optional.ofNullable(String.valueOf(firstData.get("data"))).orElse("");
                Map<String, Object> msgBody = new HashMap<>();
                msgBody.put("prompt", reply);
                msgBody.put("scrumbiQuestion", event.getQuestion());
                reqDTO.setMsgBody(msgBody);
                this.setAthenaEventMessageType(event,SchemaDataEnum.SPECIAL_LITE.getValue());
                // 导正echo
                echoService.echoMongodbSubmit(EchoSubmitReq.builderSchemaGuidance(event,(List<Map<String, Object>>) firstData.get("moreTables"))
                        ,event.getUser().getToken(),event.getUser().getTenantId());
                this.sendNanaMessageByGetMessage(event,msgBody);
                this.setupResultData(querySchemaResDTO, result);
                return Pair.of(false, result);
            } else if (SPECIAL_FALSE_CODE.equals(codeValue)){
                Map<String, Object> msgBody = new HashMap<>();
                msgBody.put("prompt", firstDataOptional.get().get("data"));
                msgBody.put("scrumbiQuestion", event.getQuestion());
                reqDTO.setMsgBody(msgBody);
                this.setAthenaEventMessageType(event,SchemaDataEnum.SPECIAL_LITE.getValue());
                this.sendNanaMessageByGetMessage(event,msgBody);
                this.setupResultData(querySchemaResDTO, result);
                return Pair.of(false, result);
            }else{
                this.setupResultData(querySchemaResDTO, result);
                return Pair.of(true, result);
            }
        } else {
            return Pair.of(false, null);
        }
    }

    public Map<String,Object> builderSpecialLiteReq(AthenaMessageEvent event){
        Map<String, Object> requestParam = new HashMap<>();
        if (Objects.nonNull(event.getMsgExt())) {
            requestParam.put("useDemo", event.getMsgExt().get("useDemo"));
            requestParam.put("fileUrl", event.getMsgExt().get("fileUrl"));
            requestParam.put("sessionId", event.getMsgExt().get("sessionId"));
            requestParam.put("tableId", event.getMsgExt().get("tableId"));
            requestParam.put("tableName", event.getMsgExt().get("tableName"));
            requestParam.put("asaCode", event.getMsgExt().get("asaCode"));
        }
        if(Objects.nonNull(event.getMsgExt())
                && Objects.nonNull(event.getMsgExt().get("tableId"))){
            requestParam.put("multiDialogue", false);
        }else{
            requestParam.put("multiDialogue", true);
        }
        requestParam.put("message", event.getQuestion());
        return requestParam;
    }
    @Override
    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {
        return this.builderSpecialLiteReq(event);
    }

    public void setupResultData(QuerySchemaLiteResDTO querySchemaResDTO, QuerySchemaResDTO result) {
        QuerySchemaDataDTO data = new QuerySchemaDataDTO();
        data.setDataflow(querySchemaResDTO.getData());
        data.setMethod(SchemaDataEnum.SPECIAL.getCode());
        result.setRoute(SchemaDataEnum.SPECIAL.getCode());
        result.setMsg(querySchemaResDTO.getMsg());
        result.setCode(querySchemaResDTO.getCode());
        result.setData(data);
    }


    /**
     * 语义上传附件校验
     *
     * @param req  请求入参
     * @param user 用户信息
     * @return 是否成功
     */
    public AgileDataSpecialUploadResDTO liteUploadProcessMessage(AgileDataSpecialUploadReqDTO req,
                                                                 AuthoredUser user) {
        AgileDataSpecialUploadResDTO resDTO = new AgileDataSpecialUploadResDTO();
        req.setUserId(user.getUserId());
        req.setTenantId(user.getTenantId());
        String userLangName = userService.getUserLangNameByUserId(
                user.getUserId(), user.getTenantId(), user.getToken());
        req.setLocale(StringUtils.isEmpty(userLangName) ? "zh_CN" : userLangName);
        SchemaPushReportResDTO result = chatbiService.schemaPushReport(user, req);
        if (result!= null && result.getData()!= null) {
            int code = result.getData().getCode();
            // 先根据常见情况设置 success 的默认值为 false
            this.setMsgByCode(resDTO,userLangName,code);
            BeanUtils.copyProperties(result.getData(), resDTO);
            String prompt = result.getData().getSentenceTitle();
            if (StringUtils.isEmpty(prompt)) {
                prompt = messageUtil.getMessageByLangName("message.adt.lite.message", req.getLocale());
            }
            resDTO.setPrompt(prompt);
            resDTO.setSendNana(true);
            resDTO.setMultiDialogue(false);
        } else {
            resDTO.setMsg(result !=null ? result.getMsg() : "");
            resDTO.setSuccess(false);
        }
        return resDTO;
    }

    /**
     * 根據code码判断返回提示信息
     * @param resDTO 实体
     * @param userLangName 语言别
     * @param code 状态码
     *
     */
    private void setMsgByCode(AgileDataSpecialUploadResDTO resDTO, String userLangName,int code) {
        if(code == 0){
            resDTO.setSuccess(true);
            resDTO.setMsg("");
        }else if (code == 1){
            resDTO.setSuccess(false);
            if("zh_CN".equals(userLangName)){
                resDTO.setMsg(SUCCESS_FALSE_CN);
            }else{
                resDTO.setMsg(SUCCESS_FALSE_TW);
            }
        }else if (code == 2) {
            resDTO.setSuccess(true);
            if("zh_CN".equals(userLangName)){
                resDTO.setMsg(SUCCESS_OTHER_FALSE_CN);
            }else{
                resDTO.setMsg(SUCCESS_OTHER_FALSE_TW);
            }
        }else{
            resDTO.setMsg("");
            resDTO.setSuccess(false);
        }
    }

    /**
     * 后置发送娜娜消息
     *
     * @param req  消息体
     * @param user 用户信息
     */
    public void sendNanaMessage(AgileDataSendNanaReqDTO req, AuthoredUser user) {
        Map<String, Object> msgBody = req.getMsgBody();
        SendMessageDTO sendMessageDTO = new SendMessageDTO();
        sendMessageDTO.setMsgBody(msgBody);
        sendMessageDTO.setUserId(user.getUserId());
        sendMessageDTO.setSkillType("1");
        sendMessageDTO.setMsgType("CUSTOM");
        log.info("Sending Message to  B娜 sendMessageDTO :{}", JsonUtils.objectToString(sendMessageDTO));
        semcService.sendMessage(sendMessageDTO, user.getToken(), user.getTenantId());
    }

    /**
     * metric
     * 语义非异常上报导正消息和记录日志
     * @param event 上下文
     */
    public void sendNanaMessageByGetMessage(AthenaMessageEvent event,
                                            Map<String, Object> msgBody) {
        semcService.sendMessageToGpt(event,msgBody);
        this.saveAbnormalLog(event, String.valueOf(msgBody.get("prompt")),1,0);
    }

    /**
     * sse lite 实现
     * @param event 上下文
     * @param jsonObject 语义返回对象
     * @return res
     */
    @Override
    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject) {
        QuerySchemaLiteResDTO querySchemaResDTO = JSONObject.parseObject(jsonObject.get("message")
                .toString()).toJavaObject(QuerySchemaLiteResDTO.class);
        return this.schemaDataProcessLite(event,querySchemaResDTO);
    }
}
