package com.digiwin.athena.adt.app.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;

@Configuration
public class MongoTemplateConfig {
    @Value("${spring.data.mongodb-api-log.uri}")
    private String uriLog;
    @Value("${spring.data.mongodb-api-log.database}")
    private String databaseLog;

    @Value("${spring.data.mongodb-agileData-log.uri}")
    private String uriAgileDataLog;
    @Value("${spring.data.mongodb-agileData-log.database}")
    private String databaseAgileDataLog;
    @Value("${spring.data.mongodb-agileData-log.agileDataPagebase}")
    private String databaseagileDataPage;

    @Bean("mongoTemplate")
    public MongoTemplate mongoTemplate() {
        MongoClient client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(uriLog)).build(), null);
        return new MongoTemplate(client, databaseLog);
    }

    @Bean("mongoAgileDataLogTemplate")
    public MongoTemplate mongoAgileDataTemplate() {
        MongoClient client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(uriAgileDataLog)).build(), null);
        MongoTemplate mongoTemplate = new MongoTemplate(client, databaseAgileDataLog);
        MongoConverter converter = mongoTemplate.getConverter();
        // 去掉_class属性
        if (converter.getTypeMapper().isTypeKey("_class")) {
            ((MappingMongoConverter) converter).setTypeMapper(new DefaultMongoTypeMapper(null));
        }

        return mongoTemplate;
    }

    @Bean("mongoAgileDataPageViewTemplate")
    public MongoTemplate mongoAgileDataPageViewTemplate() {
        MongoClient client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(uriAgileDataLog)).build(), null);
        MongoTemplate mongoTemplate = new MongoTemplate(client, databaseagileDataPage);
        MongoConverter converter = mongoTemplate.getConverter();
        // 去掉_class属性
        if (converter.getTypeMapper().isTypeKey("_class")) {
            ((MappingMongoConverter) converter).setTypeMapper(new DefaultMongoTypeMapper(null));
        }

        return mongoTemplate;
    }
}
