package com.digiwin.athena.adt.domain.ade;

import com.digiwin.athena.adt.agileReport.eventbus.AgileDataLogEvent;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.*;
import com.digiwin.athena.adt.domain.dto.ade.*;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.apc.AgileAdeApcReqDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import java.util.List;
import java.util.Map;

/**
 * 敏捷引擎
 */
public interface ADEService {

    /**
     * 获取敏捷实时数据
     * @param sdScencDTO
     * @return
     */
    SnapShotDTO getSnapShotData(SDScencDTO sdScencDTO);

    Map<String,Object> getRealtimeSnapShotData(AuthoredUser user, ADEScencDTO adeScencDTO, AthenaMessageEvent event);

    /**
     * 获取查询SQL
     * @param user
     * @param question
     * @param local
     * @return
     */
    Map<String,Object> getSchemaSQL(AuthoredUser user,String question,String local);

    Map<String,Object> getSchemaSQLNoGPT(AgileDataLogEvent event);

    Map<String,Object> reqTargetSnapShotData(AdeTargetReqDTO newAdeSceneReqDTO, AthenaMessageEvent event);

    Map<String,Object> reqMetricSnapShotData(Map<String, Object> param, AthenaMessageEvent event);

    Map<String,Object> reqSpecialSnapShotData(AdeSpecialReqDTO adeSpecialReqDTO, AthenaMessageEvent event);

    SnapShotDTO reqApcSnapShotDataBySync(AgileAdeApcReqDTO req, AuthoredUser user,String local);

    Map<String, Object> getEssentialFactor(AthenaMessageEvent event, Map<String, Object> param);

    Map<String, Object> getDataSetFieldList(AuthoredUser user, AdeDataSetFieldReqDTO req,String lang);

    Map<String, Object> transPresentAgileData(AuthoredUser user, String transId,String originalId,SnapShotDTO snapShotDTO,String lang);

    /**
     * 根据快照获取可转换列表
     * @param snapShotDTO
     * @param lang
     * @return
     */
    List<String> getTransList(SnapShotDTO snapShotDTO, AuthoredUser authoredUser,String lang);
}
