package com.digiwin.athena.adt.domain.ade.impl;

import com.digiwin.athena.adt.agileReport.constant.BusinessConstants;
import com.digiwin.athena.adt.agileReport.constant.ErrorCodeEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AgileDataLogEvent;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.app.env.AdtEnvProperties;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.*;
import com.digiwin.athena.adt.domain.dto.ade.*;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.apc.AgileAdeApcReqDTO;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Maps;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import java.util.*;


/**
 * 敏捷数据
 */
@Slf4j
@Service
public class ADEServiceImpl implements ADEService {

    @Autowired
    private AdtEnvProperties adtEnvProperties;

    @Autowired(required = false)
    private RestTemplate restTemplate;

    @Autowired
    private EchoService echoService;

    /**
     * 获取敏捷实时数据
     * @param sdScencDTO
     * @return
     */
    @Override
    public SnapShotDTO getSnapShotData(SDScencDTO sdScencDTO) {
        String url= adtEnvProperties.getAdeUri()+"/api/test/nacos/info";
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity(sdScencDTO,headers);
        try {
            ResponseEntity<SnapShotDTO> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,SnapShotDTO.class);
            return respEntity.getBody();
        } catch (Exception e){
            log.error("{}, 请求body：{}, 报错信息：{} "
                    , ErrorCodeEnum.ADE_GET_SNAPDATA_FAIL.getErrCode()
                    , JsonUtils.objectToString(sdScencDTO)
                    , e.getMessage());
            throw ExceptionUtil.wrap(ErrorCodeEnum.ADE_GET_SNAPDATA_FAIL.getErrCode(),e);
        }
    }

    @Override
    public Map<String,Object> getRealtimeSnapShotData(AuthoredUser user, ADEScencDTO adeScencDTO, AthenaMessageEvent event) {
        long getQuerySchemaTook = System.currentTimeMillis();
        LogDto logDto = new LogDto("获取ade入参：" + JsonUtils.objectToString(adeScencDTO));
        log.info(logDto.toString());
        String url= adtEnvProperties.getAdeUri()+"/restful/standard/AgileDataEngine/instant/agileData";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token",user.getToken());
        headers.set("locale",event.getLang());
        headers.set("Routerkey",user.getTenantId());
        headers.set("messageId",event.getPtxId());
        headers.set("ptxId",String.valueOf(event.getPtxId()));
        HttpEntity httpEntity = new HttpEntity(adeScencDTO,headers);
        try {
            ResponseEntity<BaseResultDTO<Map<String, Object>>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>() {
                    });
            LogDto logReturnDto = new LogDto("获取ade返参：" + response.getBody().getResponse());
            log.info(logReturnDto.toString());
            if("-1".equals(response.getBody().getResponse().get("code"))){
                echoService.echoSubmit(EchoSubmitReq.init(event,BusinessConstants.ERROR_ADE,
                                JsonUtils.objectToString(adeScencDTO),
                                JsonUtils.objectToString(response),
                                "1"),
                        event.getUser().getToken(), event.getUser().getTenantId());
            }
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getData", LogUtils.SUCCESS,
                    JsonUtils.objectToString(adeScencDTO), JsonUtils.objectToString(response), "");
            return response.getBody().getResponse();
        } catch (ResourceAccessException e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getData", TroubleToolCodeEnum.ADT_901_0122.getErrCode(),
                    JsonUtils.objectToString(adeScencDTO), TroubleToolCodeEnum.ADT_901_0122.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0122.getSuggestion());
            log.error("agiledata_ADT_ :耗时:{},问题位置:{},问题描述:{},错误内容:{},可能原因及排错指引导:{}",
                    System.currentTimeMillis() - getQuerySchemaTook,
                    BusinessConstants.ERROR_SEND_ADE,
                    BusinessConstants.ERROR_ADE_TIME_OUT,
                    JsonUtils.objectToString(adeScencDTO),
                    BusinessConstants.ERROR_SEND_MESSAGE);
            echoService.echoSubmit(EchoSubmitReq.init(event,BusinessConstants.ERROR_ADE_TIME_OUT,
                            JsonUtils.objectToString(adeScencDTO),BusinessConstants.ERROR_SEND_MESSAGE,"1"),
                    event.getUser().getToken(), event.getUser().getTenantId());
            throw ErrorCodeEnum.ADE_REALTIME_TIME_OUT_FAIL.getBusinessException();
        } catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getData",TroubleToolCodeEnum.ADT_901_0121.getErrCode(),
                    JsonUtils.objectToString(adeScencDTO), TroubleToolCodeEnum.ADT_901_0121.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0121.getSuggestion());
            log.error("{}, 请求body：{}, 报错信息：{}"
                    , ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getErrCode()
                    , JsonUtils.objectToString(adeScencDTO)
                    , e.getMessage());
            echoService.echoSubmit(EchoSubmitReq.init(event,BusinessConstants.ERROR_ADE,
                            JsonUtils.objectToString(adeScencDTO),
                            String.valueOf(e),
                            "1"),
                    event.getUser().getToken(), event.getUser().getTenantId());
            throw ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getBusinessException();
        }
    }

    /**
     * 获取查询SQL
     * @param user
     * @param question
     * @param local
     * @return
     */

    @Override
    public Map<String, Object> getSchemaSQL(AuthoredUser user, String question, String local) {
        LogDto logDto = new LogDto("获取查询sql入参：" + JsonUtils.objectToString(question));
        log.info(logDto.toString());
        String url= adtEnvProperties.getAdeUri()+"/restful/standard/AgileDataEngine/get/querySchema";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token",user.getToken());
        headers.set("locale",local);
        Map<String,Object> params = Maps.newHashMap();
        params.put("tenantId",user.getTenantId());
        params.put("locale",local);
        params.put("question",question);
        params.put("userToken",user.getToken());
        params.put("useDcp",false);
        params.put("useSQL",true);
        HttpEntity httpEntity = new HttpEntity(params,headers);
        try {
            ResponseEntity<BaseResultDTO<Map<String, Object>>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>() {
                    });
            LogDto logReturnDto = new LogDto("获取查询sql返参：" + response.getBody().getResponse());
            log.info(logReturnDto.toString());
            return response.getBody().getResponse();
        } catch (Exception e){
            log.error("{}, 请求body：{}, 报错信息：{} "
                    , ErrorCodeEnum.ADE_REALTIME_SQL_FAIL.getErrCode()
                    , JsonUtils.objectToString(params)
                    , e.getMessage());
        }
        return null;
    }

    @Override
    public Map<String, Object> getSchemaSQLNoGPT(AgileDataLogEvent event) {
        LogDto logDto = new LogDto("获取查询sql入参：" + JsonUtils.objectToString(event.getQuestion()));
        log.info(logDto.toString());
        String url= adtEnvProperties.getAdeUri()+"/restful/standard/AgileDataEngine/get/querySchemaNoGPT";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token",event.getAuthoredUser().getToken());
        headers.set("locale",event.getLocal());
        headers.set("Routerkey",event.getAuthoredUser().getUserId());
        headers.set("messageId",String.valueOf(event.getGenerateSerialNo()));
        headers.set("ptxId",String.valueOf(event.getPtxId()));
        HttpEntity httpEntity = new HttpEntity(event.getAdeScencDTO(),headers);
        log.info("adt getSchemaSQLNoGPT 入参 :{}",JsonUtils.objectToString(httpEntity));
        try {
            ResponseEntity<BaseResultDTO<Map<String, Object>>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>() {
                    });
            LogDto logReturnDto = new LogDto("获取查询sql返参：" + response.getBody().getResponse());
            log.info(logReturnDto.toString());
            return response.getBody().getResponse();
        } catch (Exception e){
            log.error("{}, 请求body：{}, 报错信息：{} "
                    , ErrorCodeEnum.ADE_REALTIME_SQL_FAIL.getErrCode()
                    , JsonUtils.objectToString(event.getAdeScencDTO())
                    , e.getMessage());
        }
        return null;
    }

    @Override
    public Map<String,Object> reqTargetSnapShotData(AdeTargetReqDTO newAdeSceneReqDTO, AthenaMessageEvent event) {
        LogDto logDto = new LogDto("获取ade入参：" + JsonUtils.objectToString(newAdeSceneReqDTO));
        log.info(logDto.toString());
        String url= adtEnvProperties.getAdeUri()+"/restful/standard/AgileDataEngine/new/instant/agileData";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token",event.getUser().getToken());
        headers.set("locale",event.getLang());
        headers.set("Routerkey",event.getUser().getTenantId());
        headers.set("messageId",String.valueOf(event.getGenerateSerialNo()));
        headers.set("ptxId",String.valueOf(event.getPtxId()));
        HttpEntity httpEntity = new HttpEntity(newAdeSceneReqDTO,headers);
        try {
            ResponseEntity<BaseResultDTO<Map<String, Object>>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>() {
                    });
            LogDto logReturnDto = new LogDto("获取ade返参：" + response.getBody().getResponse());
            log.info(logReturnDto.toString());
            return response.getBody().getResponse();
        } catch (Exception e){
            log.error("{}: , 请求body：{}, 报错信息：{} "
                    , ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getErrCode()
                    , JsonUtils.objectToString(httpEntity)
                    , e.getMessage());
            throw ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getBusinessException();
        }
    }

    /**
     * 新架构 指标方案 ade接口
     * String url= adtEnvProperties.getAdeUri()+"/restful/standard/AgileDataEngine/integration/instant/agileData";
     * @param param 入参
     * @param event 上下文
     * @return 返回
     */
    @Override
    public Map<String,Object> reqMetricSnapShotData(Map<String, Object> param, AthenaMessageEvent event) {
        LogDto logDto = new LogDto("获取ade入参：" + JsonUtils.objectToString(param));
        long getQuerySchemaTook = System.currentTimeMillis();
        log.info(logDto.toString());
        String url= adtEnvProperties.getAdeUri()+"/restful/standard/AgileDataEngine/instant/agileData";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token",event.getUser().getToken());
        headers.set("locale",event.getLang());
        headers.set("Routerkey",event.getUser().getTenantId());
        headers.set("messageId",event.getPtxId());
        headers.set("ptxId",String.valueOf(event.getPtxId()));
        HttpEntity httpEntity = new HttpEntity(param,headers);
        try {
            ResponseEntity<BaseResultDTO<Map<String, Object>>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>() {
                    });
            LogDto logReturnDto = new LogDto("获取ade返参：" + JsonUtils.objectToString(response.getBody().getResponse()));
            log.info(logReturnDto.toString());
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getData", LogUtils.SUCCESS,
                    JsonUtils.objectToString(param), JsonUtils.objectToString(response), "");
            return response.getBody().getResponse();
        } catch (ResourceAccessException e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getData", TroubleToolCodeEnum.ADT_901_0122.getErrCode(),
                    JsonUtils.objectToString(param), TroubleToolCodeEnum.ADT_901_0122.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0122.getSuggestion());
            log.error("agiledata_ADT_ :耗时:{},问题位置:{},问题描述:{},错误内容:{},可能原因及排错指引导:{}",
                    System.currentTimeMillis() - getQuerySchemaTook,
                    BusinessConstants.ERROR_SEND_ADE,
                    BusinessConstants.ERROR_ADE_TIME_OUT,
                    JsonUtils.objectToString(param),
                    BusinessConstants.ERROR_SEND_MESSAGE);
            echoService.echoSubmit(EchoSubmitReq.init(event,BusinessConstants.ERROR_ADE_TIME_OUT,
                            JsonUtils.objectToString(param),BusinessConstants.ERROR_SEND_MESSAGE,"1"),
                    event.getUser().getToken(), event.getUser().getTenantId());
            throw ErrorCodeEnum.ADE_REALTIME_TIME_OUT_FAIL.getBusinessException();
        } catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getData",TroubleToolCodeEnum.ADT_901_0121.getErrCode(),
                    JsonUtils.objectToString(param), TroubleToolCodeEnum.ADT_901_0121.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0121.getSuggestion());
            log.error("{}, 请求body：{}, 报错信息：{}"
                    , ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getErrCode()
                    , JsonUtils.objectToString(param)
                    , e.getMessage());
            echoService.echoSubmit(EchoSubmitReq.init(event,BusinessConstants.ERROR_ADE,
                            JsonUtils.objectToString(param),
                             String.valueOf(e),
                            "1"),
                    event.getUser().getToken(), event.getUser().getTenantId());
            throw ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getBusinessException();
        }
    }

    @Override
    public Map<String,Object> reqSpecialSnapShotData(AdeSpecialReqDTO adeSpecialReqDTO, AthenaMessageEvent event) {
        LogDto logDto = new LogDto("获取ade入参：" + JsonUtils.objectToString(adeSpecialReqDTO));
        long getQuerySchemaTook = System.currentTimeMillis();
        log.info(logDto.toString());
        String url= adtEnvProperties.getAdeUri()+"/restful/standard/AgileDataEngine/instant/hasAnswer/agileData";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token",event.getUser().getToken());
        headers.set("locale",event.getLang());
        headers.set("Routerkey",event.getUser().getTenantId());
        HttpEntity httpEntity = new HttpEntity(adeSpecialReqDTO,headers);
        try {
            ResponseEntity<BaseResultDTO<Map<String, Object>>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>() {
                    });
            LogDto logReturnDto = new LogDto("获取ade返参：" + response.getBody().getResponse());
            log.info(logReturnDto.toString());
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getData", LogUtils.SUCCESS,
                    JsonUtils.objectToString(adeSpecialReqDTO), JsonUtils.objectToString(response), "");
            return response.getBody().getResponse();
        } catch (ResourceAccessException e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getData", TroubleToolCodeEnum.ADT_901_0122.getErrCode(),
                    JsonUtils.objectToString(adeSpecialReqDTO), TroubleToolCodeEnum.ADT_901_0122.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0122.getSuggestion());
            log.error("agiledata_ADT_ :耗时:{},问题位置:{},问题描述:{},错误内容:{},可能原因及排错指引导:{}",
                    System.currentTimeMillis() - getQuerySchemaTook,
                    "敏捷数据助理入口(ADT)->ADE (reqMetricSnapShotData)",
                    "调用ADE接口超时 ResourceAccessException",
                    event.getQuestion(),
                    "网络异常或者大语言模型服务异常，请访问http://xxxx.com查看当前网络监控状况");
            throw ErrorCodeEnum.ADE_REALTIME_TIME_OUT_FAIL.getBusinessException();
        } catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getData",TroubleToolCodeEnum.ADT_901_0121.getErrCode(),
                    JsonUtils.objectToString(adeSpecialReqDTO), TroubleToolCodeEnum.ADT_901_0121.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0121.getSuggestion());
            log.error("请求body：{}, 报错信息：{} ", ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getErrCode(),JsonUtils.objectToString(httpEntity), e);
            throw ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getBusinessException();
        }
    }

    /**
     * adt 请求 ade apc 大屏数据接口
     * @param req
     * @param user
     * @return
     */
    @Override
    public SnapShotDTO reqApcSnapShotDataBySync(AgileAdeApcReqDTO req, AuthoredUser user,String local) {

        LogDto logDto = new LogDto("获取ade apc 入参：" + JsonUtils.objectToString(req));
        long getQuerySchemaTook = System.currentTimeMillis();
        String ptxId = JaMDC.getNotNullTraceId();
        MDC.put("traceId", ptxId);
        MDC.put("PtxId", ptxId);
        log.info(logDto.toString());
        String url= adtEnvProperties.getAdeUri()+"/restful/standard/AgileDataEngine/screen/instant/agileData";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token",user.getToken());
        headers.set("Routerkey",user.getTenantId());
        headers.set("locale",local);
        headers.set("messageId", ptxId);

        HttpEntity httpEntity = new HttpEntity(req,headers);
        try {
            ResponseEntity<BaseResultDTO<Map<String,Object>>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map<String,Object>>>() {
                    });
            LogDto logReturnDto = new LogDto("获取ade返参：" + response.getBody().getResponse());
            log.info(logReturnDto.toString());
            Map<String,Object> resultMap = response.getBody().getResponse();
            Map<String,Object> dataMap = MapUtils.getMap(resultMap,"data");
            return JsonUtils.jsonToObject(JsonUtils.objectToString(dataMap),SnapShotDTO.class);
        } catch (ResourceAccessException e){
            log.error("agiledata_ADT_ :耗时:{},问题位置:{},问题描述:{},错误内容:{},可能原因及排错指引导:{}",
                    System.currentTimeMillis() - getQuerySchemaTook,
                    "敏捷数据助理入口(ADT)->ADE (reqMetricSnapShotData)",
                    "调用ADE接口超时 ResourceAccessException",
                    JsonUtils.objectToString(req),
                    "网络异常或者大语言模型服务异常，请访问http://xxxx.com查看当前网络监控状况");
            throw ErrorCodeEnum.ADE_REALTIME_TIME_OUT_FAIL.getBusinessException();
        } catch (Exception e){
            log.error("请求body：{}, 报错信息：{} ", ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getErrCode(),JsonUtils.objectToString(httpEntity), e);
            throw ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getBusinessException();
        }
    }

    /**
     * 获取ade sse 解题要素识别
     * @param event 上下文
     * @param param ade 入参
     * @return 返回要素识别信息
     */
    @Override
    public Map<String, Object> getEssentialFactor(AthenaMessageEvent event, Map<String, Object> param) {
        LogDto logDto = new LogDto("获取ade入参：" + JsonUtils.objectToString(param));
        long getQuerySchemaTook = System.currentTimeMillis();
        log.info(logDto.toString());
        String url= adtEnvProperties.getAdeUri()+"/restful/standard/AgileDataEngine/instant/getEssentialFactor";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token",event.getUser().getToken());
        headers.set("locale",event.getLang());
        headers.set("Routerkey",event.getUser().getTenantId());
        headers.set("messageId",event.getPtxId());
        headers.set("ptxId",String.valueOf(event.getPtxId()));
        HttpEntity httpEntity = new HttpEntity(param,headers);
        try {
            ResponseEntity<BaseResultDTO<Map<String, Object>>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>() {
                    });
            LogDto logReturnDto = new LogDto("获取ade返参：" + JsonUtils.objectToString(response.getBody().getResponse()));
            log.info(logReturnDto.toString());
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getEssentialFactor", LogUtils.SUCCESS,
                    JsonUtils.objectToString(param), JsonUtils.objectToString(response), "");
            return response.getBody().getResponse();
        } catch (ResourceAccessException e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getEssentialFactor", TroubleToolCodeEnum.ADT_901_0122.getErrCode(),
                    JsonUtils.objectToString(param), TroubleToolCodeEnum.ADT_901_0122.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0122.getSuggestion());
            log.error("agiledata_ADT_ :耗时:{},问题位置:{},问题描述:{},错误内容:{},可能原因及排错指引导:{}",
                    System.currentTimeMillis() - getQuerySchemaTook,
                    BusinessConstants.ERROR_SEND_ADE,
                    BusinessConstants.ERROR_ADE_TIME_OUT,
                    JsonUtils.objectToString(param),
                    BusinessConstants.ERROR_SEND_MESSAGE);
            echoService.echoSubmit(EchoSubmitReq.init(event,BusinessConstants.ERROR_ADE_TIME_OUT,
                            JsonUtils.objectToString(param),BusinessConstants.ERROR_SEND_MESSAGE,"1"),
                    event.getUser().getToken(), event.getUser().getTenantId());
            throw ErrorCodeEnum.ADE_REALTIME_TIME_OUT_FAIL.getBusinessException();
        } catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getEssentialFactor",TroubleToolCodeEnum.ADT_901_0121.getErrCode(),
                    JsonUtils.objectToString(param), TroubleToolCodeEnum.ADT_901_0121.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0121.getSuggestion());
            log.error("{}, 请求body：{}, 报错信息：{}"
                    , ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getErrCode()
                    , JsonUtils.objectToString(param)
                    , e.getMessage());
            echoService.echoSubmit(EchoSubmitReq.init(event,BusinessConstants.ERROR_ADE,
                            JsonUtils.objectToString(param),
                            String.valueOf(e),
                            "1"),
                    event.getUser().getToken(), event.getUser().getTenantId());
            throw ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getBusinessException();
        }
    }

    @Override
    public Map<String, Object> getDataSetFieldList(AuthoredUser user, AdeDataSetFieldReqDTO req,String userLang) {

        String ptxId = JaMDC.getNotNullTraceId();
        MDC.put("traceId", ptxId);
        MDC.put("PtxId", ptxId);
        String url = adtEnvProperties.getAdeUri() + "/restful/standard/AgileDataEngine/get/dataSetFieldList";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token",user.getToken());
        headers.set("userId",user.getUserId());
        headers.set("Routerkey",user.getTenantId());
        headers.set("locale", userLang);
        headers.set("messageId",ptxId);
        HttpEntity httpEntity = new HttpEntity(req,headers);
        try {
            log.info("获取解析结果入参：{}", JsonUtils.objectToString(req));
            ResponseEntity<BaseResultDTO<Map<String, Object>>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>() {
                    });
            log.info("获取解析结果集：{}", JsonUtils.objectToString(response.getBody().getResponse()));
            return response.getBody().getResponse();
        } catch (Exception e) {
            log.error("{}\n,请求url:{}\n, 请求token:{}\n,请求tenantId:{}\n,报错信息：{} "
                    , ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getErrCode(),
                    url, user.getToken(), user.getTenantId(), e.getMessage());
        }
        return null;
    }

    /**
     * 按指定图表转换数据结构
     * @param user
     * @param transId
     * @param originalId
     * @param lang
     * @return
     */
    @Override
    public Map<String, Object> transPresentAgileData(AuthoredUser user, String transId, String originalId, SnapShotDTO snapShotDTO,String lang) {
        String url = adtEnvProperties.getAdeUri() + "/restful/standard/AgileDataEngine/chartConvert";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("userId",user.getUserId());
        headers.set("Routerkey",user.getTenantId());
        headers.set("locale", lang);
        Map<String,Object> req = Maps.newHashMap();
        if(snapShotDTO != null) {
            req.put("snapshot", snapShotDTO);
        }
        req.put("chartType", transId);
        if(StringUtils.isNotEmpty(originalId)) {
            req.put("originalSnapshotDataFileId",originalId);
        }
        HttpEntity httpEntity = new HttpEntity(req,headers);
        try {
            log.info("获取ADE图表转换结果入参：{}", JsonUtils.objectToString(req));
            ResponseEntity<BaseResultDTO<Map<String, Object>>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>() {
                    });
            log.info("获取ADE图表转换结果集：{}", JsonUtils.objectToString(response.getBody().getResponse()));
            return response.getBody().getResponse();
        } catch (Exception e) {
            log.error("{}\n,请求url:{}\n, 请求token:{}\n,请求tenantId:{}\n,报错信息：{} "
                    , ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getErrCode(),
                    url, user.getToken(), user.getTenantId(), e.getMessage());
        }
        return null;
    }

    @Override
    public List<String> getTransList(SnapShotDTO snapShotDTO,AuthoredUser user, String lang) {
        String ptxId = JaMDC.getNotNullTraceId();
        MDC.put("traceId", ptxId);
        MDC.put("PtxId", ptxId);
        String url = adtEnvProperties.getAdeUri() + "/restful/standard/AgileDataEngine/snapshotConvertChart";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("userId",user.getUserId());
        headers.set("Routerkey",user.getTenantId());
        headers.set("locale", lang);
        headers.set("messageId",ptxId);
        Map<String,Object> req = Maps.newHashMap();
        req.put("snapshot",snapShotDTO);
        HttpEntity httpEntity = new HttpEntity(req,headers);
        try {
            log.info("获取ADE图表转换列表入参：{}", JsonUtils.objectToString(req));
            ResponseEntity<BaseResultDTO<Map<String, Object>>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>() {
                    });
            log.info("获取ADE图表转换列表集：{}", JsonUtils.objectToString(response.getBody().getResponse()));
            Map<String, Object> result  = response.getBody().getResponse();
            if(MapUtils.isEmpty(result)){
                return null;
            }
            List<String> transList = (List<String>) result.get("data");
            return transList;
        } catch (Exception e) {
            log.error("{}\n,请求url:{}\n, 请求token:{}\n,请求tenantId:{}\n,报错信息：{} "
                    , ErrorCodeEnum.ADE_REALTIME_SNAPDATA_FAIL.getErrCode(),
                    url, user.getToken(), user.getTenantId(), e.getMessage());
        }
        return null;
    }
}
