package com.digiwin.athena.adt.domain.cac;

import com.digiwin.athena.adt.domain.dto.cac.CacCurrent;
import com.digiwin.athena.adt.domain.dto.cac.CacDecreaseReq;
import com.digiwin.athena.adt.domain.dto.cac.CacGoods;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

/**
 * @Author: SunHong
 * @Date: 2024/7/24 13:58
 * @Description: cac
 */
public interface AthenaCacService {

    /**
     * 获取当前用户指定应用的授权信息 get
     * /api/cac/v4/authorizations/currentTenant/goods/{goodsCode}?apipost_id=4f95edc
     * @param user 用户信息
     * @param goodsCode 商品编码
     * @return cac 信息
     */
    CacGoods getCacCurrentTenantGoods(AuthoredUser user, String goodsCode);


    /**
     * cac根据userToken减少按次购买的模组计数器 post
     * /api/cac/v4/counting/decrease/bycurrenttenant
     * @param user 用户信息
     * @param req
     * @return
     */
    CacCurrent decreaseCurrentTenant(AuthoredUser user, CacDecreaseReq req);
}
