package com.digiwin.athena.adt.domain.chatbi;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSpecialUploadReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.SchemaPushReportResDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaLiteResDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaReqDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import java.util.Map;

public interface ChatbiService {

    /**
     * 调用chartBI接口,获取chartBI返回结果
     * @param reqDTO 语义识别入参
     */
    QuerySchemaResDTO getQuerySchema(QuerySchemaReqDTO reqDTO, AthenaMessageEvent event);

    /**
     * 调用chartBI接口,获取chartBI返回结果
     * @param msgBody
     */
    QuerySchemaResDTO getQuerySchemaV2(Map<String, Object> msgBody, AthenaMessageEvent event);

    QuerySchemaLiteResDTO getQuerySchemaSpecial(Map<String, Object> requestParam, AthenaMessageEvent event);

    SchemaPushReportResDTO schemaPushReport(AuthoredUser user, AgileDataSpecialUploadReqDTO req);

    QuerySchemaLiteResDTO getQuerySchemaSpecialLite(Map<String, Object> eventMap, AthenaMessageEvent event);

    Map<String, Object> getResultAnalysis(Map<String, Object> param,AuthoredUser user);
}
