package com.digiwin.athena.adt.domain.chatbi.impl;

import com.digiwin.athena.adt.agileReport.constant.BusinessConstants;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSpecialUploadReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.SchemaPushReportResDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.app.env.AdtEnvProperties;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaLiteResDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaReqDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;
import java.util.Map;

@Slf4j
@Service
public class ChatbiServiceImpl implements ChatbiService {

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private AdtEnvProperties adtEnvProperties;

    @Autowired
    private EchoService echoService;

    /**
     * 调用chartBI接口,获取chartBI返回结果
     * @param querySchemaReqDTO 语义入参实体
     */
   @Override
    public QuerySchemaResDTO getQuerySchema(QuerySchemaReqDTO querySchemaReqDTO, AthenaMessageEvent event) {
//        String url= adtEnvProperties.getChatBIUrl()+"/scrumbi/chat";
       // 原有接口统一替换为流式接口-旧链路,订阅,数据看板关闭流式
       querySchemaReqDTO.setCloseStream(true);
       String url= adtEnvProperties.getChatBIUrl()+"/scrumbi/stream/chat";
        HttpHeaders headers = new HttpHeaders();
        headers.set("locale", event.getLang());
        headers.set("token", event.getUser().getToken());
        headers.set("Routerkey",event.getUser().getTenantId());
        headers.set("userId",event.getUser().getUserId());
        headers.set("messageId",String.valueOf(event.getGenerateSerialNo()));
        headers.set("ptxId",String.valueOf(event.getPtxId()));
        HttpEntity httpEntity = new HttpEntity(querySchemaReqDTO,headers);

       long getQuerySchemaTook = System.currentTimeMillis();
       //记录全链路日志
       log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义入参：{}",event.getUser().getUserId(),event.getUser().getUserName()
               ,event.getUser().getTenantId(),event.getUser().getTenantName(), querySchemaReqDTO.getMessage(),JsonUtils.objectToString(querySchemaReqDTO));
           try {
               ResponseEntity<QuerySchemaResDTO> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity, QuerySchemaResDTO.class);
               log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义出参：{},耗时：{}ms", event.getUser().getUserId(),event.getUser().getUserName()
                       ,event.getUser().getTenantId(),event.getUser().getTenantName(), querySchemaReqDTO.getMessage(),
                       JsonUtils.objectToString(response),System.currentTimeMillis() - getQuerySchemaTook);
               return response.getBody();
           } catch (ResourceAccessException e){
               log.error("agiledata_ADT_ :耗时:{},问题位置:{},问题描述:{},错误内容:{},可能原因及排错指引导:{}",
                       System.currentTimeMillis() - getQuerySchemaTook,
                       BusinessConstants.ERROR_SEND_SCHEMA,
                       BusinessConstants.ERROR_SCHEMA_TIME_OUT,
                       event.getQuestion(),
                       BusinessConstants.ERROR_TIME_OUT_MESSAGE);
               echoService.echoSubmit(EchoSubmitReq.init(event,BusinessConstants.ERROR_SCHEMA_TIME_OUT,event.getQuestion()
                               ,BusinessConstants.ERROR_TIME_OUT_MESSAGE,"1"),
                       event.getUser().getToken(), event.getUser().getTenantId());
           } catch (Exception e){
               log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义出参：{},耗时:{}ms", event.getUser().getUserId(),event.getUser().getUserName()
                       ,event.getUser().getTenantId(),event.getUser().getTenantName(), querySchemaReqDTO.getMessage()
                       ,JsonUtils.objectToString(e.getMessage()),System.currentTimeMillis() - getQuerySchemaTook);
               echoService.echoSubmit(EchoSubmitReq.init(event,BusinessConstants.ERROR_SCHEMA
                               ,event.getQuestion(),  String.valueOf(e),"1"),
                       event.getUser().getToken(), event.getUser().getTenantId());
           }
        return null;
    }

    /**
     * 调用chartBI接口,获取chartBI返回结果
     * @param msgBody
     */
    @Override
    public QuerySchemaResDTO getQuerySchemaV2(Map<String, Object> msgBody, AthenaMessageEvent event) {
        String url= adtEnvProperties.getChatBIUrl()+"/scrumbi/v2/chat";

        msgBody.put("gptModel",adtEnvProperties.getChatGptModel());
        msgBody.put("gptProvider","RH");
        msgBody.put("strategy",adtEnvProperties.getChatStrategy());
        HttpHeaders headers = new HttpHeaders();
        headers.set("locale", event.getLang());
        headers.set("token", event.getUser().getToken());
        headers.set("Routerkey",event.getUser().getTenantId());
        headers.set("userId",event.getUser().getUserId());
        headers.set("messageId",String.valueOf(event.getGenerateSerialNo()));
        headers.set("ptxId",String.valueOf(event.getPtxId()));
        HttpEntity httpEntity = new HttpEntity(msgBody,headers);

        long getQuerySchemaTook = System.currentTimeMillis();

        //记录全链路日志
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义入参：{}",event.getUser().getUserId(),event.getUser().getUserName()
                ,event.getUser().getTenantId(),event.getUser().getTenantName(), MapUtils.getString(msgBody,"message"),JsonUtils.objectToString(msgBody));
            try {
                ResponseEntity<QuerySchemaResDTO> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity, QuerySchemaResDTO.class);
                log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义出参：{},耗时：{}ms", event.getUser().getUserId(),event.getUser().getUserName()
                        ,event.getUser().getTenantId(),event.getUser().getTenantName(), MapUtils.getString(msgBody,"message"),
                        JsonUtils.objectToString(response),System.currentTimeMillis() - getQuerySchemaTook);
                return response.getBody();
            } catch (ResourceAccessException e){
                log.error("agiledata_ADT_ :耗时:{},问题位置:{},问题描述:{},错误内容:{},可能原因及排错指引导:{}",
                        System.currentTimeMillis() - getQuerySchemaTook,
                        BusinessConstants.ERROR_SEND_SCHEMA,
                        BusinessConstants.ERROR_SCHEMA_TIME_OUT,
                        event.getQuestion(),
                        BusinessConstants.ERROR_TIME_OUT_MESSAGE);
                echoService.echoSubmit(EchoSubmitReq.init(event,BusinessConstants.ERROR_SCHEMA_TIME_OUT,event.getQuestion()
                                ,BusinessConstants.ERROR_TIME_OUT_MESSAGE,"1"),
                        event.getUser().getToken(), event.getUser().getTenantId());
            } catch (Exception e){
                log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义出参：{},耗时:{}ms", event.getUser().getUserId(),event.getUser().getUserName()
                        ,event.getUser().getTenantId(),event.getUser().getTenantName(), MapUtils.getString(msgBody,"message")
                        ,JsonUtils.objectToString(e.getMessage()),System.currentTimeMillis() - getQuerySchemaTook);
                echoService.echoSubmit(EchoSubmitReq.init(event,BusinessConstants.ERROR_SCHEMA
                                ,event.getQuestion(),  String.valueOf(e),"1"),
                        event.getUser().getToken(), event.getUser().getTenantId());
            }
        return null;
    }

    /**
     * 调用chartBI接口,获取chartBI返回结果
     * @param requestParam
     */
    @Override
    public QuerySchemaLiteResDTO getQuerySchemaSpecial(Map<String, Object> requestParam, AthenaMessageEvent event) {
        String url= adtEnvProperties.getChatBIUrl()+"/scrumbi/chat/demo";

        requestParam.put("gptModel",adtEnvProperties.getChatGptModel());
        requestParam.put("gptProvider","RH");
        requestParam.put("message",event.getQuestion());
        HttpHeaders headers = new HttpHeaders();
        headers.set("locale", event.getLang());
        headers.set("token", event.getUser().getToken());
        headers.set("Routerkey",event.getUser().getTenantId());
        headers.set("userId",event.getUser().getUserId());
        HttpEntity httpEntity = new HttpEntity(requestParam,headers);

        long getQuerySchemaTook = System.currentTimeMillis();
        //记录全链路日志
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义入参：{}",event.getUser().getUserId(),event.getUser().getUserName()
                ,event.getUser().getTenantId(),event.getUser().getTenantName(), MapUtils.getString(requestParam,"message"),JsonUtils.objectToString(requestParam));
        try {
            ResponseEntity<QuerySchemaLiteResDTO> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity, QuerySchemaLiteResDTO.class);
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义出参：{},耗时：{}s", event.getUser().getUserId(),event.getUser().getUserName()
                    ,event.getUser().getTenantId(),event.getUser().getTenantName(), MapUtils.getString(requestParam,"message"),
                    JsonUtils.objectToString(response),System.currentTimeMillis() - getQuerySchemaTook);
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "liteModel", LogUtils.SUCCESS,
                    JsonUtils.objectToString(requestParam), JsonUtils.objectToString(response), "");
            return response.getBody();
        } catch (ResourceAccessException e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "liteModel", TroubleToolCodeEnum.ADT_901_0105.getErrCode(),
                    JsonUtils.objectToString(requestParam), TroubleToolCodeEnum.ADT_901_0105.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0105.getSuggestion());
            log.error("agiledata_ADT_ :耗时:{},问题位置:{},问题描述:{},错误内容:{},可能原因及排错指引导:{}",
                    System.currentTimeMillis() - getQuerySchemaTook,
                    "敏捷数据助理入口(ADT)->语义理解组件(getQuerySchemaV2)",
                    "调用语义接口超时 ResourceAccessException",
                    event.getQuestion(),
                    "网络异常或者大语言模型服务异常，请访问http://xxxx.com查看当前网络监控状况");
            // 处理超时异常
        } catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "liteModel", TroubleToolCodeEnum.ADT_901_0106.getErrCode(),
                    JsonUtils.objectToString(requestParam), TroubleToolCodeEnum.ADT_901_0106.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0106.getSuggestion());
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义出参：{},耗时:{}s", event.getUser().getUserId(),event.getUser().getUserName()
                    ,event.getUser().getTenantId(),event.getUser().getTenantName(), MapUtils.getString(requestParam,"message"),
                    JsonUtils.objectToString(e.getMessage()),System.currentTimeMillis() - getQuerySchemaTook);
        }
        return null;
    }

    /**
     * 调用chartBI接口,获取chartBI返回结果
     * @param requestParam
     */
    @Override
    public QuerySchemaLiteResDTO getQuerySchemaSpecialLite(Map<String, Object> requestParam, AthenaMessageEvent event) {
        String url= adtEnvProperties.getChatBIUrl()+"/scrumbi/chat/lite";

        requestParam.put("gptModel",adtEnvProperties.getChatGptModel());
        requestParam.put("gptProvider","RH");
        HttpHeaders headers = new HttpHeaders();
        headers.set("locale", event.getLang());
        headers.set("token", event.getUser().getToken());
        headers.set("Routerkey",event.getUser().getTenantId());
        headers.set("userId",event.getUser().getUserId());
        HttpEntity httpEntity = new HttpEntity(requestParam,headers);

        long getQuerySchemaTook = System.currentTimeMillis();
        //记录全链路日志
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义入参：{}",event.getUser().getUserId(),event.getUser().getUserName()
                ,event.getUser().getTenantId(),event.getUser().getTenantName(), MapUtils.getString(requestParam,"message"),JsonUtils.objectToString(requestParam));
        try {
            ResponseEntity<QuerySchemaLiteResDTO> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity, QuerySchemaLiteResDTO.class);
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义出参：{},耗时：{}s", event.getUser().getUserId(),event.getUser().getUserName()
                    ,event.getUser().getTenantId(),event.getUser().getTenantName(), MapUtils.getString(requestParam,"message"),
                    JsonUtils.objectToString(response),System.currentTimeMillis() - getQuerySchemaTook);
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "liteModel", LogUtils.SUCCESS,
                    JsonUtils.objectToString(requestParam), JsonUtils.objectToString(response), "");
            return response.getBody();
        } catch (ResourceAccessException e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "liteModel", TroubleToolCodeEnum.ADT_901_0103.getErrCode(),
                    JsonUtils.objectToString(requestParam), TroubleToolCodeEnum.ADT_901_0103.getErrMsg(), TroubleToolCodeEnum.ADT_901_0103.getSuggestion());
            log.error("agiledata_ADT_ :耗时:{},问题位置:{},问题描述:{},错误内容:{},可能原因及排错指引导:{}",
                    System.currentTimeMillis() - getQuerySchemaTook,
                    "敏捷数据助理入口(ADT)->语义理解组件(getQuerySchemaV2)",
                    "调用语义接口超时 ResourceAccessException",
                    event.getQuestion(),
                    "网络异常或者大语言模型服务异常，请访问http://xxxx.com查看当前网络监控状况");
            // 处理超时异常
        } catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "liteModel",TroubleToolCodeEnum.ADT_901_0104.getErrCode(),
                    JsonUtils.objectToString(requestParam), TroubleToolCodeEnum.ADT_901_0104.getErrMsg(), TroubleToolCodeEnum.ADT_901_0104.getSuggestion());
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义出参：{},耗时:{}s", event.getUser().getUserId(),event.getUser().getUserName()
                    ,event.getUser().getTenantId(),event.getUser().getTenantName(), MapUtils.getString(requestParam,"message"),
                    JsonUtils.objectToString(e.getMessage()),System.currentTimeMillis() - getQuerySchemaTook);
        }
        return null;
    }

    @Override
    public SchemaPushReportResDTO schemaPushReport(AuthoredUser user, AgileDataSpecialUploadReqDTO req) {
        String url= adtEnvProperties.getFileparsing()+ "/fileparsing/pushReport/v2";

        HttpHeaders headers = new HttpHeaders();
        headers.set("token", user.getToken());
        headers.set("Routerkey",user.getTenantId());
        headers.set("tenantId",user.getTenantId());
        headers.set("userId",user.getUserId());
        headers.set("locale",req.getLocale());
        HttpEntity httpEntity = new HttpEntity(req,headers);
        long getQuerySchemaTook = System.currentTimeMillis();
        //记录全链路日志
        log.error("agiledata_ADT_{}_{}_{}_{}:lite版文件推送处理，语义入参：{}",user.getUserId(),user.getUserName()
                ,user.getTenantId(),user.getTenantName(),JsonUtils.objectToString(req));
        try {
            ResponseEntity<SchemaPushReportResDTO> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<SchemaPushReportResDTO>() {
                    });
            log.error("agiledata_ADT_{}_{}_{}_{}:lite版文件推送处理，语义出参：{},耗时：{}s", user.getUserId(),user.getUserName()
                    ,user.getTenantId(),user.getTenantName(),
                    JsonUtils.objectToString(response),System.currentTimeMillis() - getQuerySchemaTook);
            return response.getBody();
        } catch (ResourceAccessException e){
            log.error("agiledata_ADT_ :耗时:{},问题位置:{},问题描述:{},错误内容:{},可能原因及排错指引导:{}",
                    System.currentTimeMillis() - getQuerySchemaTook,
                    "敏捷数据助理入口(ADT)->语义理解组件(pushReport/v2)",
                    "调用语义接口超时 ResourceAccessException",
                    req,
                    "网络异常或者大语言模型服务异常，请访问http://xxxx.com查看当前网络监控状况");
            // 处理超时异常
        } catch (Exception e){
            log.error("agiledata_ADT_{}_{}_{}_{}:lite版文件推送处理，语义出参：{},耗时:{}s",user.getUserId(),user.getUserName()
                    ,user.getTenantId(),user.getTenantName(),
                    JsonUtils.objectToString(e.getMessage()),System.currentTimeMillis() - getQuerySchemaTook);
        }
        return null;
    }

    @Override
    public Map<String, Object> getResultAnalysis(Map<String, Object> param, AuthoredUser user) {
        String url= adtEnvProperties.getChatBIUrl()+"/scrumbi/resultAnalysis";
        HttpHeaders headers = new HttpHeaders();
        headers.set("token",user.getToken());
        headers.set("Routerkey",user.getTenantId());
        headers.set("userId",user.getUserId());
        HttpEntity httpEntity = new HttpEntity(param,headers);

        long getQuerySchemaTook = System.currentTimeMillis();
        //记录全链路日志
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取数据总结，语义识别，语义入参：{}",user.getUserId(),user.getUserName()
                ,user.getTenantId(),user.getTenantName(), "数据总结",JsonUtils.objectToString(param));
        try {
            ResponseEntity<Map<String, Object>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<Map<String, Object>>() {
                    });
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取数据总结，语义识别，语义出参：{},耗时：{}s", user.getUserId(),user.getUserName()
                    ,user.getTenantId(),user.getTenantName(), "数据总结",
                    JsonUtils.objectToString(response),System.currentTimeMillis() - getQuerySchemaTook);
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getResultAnalysis", LogUtils.SUCCESS,
                    JsonUtils.objectToString(param), JsonUtils.objectToString(response), "");
            return response.getBody();
        }  catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "getResultAnalysis",TroubleToolCodeEnum.ADT_901_0104.getErrCode(),
                    JsonUtils.objectToString(param), TroubleToolCodeEnum.ADT_901_0104.getErrMsg(), TroubleToolCodeEnum.ADT_901_0104.getSuggestion());
            log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取数据总结，语义识别，语义出参：{},耗时:{}s", user.getUserId(),user.getUserName()
                    ,user.getTenantId(),user.getTenantName(), "数据总结",
                    JsonUtils.objectToString(e.getMessage()),System.currentTimeMillis() - getQuerySchemaTook);
        }
        return null;
    }

}
