package com.digiwin.athena.adt.domain.dmc;

import com.digiwin.athena.adt.domain.dto.UploadAttachmentResp;
import com.digiwin.athena.adt.domain.dto.UploadParamDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import java.util.Collection;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2025/5/23 11:25
 * @Description:
 */
public interface DmcService {

    /**
     *  上传敏捷数据至DMC文件中心
     * @param uploadParamDTO
     * @return
     */
    UploadAttachmentResp uploadAgileData(UploadParamDTO uploadParamDTO,AuthoredUser user);

    /**
     * 获取敏捷数据
     * @param fileId
     * @return
     */
    SnapShotDTO getAgileData(String fileId);

    /**
     * 删除敏捷数据
     * @param fileId
     * @return
     */
    Map<String,Object> deleteAgileData(String fileId);


    /**
     * 批量删除文档中心敏捷数据
     *
     * @param fileIds 文档Id
     * @param dirIds  目录Id
     * @param token   租户对应token
     * @return
     */
    void deleteBatchAgileData(Collection<String> dirIds, Collection<String> fileIds, String token);

    /**
     * 获取敏捷数据
     * @param fileId
     * @return
     */
    SnapShotDTO getAgileDataByToken(String fileId,String token);
}
