package com.digiwin.athena.adt.domain.dto;

import lombok.Builder;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Map;

@Data
@Builder
public class AgileDataFeedBack {

    /**
     * 用户ID
     */
    private String userId;

    /**
     * 用户名称
     */
    private String userName;

    /**
     * 租户信息
     */
    private String tenantId;

    /**
     * 租户名称
     */
    private String tenantName;

    /**
     * 操作行为：0.点赞 1.点踩
     */
    private Integer feedbackType;

    /**
     * 端
     */
    private String terminal;

    /**
     * 消息ID
     */
    private Long generateSerialNo;

    /**
     * 快照ID
     */
    private String snapshotId;

    /**
     * 问题
     */
    private String question;

    /**
     * 用户意见
     */
    private String answerOpinion;

    /**
     * 反馈勾选项
     */
    private String backContent;

    /**
     * 反馈信息
     */
    private String checkOpinions;

    /**
     * 扩展信息
     */
    private Map<String,Object> extendInfo;

    /**
     * 创建时间
     */
    private LocalDateTime createBackTime;

    /**
     * 修改时间
     */
    private LocalDateTime modifyTime;

}
