package com.digiwin.athena.adt.domain.dto.ade;

import com.digiwin.athena.adt.domain.dto.SceneDefine;
import com.digiwin.athena.adt.domain.dto.agileReport.SceneDTO;
import lombok.Data;

import java.util.List;
import java.util.Map;

/*
和chartBI返回结果组成新入参发给ADE接口
 */
@Data
public class ADEScencDTO {

    /**
     * 模拟快照ID
     */
    private String snapshotId;
    /**
     * 租户ID
     */
    private String tenantId;
    /**
     * 请求用户
     */
    private String requestor;

    /**
     * 请求用户名
     */
    private String requestPersonName;

    /**
     *  元数据ID
     */
    private String actionId;

    /**
     * 场景CODE
     */
    private String sceneCode;
    /**
     * 请求时间
     */
    private String requestTime;
    /**
     * 语言类别 “zh_CN”
     */
    private String locale;

    private Map<String, Object> data;
    /**
     * 场景
     */
    private SceneDTO scene;
    /**
     *语义返回的资产中心查询信息
     */
    private Map<String, Object> querySchema;
    /**
     *语义返回的图谱查询信息
     */
    private Map<String, Object> recast;

    /**
     * 语义返回场景信息（只有资产中心查询时才会返回）
     */
    private SceneDefine sceneDefine;

    private List<Map<String, Object>> eocMaps;

    private String templateCode;

    private String target;

    private Object dimension;

    /**
     * 多维数量
     */
    private Integer dimensionCnt;

    /**
     * ade 扩展
     */
    private Map<String,Object> param;

    private String question;

    private String messageId;

    private String method;

    /**
     * 多产品线
     */
    private List<Map<String,Object>> productLineInfo;

    private String productVersion;
}
