package com.digiwin.athena.adt.domain.dto.ade;

import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.agileReport.SceneDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaDatasetDTO;
import com.digiwin.athena.adt.domain.dto.schema.SchemaMetricShowDefine;
import com.digiwin.athena.appcore.util.TimeUtils;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @Author: SunHong
 * @Date: 2025/5/19 9:55
 * @Description:
 */
@Data
public class AdeDatasetReqDTO implements Serializable {

    private List<Map<String,Object>> eocMaps;

    private String locale;

    private String messageId;

    private boolean mock;

    private Map<String,Object> param;

    private String question;

    private String method;

    private Map<String,Object> dataset;

    private List<Map<String,Object>> dataTag;

    private SchemaMetricShowDefine showDefine;

    private String requestTime;

    private String requestor;

    private String tenantId;

    private String appCode;

    private List<Map<String,Object>> datasetList;

    private SceneDTO scene;

    private Integer dimensionCnt;

    /**
     * 多产品线
     */
    private List<Map<String,Object>> productLineInfo;

    /**
     * 解题思路
     */
    private String explain4Gpt;

    private String productVersion;

    private boolean tablePreviewIf;

    /**
     * 数据字典
     */
    private List<Map<String,Object>> fieldSchema;

    public static AdeDatasetReqDTO BuildDatasetAdeReq(AthenaMessageEvent event, QuerySchemaDatasetDTO dataset) {
        AdeDatasetReqDTO adeDatasetReqDTO = new AdeDatasetReqDTO();
        Map<String,Object> solutionStep = new HashMap<>();
        SchemaMetricShowDefine showDefine = dataset.getShowDefine();
        if(Objects.isNull(showDefine) || CollectionUtils.isEmpty(showDefine.getShowType())){
            throw new IllegalArgumentException("语义呈现数据未返回,未找到对应actionId");
        }
        Map<String,Object> param = new HashMap<>();
        // 2.0 订阅消息 写入 特定的type
        if(event.isSubscribe()){
            param.put("type","2");
            param.put("undeletable",event.isUndeletable());
            param.put("asaCode",event.getAsaCode());
            param.put("ruleId",event.getMsgExt().get("ruleId"));
            adeDatasetReqDTO.setParam(param);
        }
        String actionId = showDefine.getShowType().get(0).getActionId();
        solutionStep.put(actionId,dataset.getSolutionStep());
        adeDatasetReqDTO.setEocMaps(dataset.getEocMaps());
        adeDatasetReqDTO.setDatasetList(dataset.getDatasetList());
        adeDatasetReqDTO.setAppCode(event.getAppCode());
        adeDatasetReqDTO.setLocale(event.getLang());
        adeDatasetReqDTO.setMessageId(String.valueOf(event.getGenerateSerialNo()));
        adeDatasetReqDTO.setParam(param);
        adeDatasetReqDTO.setMock(false);
        adeDatasetReqDTO.setQuestion(event.getQuestion());
        adeDatasetReqDTO.setMethod(SchemaDataEnum.DATASET.getCode());
        adeDatasetReqDTO.setScene(event.getSceneDTO());
        adeDatasetReqDTO.setDataset(solutionStep);
        adeDatasetReqDTO.setDataTag(dataset.getDataTag());
        adeDatasetReqDTO.setShowDefine(showDefine);
        adeDatasetReqDTO.setDimensionCnt(dataset.getDimensionCnt());
        adeDatasetReqDTO.setRequestTime(TimeUtils.format(LocalDateTime.now(), "yyyy-MM-dd HH:mm:ss") );
        adeDatasetReqDTO.setRequestor(event.getUser().getUserId());
        adeDatasetReqDTO.setTenantId(event.getUser().getTenantId());
        adeDatasetReqDTO.setProductLineInfo(event.getProductLineInfo());
        adeDatasetReqDTO.setExplain4Gpt(dataset.getExplain4Gpt());
        adeDatasetReqDTO.setProductVersion(event.getProductVersion());
        adeDatasetReqDTO.setTablePreviewIf(dataset.isTablePreviewIf());
        return adeDatasetReqDTO;
    }
}
