package com.digiwin.athena.adt.domain.dto.ade;

import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.agileReport.SceneDTO;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.appcore.util.TimeUtils;
import lombok.Data;
import org.apache.commons.collections.MapUtils;
import org.springframework.context.i18n.LocaleContextHolder;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.*;

/**
 * @Author: SunHong
 * @Date: 2024/8/8 16:56
 * @Description:
 */
@Data
public class AdeSpecialReqDTO implements Serializable {

    /**
     * 租户ID
     */
    private String tenantId;
    /**
     * 请求用户
     */
    private String requestor;
    /**
     * 请求用户名
     */
    private String requestPersonName;
    /**
     *  元数据ID
     */
    private String actionId;
    /**
     * 请求时间
     */
    private String requestTime;
    /**
     * 语言类别 “zh_CN”
     */
    private String locale;
    /**
     * 场景
     */
    private SceneDTO scene;
    /**
     *语义返回的图谱查询信息
     */
    private Map<String, Object> recastDefine;
    /**
     * ade 扩展
     */
    private Map<String,Object> param;

    private Map<String,Object> showDefine;
    /**
     * 请求类型 target/designer
     */
    private String requestType;
    /**
     * 语言类别 “zh_CN”
     */
    private String applicationCode;
    /**
     * 场景
     */
    private String version;

    private String intentCode;
    /**
     * 多维数量
     */
    private Integer dimensionCnt;

    public static AdeSpecialReqDTO buildAdeReq(Map<String, Object> data, AthenaMessageEvent event) {
        AdeSpecialReqDTO adeSpecialReqDTO = new AdeSpecialReqDTO();
        String actionId = String.valueOf(SnowflakeIdWorker.getInstance().newId());
        Map<String,Object> msgExt = event.getMsgExt();

        // 2.0 订阅消息 写入 特定的type
        if(!Objects.isNull(msgExt) && !Objects.isNull(msgExt.get("type"))
                && "agileSubscribe".equals(String.valueOf(msgExt.get("type"))) ){
            Map<String,Object> param = MapUtil.newHashMap();
            param.put("type","2");
            param.put("asaCode",event.getAsaCode());
            adeSpecialReqDTO.setParam(param);
        }
        adeSpecialReqDTO.setTenantId(event.getUser().getTenantId());
        adeSpecialReqDTO.setRequestor(event.getUser().getUserId());
        adeSpecialReqDTO.setRequestPersonName(event.getUser().getUserName());
        adeSpecialReqDTO.setLocale(LocaleContextHolder.getLocale().toString());
        adeSpecialReqDTO.setRequestTime(TimeUtils.format(LocalDateTime.now(), "yyyy-MM-dd HH:mm:ss"));
        adeSpecialReqDTO.setScene(event.getSceneDTO());
        adeSpecialReqDTO.setActionId(actionId);
        adeSpecialReqDTO.setVersion(event.getVersion());
        adeSpecialReqDTO.setApplicationCode(event.getAppCode());
        Map<String,Object> recast = MapUtil.newHashMap();
        List<Map<String,Object>> dataList = new ArrayList<>();
        Map<String,Object> showDefine = MapUtil.newHashMap();
        dataList.add(data);
        recast.put(actionId,dataList);
        adeSpecialReqDTO.setRecastDefine(recast);
        Map<String,Object> show = MapUtils.getMap(data,"show");
        List<Map<String,Object>> showType = new ArrayList<>();
        Map<String,Object> map = new HashMap<>();
        List<Map<String,Object>> typeList = new ArrayList<>();
        Map<String,Object> type = new HashMap<>();
        type.put("title"," ");
        type.put("value",show.get("showType"));
        typeList.add(type);
        map.put("type",typeList);
        map.put("actionId",actionId);
        showType.add(map);
//        showDefine.put("show","");
        showDefine.put("showType",showType);
        adeSpecialReqDTO.setRequestType("special");
        adeSpecialReqDTO.setShowDefine(showDefine);
        adeSpecialReqDTO.setIntentCode(String.valueOf(data.get("intent_code")));
        adeSpecialReqDTO.setDimensionCnt(MapUtils.getInteger(data, "dimensionCnt",null));
        event.setQuestionUnderstand(String.valueOf(data.get("Analysis")));
        return adeSpecialReqDTO;
    }
}
