package com.digiwin.athena.adt.domain.dto.agileReport;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import com.digiwin.athena.adt.domain.dto.SceneDefine;
import lombok.Data;

@Data
public class BizParamsDTO {

    /**
     * 业务已知参数
     */
    private InputParamsDTO inputParams;


    private List<Map<String, Object>> eocMaps;

    /**
     * 请求发起人
     */
    private String requestPerson;

    /**
     * 请求发起人姓名
     */
    private String requestPersonName;

    /**
     * 请求发起时间
     */
    private LocalDateTime requestTime;

    /**
     * 租户ID
     */
    private String tenantId;

    /**
     * 快照模式
     */
    private String requestType;

    /**
     * 架构模式 metric指标 dataFlow场景
     */
    private String method;

    /**
     * monitor（可选）
     */
    private MonitorDTO monitor;

    /**
     * 资产中心条件
     */
    private Map<String,Object> querySchema;

    /**
     * 场景信息
     */
    private SceneDefine sceneDefine;

    /**
     * 图谱条件
     */
    private Map<String,Object> recast;

    /**
     * 图谱条件
     */
    private Map<String,Object> backRecast;

    /**
     * 指标步骤
     */
    private Map<String,Object> metric;

    /**
     * 呈现定义
     */
    private Map<String,Object> showDefine;

    /**
     * 维度区间
     */
    private Map<String,Object> dimensionInterval;

    /**
     * 维度个数
     */
    private Integer dimensionCnt;

    /**
     * 场景编码
     */
    private String sceneCode;

    /**
     * ade 扩展
     */
    private Map<String,Object> param;

    /**
     * 问句
     */
    private String question;

    /**
     * 消息id
     */
    private String messageId;


    /**
     * 产品线信息
     */
    private List<Map<String,Object>> productLineInfo;


    /**
     * 分类信息
     */
    private List<Map<String,Object>> builtClassifications;

    /**
     * 截取数据
     * interception
     */
    private String dataProcessAction;

    /**
     * 截取数据长度
     * interceptSize
     */
    private Integer interceptSize;

    /**
     * 原始快照数据文件id
     */
    private String originalSnapshotDataFileId;

    /**
     * 数据转换图表集合
     */
    private List<String> transIds;

    /**
     * 数据转换截取提示
     */
    private String transTips;

    /**
     * 数据总结token量超过阈值
     */
    private Boolean exceedSummarizeSize;

    /**
     * 数据版本号
     */
    private String productVersion;

    private List<Map<String,Object>> dataTagParam;

    private String explain4Gpt;

    private Map<String,Object> dataset;

    private List<Map<String,Object>> datasetList;

    /**
     * 是否查询出数据
     */
    private boolean queryDataFlag;
}
