package com.digiwin.athena.adt.domain.dto.echo;

import com.digiwin.athena.adt.agileReport.constant.BusinessConstants;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.Data;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/7/25 16:29
 * @Description:
 */
@Data
public class EchoSubmitReq implements Serializable {

    /**
     * 组件编码
     */
    @NotBlank
    private String appCode;

    /**
     * 组件名称
     */
    @NotBlank
    private String appName;

    private long messageId;

    private String pixBackendId;

    private String pixFrontId;

    /**
     * 问题描述
     */
    private String description;

    /**
     * 问题内容
     */
    private String content;

    /**
     * 可能原因及排错指引
     */
    private String extend;

    private String informationType;

    private Date createTime;

    /**
     * 多目标多场景返回字段
     */
    private List<Map<String,Object>> selectMultiple;

    /**
     * 截取标识语句
     */
    private String dataTipMessage;

    private List<Map<String,Object>> stepAnalysis;

    public static EchoSubmitReq init(AthenaMessageEvent event,
                                     String description,
                                     String content,
                                     String extend,
                                     String informationType) {
        EchoSubmitReq echoSubmitReq = new EchoSubmitReq();
        echoSubmitReq.setAppCode("adt");
        echoSubmitReq.setAppName("敏捷数据入口");
        echoSubmitReq.setMessageId(event.getGenerateSerialNo());
        echoSubmitReq.setPixBackendId(String.valueOf(event.getPtxId()));
        echoSubmitReq.setCreateTime(new Date());
        echoSubmitReq.setDescription(description);
        echoSubmitReq.setContent(content);
        echoSubmitReq.setExtend(extend);
        echoSubmitReq.setInformationType(informationType);
        return echoSubmitReq;
    }

    /**
     * 多场景/多目标/多应用/多指标/多sheet echo消息组装
     * @param event 上下文
     * @param maps list
     */
    public static EchoSubmitReq builderSchemaGuidance(AthenaMessageEvent event, List<Map<String, Object>> maps) {
        event.setGetMessageInfo(true);
        Map<String,Object> echoParam = new HashMap<>();
        // 达到告警阈值需要告警记录 echo 日志
        echoParam.put("userId",event.getUser().getUserId());
        echoParam.put("tenantId",event.getUser().getTenantId());
        EchoSubmitReq submitReq = EchoSubmitReq.init(event, BusinessConstants.SELECT_MULTIPLE_TITLE
                ,event.getQuestion(), JsonUtils.objectToString(echoParam),"0");
        submitReq.setExtend(JsonUtils.objectToString(echoParam));
        submitReq.setContent(event.getQuestion());
        submitReq.setDescription(BusinessConstants.SELECT_MULTIPLE_TITLE);
        submitReq.setSelectMultiple(maps);
        return submitReq;
    }

    /**
     * 计费阈值提醒echo消息组装
     * @param event 上下文
     * @param remainingUsage cac可用流量次数
     * @param thresholdNum 阈值提醒次数
     */
    public static EchoSubmitReq builderCostAlarm(AthenaMessageEvent event, int remainingUsage, int thresholdNum) {
        event.setGetMessageInfo(true);
        Map<String,Object> echoParam = new HashMap<>();
        // 达到告警阈值需要告警记录 echo 日志
        echoParam.put("goodsCode",event.getGoodsCode());
        echoParam.put("appCode",event.getAppCode());
        echoParam.put("userId",event.getUser().getUserId());
        echoParam.put("tenantId",event.getUser().getTenantId());
        echoParam.put("remainingUsage",remainingUsage);
        echoParam.put("thresholdNum",thresholdNum);
        EchoSubmitReq submitReq = EchoSubmitReq.init(event, BusinessConstants.WARN_COST_TITLE
                ,event.getQuestion(),JsonUtils.objectToString(echoParam),"0");
        submitReq.setExtend(JsonUtils.objectToString(echoParam));
        submitReq.setInformationType("0");
        submitReq.setContent(event.getQuestion());
        submitReq.setDescription(BusinessConstants.WARN_COST_TITLE);
        return submitReq;
    }

    public static EchoSubmitReq builderInterception(AthenaMessageEvent event,
                                                    MessageUtil messageUtil,
                                                    Integer interceptionSize) {
        event.setGetMessageInfo(true);
        Map<String,Object> echoParam = new HashMap<>();
        echoParam.put("userId",event.getUser().getUserId());
        echoParam.put("tenantId",event.getUser().getTenantId());
        EchoSubmitReq submitReq = EchoSubmitReq.init(event, BusinessConstants.INTERCEPTION
                ,event.getQuestion(),JsonUtils.objectToString(echoParam),"0");
        submitReq.setExtend(JsonUtils.objectToString(echoParam));
        submitReq.setInformationType("0");
        submitReq.setContent(event.getQuestion());
        submitReq.setDescription(BusinessConstants.INTERCEPTION);
        String dataTipMessage = messageUtil.getMessageByLangNameWithFormat(
                "message.adt.message.page",event.getLang(),interceptionSize);
        submitReq.setDataTipMessage(dataTipMessage);
        return submitReq;
    }

    public static EchoSubmitReq builderStepAnalysis(AthenaMessageEvent event, List<Map<String, Object>> steps) {
        event.setGetMessageInfo(true);
        Map<String,Object> step = new HashMap<>();
        step.put("userId",event.getUser().getUserId());
        step.put("tenantId",event.getUser().getTenantId());
        EchoSubmitReq submitReq = EchoSubmitReq.init(event, BusinessConstants.STEP_ANALYSIS
                ,event.getQuestion(), JsonUtils.objectToString(step),"0");
        submitReq.setExtend(JsonUtils.objectToString(step));
        submitReq.setContent(event.getQuestion());
        submitReq.setDescription(BusinessConstants.STEP_ANALYSIS);
        submitReq.setStepAnalysis(steps);
        return submitReq;
    }
}
