package com.digiwin.athena.adt.domain.dto.mongo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2025/5/19 15:19
 * @Description: 助理前端定制组件存储集合
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Document("agile_data_custom_config")
public class AgileDataCustomConfig implements Serializable {


    @Id
    private String id;

    private String version;

    private List<Map<String,Object>> pluginCustoms;

}
