package com.digiwin.athena.adt.domain.dto.schema;

import com.digiwin.athena.adt.util.CommonUtil;
import lombok.Data;
import org.apache.commons.compress.utils.Lists;
import org.apache.poi.ss.formula.functions.T;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/5/20 17:47
 * @Description: sort
 */
@Data
public class ConditionStatisticsSort implements Serializable {

    private String mode;

    private String statisticalMethod;

    private String type;

    private List<T> statisticalFields;

    public static Map<String, Object> builderSort(QuerySchemaDebugDTO querySchemaDebugDTO) {
        ConditionStatisticsSort statisticsSort = new ConditionStatisticsSort();
        statisticsSort.setMode("normal");
        statisticsSort.setStatisticalMethod("sort");
        statisticsSort.setStatisticalFields(Lists.newArrayList());
        statisticsSort.setType(querySchemaDebugDTO.getSortValue());
        return CommonUtil.convertObjectToMap(statisticsSort);
    }
}
