package com.digiwin.athena.adt.domain.dto.schema;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2025/5/16 10:04
 * @Description:
 */
@Data
public class QuerySchemaDatasetDTO implements Serializable {

    /** 意图状态码 */
    private Integer code;

    /** 查询步骤集合 */
    private List<Map<String,Object>> solutionStep;

    /** 数值类型显示数据标签 */
    private List<Map<String,Object>> dataTag;

    /** 呈现数据 */
    private SchemaMetricShowDefine showDefine;

    /** 语义返回的导引语句 */
    private String reply;

    /** 计费流量包id */
    private String billingGoodsId;

    /** 多公司 */
    private List<Map<String,Object>> eocMaps;

    /** 上下文理解后的问句 */
    private String combinationQuestion;

    /** 应用集合 */
    private List<Map<String,Object>> applicationList;

    /** 取数小数位 */
    private Integer dimensionCnt;

    /** 多产品线 */
    private List<Map<String,Object>> productLineInfo;

    /** 解题思路 */
    private String explain4Gpt;

    private String questionUnderstand;

    /** metric 猜你想问/相关推荐 */
    private List<String> sentences;

    /** 句子类型：2：猜你想问，1：相关推荐 */
    private Integer sentenceType;

    /** 2.0 数据集 集合 */
    private List<Map<String,Object>> datasetList;

    /** 2.0 数据预览标识 默认false */
    private boolean tablePreviewIf;

    /** 计费应用id */
    private String appCode;

}
