package com.digiwin.athena.adt.domain.dto.schema;

import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

/**
 * @Author: SunHong
 * @Date: 2024/5/20 11:40
 * @Description: 约定问句debug解析入参
 */
@Data
public class QuerySchemaDebugDTO implements Serializable {

    private String sceneCode;

    private String applicationCode;

    private String question;

    private String dimensionName;

    private String dimensionValue;

    private String timeName;

    private String timeStart;

    private String timeEnd;

    private String sortName;

    private String sortValue;

    private String limitName;

    private String limitValue;

    private String templateCodeName;

    private String templateCodeValue;

    private String targetName;

    private String targetValue;

    private String exDimensionName;

    private List<String> exDimensionValue;


    /**
     * 1.2
     * 组装解析问句实体
     *
     * @param partList 入参 time,sort,limit,demission
     * @return 问句实体
     */
    public static QuerySchemaDebugDTO builderDebugByParams(List<String> partList) {
        QuerySchemaDebugDTO querySchemaDebugDTO = new QuerySchemaDebugDTO();
        try{
            if (CollectionUtils.isEmpty(partList)) {
                return querySchemaDebugDTO;
            }
            //指定下标debug 为问句
            if (StringUtils.isNotEmpty(partList.get(0)) && (partList.get(0).equals("debug")
                    || partList.get(0).equals("test"))) {
                querySchemaDebugDTO.setQuestion(partList.get(2));
            }
            if (partList.get(0).equals("metric")) {
                if(partList.size() > 2){
                    querySchemaDebugDTO.setQuestion(partList.get(2));
                    querySchemaDebugDTO.setApplicationCode(partList.get(1));
                } else {
                    querySchemaDebugDTO.setQuestion(partList.get(1));
                }
            }
            // debug pr-debug 都传
            querySchemaDebugDTO.setSceneCode(partList.get(1));
            partList.forEach(dto -> {
                if (dto.contains(":")) {
                    String[] parts = dto.split(":");
                    String key = parts[0];
                    String value = parts[1];
                    switch (key) {
                        case "time":
                            String[] timeValue = parts[1].split("\\|");
                            if (timeValue.length >= 1) {
                                String[] params = timeValue[1].split("#");
                                if (params.length == 2) {
                                    querySchemaDebugDTO.setTimeName(timeValue[0]);
                                    querySchemaDebugDTO.setTimeStart(params[0]);
                                    querySchemaDebugDTO.setTimeEnd(params[1]);
                                }
                            }
                            break;
                        case "dimension":
                            querySchemaDebugDTO.setDimensionName(key);
                            querySchemaDebugDTO.setDimensionValue(value);
                            break;
                        case "sort":
                            String[] sortValue = parts[1].split("\\|");
                            if (sortValue.length >= 1) {
                                querySchemaDebugDTO.setSortName(sortValue[0]);
                                querySchemaDebugDTO.setSortValue(sortValue[1]);
                            }
                            break;
                        case "limit":
                            querySchemaDebugDTO.setLimitName(key);
                            querySchemaDebugDTO.setLimitValue(value);
                            break;
                        case "exDimension":
                            String[] exDimensions = parts[1].split("\\|");
                            querySchemaDebugDTO.setExDimensionName(key);
                            querySchemaDebugDTO.setExDimensionValue(Arrays.asList(exDimensions));
                            break;
                        case "templateCode":
                            querySchemaDebugDTO.setTemplateCodeName(key);
                            querySchemaDebugDTO.setTemplateCodeValue(value);
                            break;
                        case "target":
                            querySchemaDebugDTO.setTargetName(key);
                            querySchemaDebugDTO.setTargetValue(value);
                            break;
                        default:
                            break;
                    }
                }
            });
        }catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "analysisQuestion", TroubleToolCodeEnum.ADT_901_0107.getErrCode(),
                    JsonUtils.objectToString(partList), TroubleToolCodeEnum.ADT_901_0107.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0107.getSuggestion());
        }
        LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "analysisQuestion", LogUtils.SUCCESS,
                JsonUtils.objectToString(partList), JsonUtils.objectToString(querySchemaDebugDTO), "");
        return querySchemaDebugDTO;
    }

    /**
     * 解析param模式下的问句
     *
     * @param partList
     * @return
     */
    public static QuerySchemaDebugDTO builderParamByParams(List<String> partList) {
        QuerySchemaDebugDTO querySchemaDebugDTO = new QuerySchemaDebugDTO();
        try{
            if (CollectionUtils.isEmpty(partList)) {
                return querySchemaDebugDTO;
            }
            //指定下标param 为问句
            if (StringUtils.isNotEmpty(partList.get(0))) {
                if (partList.size() > 1) {
                    querySchemaDebugDTO.setQuestion(partList.get(1));
                }
                if (partList.size() > 2) {
                    querySchemaDebugDTO.setSceneCode(partList.size() > 2 ? partList.get(2) : null);
                }
            }
        }catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "analysisQuestion", TroubleToolCodeEnum.ADT_901_0108.getErrCode(),
                    JsonUtils.objectToString(partList), TroubleToolCodeEnum.ADT_901_0108.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0108.getSuggestion());
        }
        LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "analysisQuestion", LogUtils.SUCCESS,
                JsonUtils.objectToString(partList), JsonUtils.objectToString(querySchemaDebugDTO), "");
        return querySchemaDebugDTO;
    }
}
