package com.digiwin.athena.adt.domain.dto.schema;

import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.util.CommonUtil;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

/**
 * @Author: SunHong
 * @Date: 2024/9/13 10:16
 * @Description: 语义识别入参
 */
@Data
public class QuerySchemaReqDTO implements Serializable {

    /** 用户问句 */
    private String message;

    /** 是否开启多轮 */
    private Boolean multiDialogue;

    /** 调试输出解释器*/
    private Boolean explain;

    /** 时间戳调试*/
    private Boolean timeTrace;

    /** 多轮sessionId */
    private String sessionId;

    /** 目标id */
    private String targetId;

    /** 场景编号 */
    private String sceneCode;

    /** 1:param (sceneCode必传);2:pr-param；3:debug(sceneCode必传)；4:test(sceneCode必传) */
    private String debugMode;

    /** 指标id列表 可选 可以是多个指标，用于订阅和指标导正 */
    private List<String> metricIdList;

    /** 应用编码 */
    private String appCode;

    /** 应用版本号 */
    private String version;

    /** 当前数据流的模式，metric指标，dataFlow场景数据流 */
    private String method;

    /** 用户id */
    private String userId;

    /** 用户名称 */
    private String userName;

    /**
     * 娜娜融合 上下⽂组合消息
     */
    private String combinationMsg;

    /**
     * 助理编码
     */
    private String asaCode;

    /**
     * 是否关闭流式返回
     */
    private boolean closeStream;


    /** 应用版本号 */
    private String productVersion;


    /** 指标id列表 可选 可以是多个指标，用于订阅和指标导正 */
    private List<String> datasetIdList;

    private boolean probe;

    /**
     * 2.0 段落会话id
     */
    private String sectionId;

    /**
     * 2.0 段落每句的消息id
     */
    private String messageId4Ania;

    /**
     * 2.0 会话id
     */
    private String conversationId;
    /**
     * 语义识别入参初始化
     * @param event 上下文
     * @return 语义识别入参
     */
    public static QuerySchemaReqDTO builderSchemaReq(AthenaMessageEvent event) {
        QuerySchemaReqDTO querySchemaReqDTO = new QuerySchemaReqDTO();
        querySchemaReqDTO.setUserId(event.getUser().getUserId());
        querySchemaReqDTO.setUserName(event.getUser().getUserName());
        querySchemaReqDTO.setSessionId(event.getSessionId());
        querySchemaReqDTO.setMessage(event.getQuestion());
        querySchemaReqDTO.setAsaCode(event.getAsaCode());
        return querySchemaReqDTO;
    }

    /**
     * 场景模式语义入参构造 designer
     * @param event 上下文
     * @return 请求实体
     */
    public static QuerySchemaReqDTO builderSchemaDesignerReq(AthenaMessageEvent event) {

        QuerySchemaReqDTO req = event.getQuerySchemaReqDTO();
        //场景编码
        req.setSceneCode(MapUtils.getString(event.getMsgExt(), "sceneCode"));
        //多目标
        req.setTargetId(MapUtils.getString(event.getMsgExt(), "targetId"));

        if(StringUtils.isEmpty(req.getAppCode())){
            req.setAppCode(MapUtils.getString(event.getMsgExt(), "applicationCode"));
        }
        List<String> metricIdListObj = CommonUtil.objConvertListString(event.getMsgExt().get("metricIdList"));
        String multiDialogue = MapUtils.getString(event.getMsgExt(), "multiDialogue");
        if(StringUtils.isNotEmpty(multiDialogue)){
            req.setMultiDialogue(Boolean.valueOf(multiDialogue));
        }
        // 娜娜融合时 会发送metricId 如果存在则使用娜娜发送的metricId
        if(CollectionUtils.isEmpty(req.getMetricIdList())){
            req.setMetricIdList(metricIdListObj);
        }
        // 多场景标识 第一轮不传 第二轮 有sceneCode 传3
        if(event.isDebug()) {
            req.setDebugMode("3");
            // 关闭多轮
            req.setMultiDialogue(false);
        }
        if(StringUtils.isNotEmpty(req.getSceneCode()) || StringUtils.isNotEmpty(req.getTargetId())
                || CollectionUtils.isNotEmpty(req.getMetricIdList())
                || StringUtils.isNotEmpty(req.getAppCode())){
            if(!req.getMultiDialogue()){
                req.setMultiDialogue(false);
            }
        }
        return req;
    }

    /**
     * 指标模式metricDebug 入参构造
     * @param event 上下文
     * @return 请求实体
     */
    public static QuerySchemaReqDTO builderSchemaMetricDebugReq(AthenaMessageEvent event,
                                                                QuerySchemaDebugDTO querySchemaDebugDTO) {
        QuerySchemaReqDTO req = event.getQuerySchemaReqDTO();
        // 2.0.1 重新定义问句
        req.setMessage(querySchemaDebugDTO.getQuestion());
        req.setDebugMode("5");
        req.setAppCode(querySchemaDebugDTO.getApplicationCode());
        req.setMultiDialogue(false);
        event.setDebug(true);
        return req;
    }

    /**
     * param 入参构造
     * @param event 上下文
     * @return 请求实体
     */
    public static QuerySchemaReqDTO builderSchemaParamReq(AthenaMessageEvent event,
                                                          QuerySchemaDebugDTO querySchemaParamDTO) {
        QuerySchemaReqDTO req = event.getQuerySchemaReqDTO();
        String question = event.getQuestion();
        if (question.contains("*param*")) {
            // param标识
            req.setDebugMode("1");
        }
        if (question.contains("*pr-param*")) {
            // pr-param标识
            req.setDebugMode("2");
        }
        // 2.0 透传kmCode编码给语义
        if(StringUtils.isNotEmpty(querySchemaParamDTO.getSceneCode())){
            req.setSceneCode(querySchemaParamDTO.getSceneCode());
        }
        // querySchemaParamDTO get real question
        // 2.0.1 重新定义问句
        req.setMessage(querySchemaParamDTO.getQuestion());
        // 关闭多轮
        req.setMultiDialogue(false);
        return req;
    }
}
