package com.digiwin.athena.adt.domain.dto.schema;

import com.digiwin.athena.adt.agileReport.constant.SchemaConstants;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.Data;

import java.util.*;


/*
用于接收chartBI返回结果
 */
@Data
public class QuerySchemaResDTO {
    /**
     *回复响应码 例如：200
     */
    private Integer code;
    /**
     *回复操作成功
     */
    private String msg;

    /** 新架构返回数据结构汇总 (暂无作用 只接收http请求)*/
    private QuerySchemaDataDTO data;
    /**
     * 两种方式
     * dataFlow = designer /metric = metric
     */
    private String route;

    /** 2.1.1
     * 组装preDebug 语义实体
     * @param querySchemaDebugDTO 约定解析入参
     * @return 语义实体
     */
    public static QuerySchemaResDTO builderPrDebug(QuerySchemaDebugDTO querySchemaDebugDTO) {
        QuerySchemaResDTO querySchemaResDTO = new QuerySchemaResDTO();
        try{
            List<Map<String, Object>> results = new ArrayList<>();
            querySchemaResDTO.setCode(200);
            Map<String, Object> map = new HashMap<>();
            map.put("sceneCode", querySchemaDebugDTO.getSceneCode());
            map.put("templateCode", querySchemaDebugDTO.getTemplateCodeValue());
            map.put("target", querySchemaDebugDTO.getTargetValue());
            map.put("dimension", querySchemaDebugDTO.getExDimensionValue());
            map.put("code",1);
            List<Map<String, Object>> dataList = new ArrayList<>();
            Optional.ofNullable(querySchemaDebugDTO.getTimeName())
                    .map(name -> assembleTimeCondition(querySchemaDebugDTO))
                    .ifPresent(dataList::add);
            Optional.ofNullable(querySchemaDebugDTO.getLimitName())
                    .map(name -> assembleLimitCondition(querySchemaDebugDTO))
                    .ifPresent(dataList::add);
            Optional.ofNullable(querySchemaDebugDTO.getSortName())
                    .map(name -> assembleSortCondition(querySchemaDebugDTO))
                    .ifPresent(dataList::add);
            map.put("data",dataList);
            results.add(map);
            QuerySchemaDataDTO data = new QuerySchemaDataDTO();
            data.setMethod(SchemaConstants.METHOD_DATA_FLOW);
            data.setDataflow(results);
            querySchemaResDTO.setData(data);
            querySchemaResDTO.setRoute(SchemaDataEnum.DESIGNER.getCode());
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "pr-debug", LogUtils.SUCCESS,
                    JsonUtils.objectToString(querySchemaDebugDTO), JsonUtils.objectToString(querySchemaResDTO), "");
        }catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "analysisQuestion", TroubleToolCodeEnum.ADT_901_0111.getErrCode(),
                    JsonUtils.objectToString(querySchemaDebugDTO), TroubleToolCodeEnum.ADT_901_0111.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0111.getSuggestion());
        }
        return querySchemaResDTO;
    }

    /**
     *  2.1.2
     * 根据入参 组装 timer 语义实体
     * @param querySchemaDebugDTO 约定入参
     * @return Map<String, Object> timer condition
     */
    private static Map<String, Object> assembleTimeCondition(QuerySchemaDebugDTO querySchemaDebugDTO) {
        List<Map<String, Object>> items = new ArrayList<>();
        Optional.ofNullable(querySchemaDebugDTO.getTimeName())
                .ifPresent(name -> {
                    items.add(QuerySchemaConditionItem.builderGte(querySchemaDebugDTO));
                    items.add(QuerySchemaConditionItem.builderLte(querySchemaDebugDTO));
                });
        Optional.ofNullable(querySchemaDebugDTO.getDimensionName())
                .ifPresent(name -> items.add(QuerySchemaConditionItem.QuerySchemaConditionDemission.builderDemission(querySchemaDebugDTO)));
        Map<String, Object> condition = new HashMap<>();
        condition.put("logitype", "and");
        condition.put("items", items);
        Map<String, Object> data = new HashMap<>();
        data.put("condition", condition);
        data.put("name", "filter");
        data.put("technique", "filter");
        return data;
    }

    /**
     *  2.1.3
     * 根据入参 组装 sort 语义实体
     * @param querySchemaDebugDTO 约定入参
     * @return Map<String, Object> sort condition
     */
    private static Map<String, Object> assembleSortCondition(QuerySchemaDebugDTO querySchemaDebugDTO) {
        List<Map<String, Object>> items = new ArrayList<>();
        Optional.ofNullable(querySchemaDebugDTO.getSortName())
                .ifPresent(name -> items.add(ConditionStatisticsSort.builderSort(querySchemaDebugDTO)));
        Map<String, Object> condition = new HashMap<>();
        Map<String, Object> data = new HashMap<>();
        condition.put("fields", new ArrayList<>());
        condition.put("statistics", items);
        data.put("condition", condition);
        data.put("name", "sort");
        data.put("technique", "group");
        return data;
    }

    /**
     *  2.1.4
     * 根据入参 组装 limit 语义实体
     * @param querySchemaDebugDTO 约定入参
     * @return Map<String, Object> limit condition
     */
    private static Map<String, Object> assembleLimitCondition(QuerySchemaDebugDTO querySchemaDebugDTO) {
        List<Map<String, Object>> items = new ArrayList<>();
        Optional.ofNullable(querySchemaDebugDTO.getLimitName())
                .ifPresent(name -> items.add(ConditionStatisticsLimit.builderLimit(querySchemaDebugDTO)));
        Map<String, Object> condition = new HashMap<>();
        Map<String, Object> data = new HashMap<>();
        condition.put("fields", new ArrayList<>());
        condition.put("statistics", items);
        data.put("condition", condition);
        data.put("name", "limit");
        data.put("technique", "group");
        return data;
    }
}
