package com.digiwin.athena.adt.domain.dto.schema;

import com.digiwin.athena.appcore.util.LanguageUtils;
import lombok.Data;
import org.springframework.data.mongodb.core.mapping.Language;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/9/20 15:26
 * @Description: 语义showDefine
 */
@Data
public class SchemaMetricShowDefine implements Serializable {

    /** 呈现类型 */
    private List<ShowType> showType;

    /** 呈现规则 */
    private List<ShowItem> show;

    /**
     * 呈现粒度
     */
    private List<AliasGrain> aliasGrain;

    /** 维度区间 */
    private DimensionInterval dimensionInterval;

    @Data
    public static class ShowType {

        private String actionId;

        private List<TypeItem> type;

        @Data
        public static class TypeItem {

            private String title;

            private String value;

            private Map<String,Object> language;

        }

    }

    @Data
    public static class ShowItem {

        private ItemData itemData;

        @Data
        public static class ItemData {

            private boolean xTmpPendingProperties;

            private List<AgileRule> agileRule;

            @Data
            public static class AgileRule {

                private List<AreaDefine> rules;
                @Data
                public static class AreaDefine {

                    private List<String> applyToFields;

                    private String chart;
                }
            }
        }
    }

    @Data
    public static class DimensionInterval {
        private List<IntervalData> data;

        @Data
        public static class IntervalData {

            private String interval;
        }
    }

    @Data
    public static class AliasGrain {

        /**
         * 粒度字段
         */
        private String alias;

        /**
         * 粒度y/Q/M/W/d
         */
        private String grain;
    }
}
