package com.digiwin.athena.adt.domain.echo;

import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;

import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/7/25 16:27
 * @Description:
 */
public interface EchoService {

        /**
         * 非业务类异常上报
         * @param echoSubmitReq 入参
         * @param token token
         * @param tenantId 租户
         */
        void echoSubmit(EchoSubmitReq echoSubmitReq,String token,String tenantId);

        /**
         * 业务类异常上报
         * @param echoSubmitReq 入参
         * @param token token
         * @param tenantId 租户
         */
        void echoMongodbSubmit(EchoSubmitReq echoSubmitReq,String token,String tenantId);

        /**
         * 体验次数扣减
         * @return
         */
        Boolean echoChangeCharging(String token,String tenantId);

        /**
         * metric 上报
         * @param request request 入参
         * @param token token
         * @param tenantId 租户
         */
        void sendMetricDebugMessage(Map<String,Object> request, String token, String tenantId);
}
