package com.digiwin.athena.adt.domain.echo.impl;

import com.digiwin.athena.adt.agileReport.constant.ErrorCodeEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/7/25 16:27
 * @Description:
 */
@Slf4j
@Service
public class EchoServiceImpl implements EchoService {

    @Autowired(required = false)
    private RestTemplate restTemplate;

    @Value("${agiledataecho.url:}")
    private String echoUrl;
    @Override
    public void echoSubmit(EchoSubmitReq echoSubmitReq,String token,String tenantId) {
        long getQuerySchemaTook = System.currentTimeMillis();
        LogDto logDto = new LogDto("上报echo 业务日志 入参 echoSubmit :{} ", JsonUtils.objectToString(echoSubmitReq));
        log.info(logDto.toString());
        String url= echoUrl +"/api/ai/agile/echo/exception/submit";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token",token);
        headers.set("Routerkey",tenantId);
        HttpEntity httpEntity = new HttpEntity(echoSubmitReq,headers);
        try {
            ResponseEntity<BaseResultDTO<?>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<?>>() {
                    });
            LogDto logReturnDto = new LogDto("上报echo 业务日志 返参：" + response);
            log.info(logReturnDto.toString());
        } catch (ResourceAccessException e){
            log.error("agiledata_ADT_ :耗时:{},问题位置:{},问题描述:{},错误内容:{},可能原因及排错指引导:{}",
                    System.currentTimeMillis() - getQuerySchemaTook,
                    "敏捷数据助理入口(ADT)->上报echo 业务日志(ECHO) echoSubmit",
                    "调用ADE接口超时 ResourceAccessException",
                    JsonUtils.objectToString(echoSubmitReq),
                    "请联系平台处理");
            throw ErrorCodeEnum.ECHO_REALTIME_FAIL.getBusinessException();
        } catch (Exception e){
            log.error("{}, 请求body：{}, 报错信息：{}"
                    , ErrorCodeEnum.ECHO_GET_FAIL.getErrCode()
                    , JsonUtils.objectToString(echoSubmitReq)
                    , e.getMessage());
            throw ErrorCodeEnum.ECHO_GET_FAIL.getBusinessException();
        }
    }

    @Override
    public void echoMongodbSubmit(EchoSubmitReq echoSubmitReq, String token, String tenantId) {
        long getQuerySchemaTook = System.currentTimeMillis();
        LogDto logDto = new LogDto("上报echo mongodb 入参 echoSubmitReq :{} ", JsonUtils.objectToString(echoSubmitReq));
        log.info(logDto.toString());
        String url= echoUrl +"/api/ai/agile/echo/exception/mongo/submit";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token",token);
        headers.set("Routerkey",tenantId);
        HttpEntity httpEntity = new HttpEntity(echoSubmitReq,headers);
        try {
            ResponseEntity<BaseResultDTO<?>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<?>>() {
                    });
            LogDto logReturnDto = new LogDto("上报echo mongodb 返参：" + response);
            log.info(logReturnDto.toString());
        } catch (ResourceAccessException e){
            log.error("agiledata_ADT_ :耗时:{},问题位置:{},问题描述:{},错误内容:{},可能原因及排错指引导:{}",
                    System.currentTimeMillis() - getQuerySchemaTook,
                    "敏捷数据助理入口(ADT)->上报echo 业务日志(ECHO) echoMongodbSubmit",
                    "调用ADE接口超时 ResourceAccessException",
                    JsonUtils.objectToString(echoSubmitReq),
                    "请联系平台处理");
            throw ErrorCodeEnum.ECHO_REALTIME_FAIL.getBusinessException();
        } catch (Exception e){
            log.error("{}, 请求body：{}, 报错信息：{}"
                    , ErrorCodeEnum.ECHO_GET_FAIL.getErrCode()
                    , JsonUtils.objectToString(echoSubmitReq)
                    , e.getMessage());
            throw ErrorCodeEnum.ECHO_GET_FAIL.getBusinessException();
        }
    }

    @Override
    public Boolean echoChangeCharging(String token,String tenantId) {
        String url= echoUrl +"/api/ai/agile/echo/lite/changeCharging";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token",token);
        headers.set("Routerkey",tenantId);
        HttpEntity httpEntity = new HttpEntity(null,headers);
        try {
            ResponseEntity<BaseResultDTO<Boolean>> response = restTemplate.exchange(url, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Boolean>>() {
                    });
            LogDto logReturnDto = new LogDto("lite版本体验次数扣减 返参：" + response);
            log.info(logReturnDto.toString());
            return response.getBody().getResponse();
        } catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "liteDeduction", TroubleToolCodeEnum.ADT_901_0120.getErrCode(),
                    JsonUtils.objectToString(tenantId),TroubleToolCodeEnum.ADT_901_0120.getErrMsg()
                    , TroubleToolCodeEnum.ADT_901_0120.getSuggestion());
            log.error("{}, 请求body：{}, 报错信息：{}"
                    , ErrorCodeEnum.ECHO_GET_FAIL.getErrCode()
                    , tenantId
                    , e.getMessage());
            return false;
        }
    }

    @Override
    public void sendMetricDebugMessage(Map<String, Object> request, String token, String tenantId) {
        long getQuerySchemaTook = System.currentTimeMillis();
        LogDto logDto = new LogDto("metric debug 上报消息 :{} ", JsonUtils.objectToString(request));
        log.info(logDto.toString());
        String url= echoUrl +"/api/ai/agile/echo/exception/mongo/metric/check";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token",token);
        headers.set("Routerkey",tenantId);
        HttpEntity httpEntity = new HttpEntity(request,headers);
        try {
            ResponseEntity<BaseResultDTO<?>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<?>>() {
                    });
            LogDto logReturnDto = new LogDto("metric debug 上报消息 返参：" + response);
            log.info(logReturnDto.toString());
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "debugInfo", LogUtils.SUCCESS,
                    JsonUtils.objectToString(request),JsonUtils.objectToString(response), "");
        } catch (ResourceAccessException e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "debugInfo", TroubleToolCodeEnum.ADT_901_0125.getErrCode(),
                    JsonUtils.objectToString(request),TroubleToolCodeEnum.ADT_901_0125.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0125.getSuggestion());
            log.error("agiledata_ADT_ :耗时:{},问题位置:{},问题描述:{},错误内容:{},可能原因及排错指引导:{}",
                    System.currentTimeMillis() - getQuerySchemaTook,
                    "敏捷数据助理入口(ADT)->上报echo 业务日志(ECHO) echoMongodbSubmit",
                    "调用ADE接口超时 ResourceAccessException",
                    JsonUtils.objectToString(request),
                    "请联系平台处理");
            throw ErrorCodeEnum.ECHO_REALTIME_FAIL.getBusinessException();
        } catch (Exception e){
            LogUtils.buildAgileLog(LogUtils.MODULE_ADT, "debugInfo", TroubleToolCodeEnum.ADT_901_0124.getErrCode(),
                    JsonUtils.objectToString(request),TroubleToolCodeEnum.ADT_901_0124.getErrMsg(),
                    TroubleToolCodeEnum.ADT_901_0124.getSuggestion());
            log.error("{}, 请求body：{}, 报错信息：{}"
                    , ErrorCodeEnum.ECHO_GET_FAIL.getErrCode()
                    , JsonUtils.objectToString(request)
                    , e.getMessage());
            throw ErrorCodeEnum.ECHO_GET_FAIL.getBusinessException();
        }
    }
}
