package com.digiwin.athena.adt.domain.knowledge;

import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.KMScencDTO;
import com.digiwin.athena.adt.domain.dto.km.*;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import java.util.List;
import java.util.Map;

public interface KmService {

    /**
     * 获取场景信息
     * @param code
     * @param token
     * @return
     */
    KMScencDTO getKmSceneInfo(AthenaMessageEvent event,String code, String local, String token, String routerkey);

    /**
     * 获取场景code
     * @param params
     * @param token
     * @return
     */
    KMScencDTO getKmSceneCode(Map<String, Object> params,String local, String token);


    /**
     * 根据用户信息查询敏捷数据应用信息
     * @param  "0" 全部应用 "1" 敏舒应用
     * @param token
     * @param tenantId
     * @param userId
     * @return
     */
    List<KMPurchaseModelResDTO> queryKmPurchaseList(Integer type,String token, String tenantId,String userId);

    /**
     * 根据用户查询所有应用信息
     * @param token
     * @param tenantId
     * @param userId
     * @return
     */

    KMUserAppCodesResDTO queryKmUserAppCodes(String token, String tenantId,String userId);

    /**
     * 根据租户查询所有指标和场景编码集合
     * @param token token
     * @param tenantId 租户id
     * @return list
     */

    List<String> querySceneByTenantId(String token, String tenantId);

    List<KMApplicationApcResDTO> queryApplicationByCode(AuthoredUser user,String code);

    /**
     * 2.0 数据源指令集信息和开场白信息
     * @param user 用户
     * @param appCode 应用编码
     * @return 数据源信息
     */
    KMDatasetCommandIntentionsResDTO dataSetCommandIntentions(AuthoredUser user, String appCode);

    /**
     * 根据应用编码获取数据集列表信息
     * @param user user
     * @param appCode app
     * @param userLang lang
     * @return KMDataSetResDTO
     */
    List<KMDataSetResDTO> queryDataSetsByAppCode(AuthoredUser user, String appCode,String userLang);

    /**
     * 查看看板收藏问题信息
     * @param questionId
     * @return
     */
    ThemeMapBoardDTO getThemeMapBoardQuestion(AuthoredUser user,String questionId);

    /**
     * 根据租户查询应用版本号
     * @param user u
     * @return r
     */
    String getVersion(AuthoredUser user);

    Map<String,Object> updateCollectByConfig(AuthoredUser user, KMCollectConfigReqDTO kmCollectConfigReqDTO);

    KMCollectStepResDTO getCollectStep(AuthoredUser user, String questionId);
}
