package com.digiwin.athena.adt.domain.po;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;

/**
 * @Author: SunHong
 * @Date: 2025/3/31 9:50
 * @Description: 计费指标实体
 */
@Slf4j
@Data
@TableName("agile_data_cost_detail")
public class AgileDataCostDetail implements Serializable {

    /**
     * 自增主键
     */
    @TableId(value = "id",type = IdType.AUTO)
    private Integer id;

    /**
     * 应用 ID
     */
    private String appId;

    /**
     * 应用名称
     */
    private String appName;
    /**
     * 指标id
     */
    private String costId;

    /**
     * 指标名称
     */
    private String costName;

    /**
     * 来源
     */
    private String sourceName;

    /**
     * 用户 token
     */
    private String token;

    /**
     * 用户 id
     */
    private String userId;

    /**
     * 用户名称
     */
    private String userName;

    /**
     * 租户 id
     */
    private String tenantId;

    /**
     * 租户名称
     */
    private String tenantName;

    /**
     * 链路 id
     */
    private String pixId;

    /**
     * 计费类型: 0 按次 1 按量
     */
    private String costType;

    /**
     * 存储量
     */
    private Long costSize;

    /**
     * 是否同步：0 未同步 1 已同步
     */
    private String status;

    /**
     * 同步时间
     */
    private LocalDateTime syncTime;

    /**
     * 备注
     */
    private String memo;

    /**
     * 发生时间
     */
    private LocalDateTime createTime;

    public static AgileDataCostDetail builderPerCost(AuthoredUser user,String ptxId,
                                                     String appId,
                                                     String appName,
                                                     String sourceName) {
        AgileDataCostDetail agileDataCostDetail = new AgileDataCostDetail();
        agileDataCostDetail.setAppId(appId);
        agileDataCostDetail.setAppName(appName);
        agileDataCostDetail.setCostId("agileDataPerCost");
        agileDataCostDetail.setCostName("敏捷数据按次计费");
        agileDataCostDetail.setSourceName(sourceName);
        agileDataCostDetail.setToken(user.getToken());
        agileDataCostDetail.setUserId(user.getUserId());
        agileDataCostDetail.setUserName(user.getUserName());
        agileDataCostDetail.setTenantId(user.getTenantId());
        agileDataCostDetail.setTenantName(user.getTenantName());
        agileDataCostDetail.setPixId(ptxId);
        agileDataCostDetail.setCostType("0");
        agileDataCostDetail.setCostSize(1L);
        agileDataCostDetail.setStatus("0");
        agileDataCostDetail.setSyncTime(null);
        agileDataCostDetail.setMemo("");
        agileDataCostDetail.setCreateTime(LocalDateTime.now());
        return agileDataCostDetail;
    }

    public static AgileDataCostDetail builderTrafficCost(Map<String, Object> data,
                                                         AuthoredUser user,
                                                         String ptxId,
                                                         String appId,
                                                         String appName,
                                                         String sourceName) {
        long sizeInKB = 0L;
        if(Objects.nonNull(data)){
            sizeInKB =  calculateMapSizeInKB(data);
        }
        AgileDataCostDetail agileDataCostDetail = new AgileDataCostDetail();
        agileDataCostDetail.setAppId(appId);
        agileDataCostDetail.setAppName(appName);
        agileDataCostDetail.setCostId("agileDataTrafficCost");
        agileDataCostDetail.setCostName("敏捷数据按流量计费");
        agileDataCostDetail.setSourceName(sourceName);
        agileDataCostDetail.setToken(user.getToken());
        agileDataCostDetail.setUserId(user.getUserId());
        agileDataCostDetail.setUserName(user.getUserName());
        agileDataCostDetail.setTenantId(user.getTenantId());
        agileDataCostDetail.setTenantName(user.getTenantName());
        agileDataCostDetail.setPixId(ptxId);
        agileDataCostDetail.setCostType("1");
        agileDataCostDetail.setCostSize(sizeInKB);
        agileDataCostDetail.setStatus("0");
        agileDataCostDetail.setSyncTime(null);
        agileDataCostDetail.setMemo("");
        agileDataCostDetail.setCreateTime(LocalDateTime.now());
        return agileDataCostDetail;
    }

    public static long calculateMapSizeInKB(Map<String, Object> data) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos)) {
            // 将 Map 写入输出流
            oos.writeObject(data);
            // 获取字节数组的长度（以字节为单位）
            int byteSize = bos.toByteArray().length;
            // 将字节转换为 KB
            return byteSize / 1024;
        } catch (IOException e) {
            log.error("转换流量异常：{}",e.getMessage());
            return 0;
        }
    }
}
