package com.digiwin.athena.adt.domain.po;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import org.springframework.data.annotation.Transient;

import java.time.LocalDateTime;
import java.util.Map;

@Data
@TableName("agile_data")
public class SnapData {

    @TableId(value = "id",type = IdType.AUTO)
    private Integer id;

    /**
     * 快照ID
     */
    @TableField(value = "snapshotId")
    private String snapshotId;

    /**
     * 发起人ID
     */
    @TableField(value = "performerId")
    private String performerId;

    /**
     * 用户名
     */
    @TableField(value = "userName")
    private String userName;

    /**
     * 租户ID
     */
    @TableField(value = "tenantId")
    private String tenantId;

    /**
     * 侦测ID
     */
    @TableField(value = "detectionId")
    private String detectionId;

    /**
     * 处理时间
     */
    @TableField(value = "requestTime")
    private LocalDateTime requestTime;

    /**
     * 文档中心ID
     */
    @TableField(value = "dmcId")
    private String dmcId;

    /**
     * 读取次数ID
     */
    @TableField(value = "readCount")
    private Integer readCount;

    /**
     * 快照标题
     */
    @TableField(value = "title")
    private String title;

    /**
     * 是否完成 0：未完成，1：已完成
     */
    @TableField(value = "status")
    private Integer status;

    /**
     * 是否完成 0：图谱，1：资产中心
     */
    @TableField(value = "queryType")
    private String queryType;

    /**
     * 创建时间
     */
    @TableField(value = "createDate",fill = FieldFill.INSERT)
    private LocalDateTime createDate;

    /**
     * 修改时间
     */
    @TableField(value = "modifyDate", fill = FieldFill.UPDATE)
    private LocalDateTime modifyDate;

    /**
     * 场景编码
     */
    @TableField(value = "code")
    private String code;

    /**
     * 区别入口
     * 0：侦测 1：实时
     */
    @TableField(value = "entry")
    private Integer entry;

    /**
     * 消息类型 0.单场景消息1.多场景消息2.debug消息3.引用消息
     */
    @TableField(value = "messageType")
    private String messageType;

    /**
     * 删除失败计数器
     */
    @TableField(value = "deleteFailed")
    private Integer deleteFailed;

}
