package com.digiwin.athena.adt.domain.report;

import com.digiwin.athena.adt.agileReport.controller.dto.*;
import com.digiwin.athena.adt.domain.dto.AgileDataPanelResDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * 敏捷数据处理
 */
public interface AgileReportDataService {

    /**
     * 处理SD下发数据
     */
    String processSDData(String processData,String fileName,AuthoredUser user);

    /**
     * 处理雅典娜推送消息
     */
    Map<String,String > processMessage(HttpServletRequest request,AthenaMessageDTO athenaMessageDTO, AuthoredUser user);

    /**
     * 通过dmcID得到快照信息
     */
    SnapShotDTO getAgileReportInfo(String dmcId);

    /**
     * 补偿指标卡数据
     * @param snapShotDTO
     */
    void compensateAgileData(SnapShotDTO snapShotDTO);

    /**
     * 数据面板请求接口
     * @param request
     * @param req
     * @param user
     * @return
     */
    AgileDataPanelResDTO panelProcessMessage(HttpServletRequest request, AthenaMessageDTO req, AuthoredUser user);

    /**
     * 数据面板2.0请求接口
     * @param request
     * @param req
     * @param user
     * @return
     */
    Map<String,Object> panelFlagShipProcessMessage(HttpServletRequest request, AniaAssistantChatReqDTO req, AuthoredUser user);

    /**
     * 流式问句 1.0
     * @param request req
     * @param athenaMessageDTO 1.0
     * @param user user
     * @return steam
     */
    SseEmitter sseProcessMessage(HttpServletRequest request, AthenaMessageDTO athenaMessageDTO, AuthoredUser user);

    AgileDataDetailUrlDTO getDataDetailUrl(AuthoredUser user, String snapshotId, String locale);

    /**
     * 流式问句2.0
     * @param request req
     * @param aniaAssistantChatReqDTO 2.0
     * @param user user
     * @return steam
     */
    SseEmitter sseProcessMessageV2(HttpServletRequest request, AniaAssistantChatReqDTO aniaAssistantChatReqDTO, AuthoredUser user);

    /**
     * 2.0 问数 数据总结
     * @param agileDataSummarizeReqDTO req
     * @param user u
     * @return res AgileDataSummarizeResDTO
     */
    AgileDataSummarizeResDTO getAgileDataSummarize(AgileDataSummarizeReqDTO agileDataSummarizeReqDTO, AuthoredUser user);

    Map<String,Object> getAppVersion(AuthoredUser user, String appCode);
}
