package com.digiwin.athena.adt.sse.domain;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.app.config.OkHttpUtil;
import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;

import java.util.concurrent.TimeUnit;

/**
 * sse客户端入参构建
 */
@Slf4j
public class EventStreamClient {

    public static ConnectionPool connectionPool = new ConnectionPool(100, 5, TimeUnit.MINUTES);

    public static void executeSSE(AthenaMessageEvent event, String url,
                                  EventSourceListener eventSourceListener,
                                  JSONObject requestBody, SSEBaseEvent sseBaseEvent) {
        sseBaseEvent.getEvent().setGetQuerySchemaTook(System.currentTimeMillis());
        RequestBody formBody = RequestBody.create(MediaType.parse("application/json; charset=utf-8"), requestBody.toJSONString());
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.addHeader("content-type", "application/json");
        requestBuilder.addHeader(GlobalConstant.IAM_IDENTITY_TYPE_TOKEN, event.getUser().getToken());
        requestBuilder.addHeader(GlobalConstant.IAM_USER_TOKEN, event.getUser().getToken());
        requestBuilder.addHeader(GlobalConstant.IAM_APP_TOKEN, GlobalConstant.IAM_APP_TOKEN_ATHENA);
        requestBuilder.addHeader("locale", event.getLang());
        requestBuilder.addHeader("Routerkey", event.getUser().getTenantId());
        requestBuilder.addHeader("ptxId", event.getPtxId());
        requestBuilder.addHeader("messageId", String.valueOf(event.getGenerateSerialNo()));
        requestBuilder.addHeader("userId", event.getUser().getUserId());
        requestBuilder.tag(JSONObject.class, requestBody);
        log.error("agiledata_ADT_{}_{}_{}_{}_{}:获取用户提问，语义识别，语义入参：{}",
                event.getUser().getUserId(),event.getUser().getUserName()
                ,event.getUser().getTenantId(),event.getUser().getTenantName(), event.getQuestion(), JsonUtils.objectToString(requestBody));
        Request request = requestBuilder.url(url).post(formBody).build();
        EventSource.Factory factory = EventSources.createFactory(OkHttpUtil.getInstance());
        factory.newEventSource(request, eventSourceListener);
    }

}
