package com.digiwin.athena.adt.sse.domain;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

@Getter
@AllArgsConstructor
public enum SseAniaEventEnum {

    CHAT_CREATED("chat.created","对话开始"),
    CHAT_IN_PROGRESS("chat.in_progress","服务端检查数据结构通过后正在处理对话"),
    MESSAGE_DELTA("message.delta","消息数据"),
    MESSAGE_COMPLETED("message.completed","某一处理过程完成，type!=verbose时仅显示处理过程，type=verbose时代表当下轮次message.delta回答完成。"),
    CHAT_COMPLETED("chat.completed","服务端处理完成。收到此标记后前端取消显示\"终止回答\""),
    CHAT_FAILED("chat.failed","此事件用于标识对话失败。 收到此标记后前端取消显示\"终止回答\""),
    CHAT_DONE ("chat.done","本次会话的流式返回正常结束");

    private final String event;
    private final String desc;

    @Getter
    @AllArgsConstructor
    public enum SseEventDataTypeEnum {
        INTENT_RECOGNITION("intent_recognition","intent_recognition_finish","意图识别完成"),
        ANSWER("answer",null,"意图识别完成"),
        VERBOSE("verbose","{\"msg_type\":\"generate_answer_finish\"}","阶段消息类型"),
        ;
        private final String type;
        private final String defaultValue;
        private final String desc;

        public static SseEventDataTypeEnum getEventDataType(String type) {
            if(StringUtils.isNotBlank(type)){
                for (SseEventDataTypeEnum eventDataType : SseEventDataTypeEnum.values()) {
                    if (eventDataType.getType().equals(type)) {
                        return eventDataType;
                    }
                }
            }
            return null;
        }

        public static boolean isContainType(String type) {
            return Objects.nonNull(getEventDataType(type));
        }
    }

    @Getter
    @AllArgsConstructor
    public enum EventDataMessageEnum {
        TEXT("text","文本消息"),
        FILE("file","附件消息"),
        CARD("card","卡片消息"),
        ;
        private final String messageType;
        private final String desc;
    }

}
