package com.digiwin.athena.adt.sse.domain;

import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;
import com.digiwin.athena.adt.sse.utils.SseEmitterUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import lombok.extern.slf4j.Slf4j;

/**
 * SSE超时监听回调组件
 */
@Slf4j
public class SseEmitterTimeOutCallbackComponent implements Runnable{

    private SSEBaseEvent sseBaseEvent;

    public SseEmitterTimeOutCallbackComponent(SSEBaseEvent sseBaseEvent){
        this.sseBaseEvent = sseBaseEvent;
    }

    @Override
    public void run() {
        log.info("当前对话执行时间过长，进行阻断，信息ID:{}",sseBaseEvent.getId());
        //标记消息结束
        sseBaseEvent.setIsOver(true);
        //语义SSE监听取消
        if(!sseBaseEvent.getIsScrumOver()){
            sseBaseEvent.getScrumEventSource().cancel();
        }
        //推送超时提示消息
        String answer = MessageUtil.getMessageByLanguage("message.adt.sse.service.timeout",sseBaseEvent.getLang());
        EventData eventData = new EventData(SseAniaEventEnum.MESSAGE_DELTA.getEvent(),
                SseAniaEventEnum.SseEventDataTypeEnum.ANSWER.getType(),
                SseAniaEventEnum.EventDataMessageEnum.TEXT.getMessageType(), answer);
        SseEmitterUtils.send(sseBaseEvent.getAniaEmitter(), eventData);
        //推送娜娜结束事件
        EventData doneData = new EventData(SseAniaEventEnum.CHAT_FAILED.getEvent(), null);
        SseEmitterUtils.send(sseBaseEvent.getAniaEmitter(), doneData);
    }
}
